/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.plot;

import org.basex.data.Data;
import org.basex.data.StatsKey;
import org.basex.gui.view.plot.PlotData;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.hash.TokenSet;

final class PlotAxis {
    private static final int TEXTLENGTH = 11;
    private final PlotData plotData;
    int attrID;
    int nrCats;
    StatsKey.Kind type;
    double[] co = new double[0];
    double startvalue;
    byte[] firstCat;
    byte[] lastCat;
    int nrCaptions;
    double actlCaptionStep;
    private double calculatedCaptionStep;
    double min;
    double max;
    boolean log;
    private boolean tag;
    private double logMin;
    private double logMax;

    PlotAxis(PlotData data) {
        this.plotData = data;
    }

    private void initialize() {
        this.tag = false;
        this.type = StatsKey.Kind.INT;
        this.co = new double[0];
        this.nrCats = -1;
        this.firstCat = Token.EMPTY;
        this.lastCat = Token.EMPTY;
        this.nrCaptions = 0;
        this.actlCaptionStep = -1.0;
        this.calculatedCaptionStep = -1.0;
        this.min = -2.147483648E9;
        this.max = 2.147483647E9;
        this.startvalue = 0.0;
    }

    boolean setAxis(String attribute) {
        if (attribute == null) {
            return false;
        }
        this.initialize();
        byte[] b = Token.token(attribute);
        this.tag = !Token.contains(b, 64);
        b = Token.delete(b, 64);
        Data data = this.plotData.context.data;
        this.attrID = (this.tag ? data.tagindex : data.atnindex).id(b);
        this.refreshAxis();
        return true;
    }

    void refreshAxis() {
        int[] items;
        StatsKey key;
        Data data = this.plotData.context.data;
        StatsKey statsKey = key = this.tag ? data.tagindex.stat(this.attrID) : data.atnindex.stat(this.attrID);
        if (key == null) {
            return;
        }
        this.type = key.kind;
        if (this.type == null) {
            return;
        }
        if (this.type == StatsKey.Kind.CAT) {
            this.type = StatsKey.Kind.TEXT;
        }
        if ((items = this.plotData.pres).length < 1) {
            return;
        }
        this.co = new double[items.length];
        byte[][] vals = new byte[items.length][];
        int i = 0;
        while (i < items.length) {
            byte[] value = this.getValue(items[i]);
            if (this.type == StatsKey.Kind.TEXT && value.length > 11) {
                value = Token.substring(value, 0, 11);
            }
            vals[i] = Token.lc(value);
            ++i;
        }
        if (this.type == StatsKey.Kind.TEXT) {
            this.textToNum(vals);
        } else {
            this.minMax(vals);
            if (this.log) {
                this.prepareLogAxis();
            } else {
                this.prepareLinAxis();
            }
            i = 0;
            while (i < vals.length) {
                this.co[i] = this.calcPosition(vals[i]);
                ++i;
            }
        }
    }

    private void textToNum(byte[][] vals) {
        int[] tmpI = Array.createOrder(vals, false, true);
        int vl = vals.length;
        int i = 0;
        while (i < vl && vals[i].length == 0) {
            this.co[tmpI[i++]] = -1.0;
        }
        this.nrCats = new TokenSet(vals).size();
        if (i > 0) {
            --this.nrCats;
        }
        this.firstCat = i < vl ? vals[i] : Token.EMPTY;
        this.lastCat = i < vl ? vals[vl - 1] : Token.EMPTY;
        int p = 0;
        while (i < vl) {
            byte[] b = vals[i];
            int l = i;
            while (l < vl && Token.eq(vals[l], b)) {
                ++l;
            }
            while (i < l) {
                double d = this.nrCats != 1 ? 1.0 / (double)(this.nrCats - 1) * (double)p : 0.5;
                this.co[tmpI[i++]] = d;
            }
            ++p;
        }
    }

    private double calcPosition(byte[] value) {
        if (value.length == 0) {
            return -1.0;
        }
        double range = this.max - this.min;
        if (range == 0.0) {
            return 0.5;
        }
        double d = Token.toDouble(value);
        if (!this.log) {
            return 1.0 / range * (d - this.min);
        }
        range = this.logMax - this.logMin;
        if (this.min < 0.0 && this.max >= 0.0) {
            double p = 1.0 / (this.logMin + this.logMax) * this.logMin;
            if (d == 0.0) {
                return p;
            }
            if (d < 0.0) {
                return 1.0 - (1.0 - p) - 1.0 / this.logMin * this.ln(d) * p;
            }
            return p + 1.0 / this.logMax * this.ln(d) * (1.0 - p);
        }
        return 1.0 / range * (this.ln(d) - this.logMin);
    }

    double calcPosition(double value) {
        return this.calcPosition(Token.token(value));
    }

    private double ln(double d) {
        return d == 0.0 ? 0.0 : Math.log1p(Math.abs(d));
    }

    byte[] getValue(int pre) {
        Data data = this.plotData.context.data;
        int limit = pre + data.size(pre, 1);
        int p = pre;
        while (p < limit) {
            int kind = data.kind(p);
            if ((kind == 1 && this.tag || kind == 3 && !this.tag) && this.attrID == data.name(p)) {
                return data.atom(p);
            }
            ++p;
        }
        return Token.EMPTY;
    }

    private void minMax(byte[][] vals) {
        this.min = 2.147483647E9;
        this.max = -2.147483648E9;
        int i = -1;
        boolean b = false;
        while (++i < vals.length) {
            if (vals[i].length <= 0) continue;
            b = true;
            double d = Token.toDouble(vals[i]);
            if (d < this.min) {
                this.min = d;
            }
            if (!(d > this.max)) continue;
            this.max = d;
        }
        if (!b) {
            this.min = 0.0;
            this.max = 0.0;
        }
        if (this.log) {
            this.logMin = this.ln(this.min);
            this.logMax = this.ln(this.max);
            return;
        }
    }

    private void prepareLinAxis() {
        double range = Math.abs(this.max - this.min);
        if (range == 0.0) {
            return;
        }
        if (range < 1.0) {
            double tmin;
            double dec = 1.0 / range;
            double pow = (int)(Math.floor(Math.log10(dec) + 0.5) + 1.0) * 2;
            double fac = (int)Math.pow(10.0, pow);
            double tmax = this.max * fac;
            pow = (range = Math.abs(tmax - (tmin = this.min * fac))) < 10.0 ? 0 : (int)Math.floor(Math.log10(range) + 0.5) - 1;
            this.calculatedCaptionStep = (int)Math.pow(10.0, pow);
            this.calculatedCaptionStep /= fac;
            return;
        }
        int pow = range < 10.0 ? 0 : (int)Math.floor(Math.log10(range) + 0.5) - 1;
        this.calculatedCaptionStep = (int)Math.pow(10.0, pow);
    }

    private void prepareLogAxis() {
    }

    void calcCaption(int space) {
        if (this.type == StatsKey.Kind.DBL || this.type == StatsKey.Kind.INT) {
            double range = Math.abs(this.max - this.min);
            if (range == 0.0) {
                this.nrCaptions = 1;
                return;
            }
            if (this.log) {
                this.startvalue = this.min;
                this.nrCaptions = 3;
                return;
            }
            boolean dbl = this.type == StatsKey.Kind.DBL;
            this.actlCaptionStep = this.calculatedCaptionStep;
            this.nrCaptions = (int)(range / this.actlCaptionStep) + 1;
            while (2 * this.nrCaptions * 10 * 3 < space && (dbl || this.actlCaptionStep % 2.0 == 0.0)) {
                this.actlCaptionStep /= 2.0;
                this.nrCaptions = (int)(range / this.actlCaptionStep);
            }
            while (this.nrCaptions * 10 * 3 > space) {
                this.actlCaptionStep *= 2.0;
                this.nrCaptions = (int)(range / this.actlCaptionStep);
            }
            this.startvalue = this.min + this.actlCaptionStep - this.min % this.actlCaptionStep;
            if (this.startvalue - this.min < this.actlCaptionStep / 4.0) {
                this.startvalue += this.actlCaptionStep;
            }
        } else {
            this.nrCaptions = space / 30;
            if (this.nrCaptions > this.nrCats) {
                this.nrCaptions = this.nrCats;
            }
            this.actlCaptionStep = 1.0 / (double)(this.nrCaptions - 1);
        }
    }
}

