/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import org.basex.data.Data;
import org.basex.gui.GUIProp;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.map.BinaryAlgo;
import org.basex.gui.view.map.MapAlgo;
import org.basex.gui.view.map.MapList;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;
import org.basex.gui.view.map.SliceDiceAlgo;
import org.basex.gui.view.map.SplitAlgo;
import org.basex.gui.view.map.SquarifiedAlgo;
import org.basex.gui.view.map.StripAlgo;

final class MapLayout {
    final MapRects rectangles = new MapRects();
    private final int off;
    private final Data data;
    private final MapAlgo algo;
    private final int[] textLen;
    private final GUIProp prop;
    final MapRect layout;

    MapLayout(Data d, int[] tl, GUIProp pr) {
        this.data = d;
        this.textLen = tl;
        this.prop = pr;
        this.off = this.prop.num(GUIProp.FONTSIZE) + 4;
        switch (this.prop.num(GUIProp.MAPOFFSETS)) {
            case 1: {
                this.layout = new MapRect(0, 2, 0, 2);
                break;
            }
            case 2: {
                this.layout = new MapRect(0, this.off, 0, this.off);
                break;
            }
            case 3: {
                this.layout = new MapRect(2, this.off - 1, 4, this.off + 1);
                break;
            }
            case 4: {
                this.layout = new MapRect(this.off >> 2, this.off, this.off >> 1, this.off + (this.off >> 2));
                break;
            }
            default: {
                this.layout = new MapRect(0, 0, 0, 0);
            }
        }
        switch (this.prop.num(GUIProp.MAPALGO)) {
            case 1: {
                this.algo = new StripAlgo();
                break;
            }
            case 2: {
                this.algo = new SquarifiedAlgo();
                break;
            }
            case 3: {
                this.algo = new SliceDiceAlgo();
                break;
            }
            case 4: {
                this.algo = new BinaryAlgo();
                break;
            }
            default: {
                this.algo = new SplitAlgo();
            }
        }
    }

    private MapList children(int par) {
        MapList list = new MapList();
        int last = par + ViewData.size(this.data, par);
        boolean atts = this.prop.is(GUIProp.MAPATTS);
        int p = par + (atts ? 1 : this.data.attSize(par, this.data.kind(par)));
        while (p < last) {
            list.add(p);
            p += ViewData.size(this.data, p);
        }
        return list;
    }

    void makeMap(MapRect r, MapList l, int ns, int ne) {
        if (ne - ns == 0) {
            r.pre = l.get(ns);
            this.putRect(r);
        } else {
            int nn = 0;
            if (r.level == 0) {
                int is = l.size();
                int i = 0;
                while (i < is) {
                    nn += ViewData.size(this.data, l.get(i));
                    ++i;
                }
            } else {
                nn = l.get(ne) - l.get(ns) + ViewData.size(this.data, l.get(ne));
            }
            l.initWeights(this.textLen, nn, this.data, this.prop.num(GUIProp.MAPWEIGHT));
            MapRects rects = this.algo.calcMap(r, l, ns, ne);
            for (MapRect rect : rects) {
                if (rect.x + rect.w > r.x + r.w || rect.y + rect.h > r.y + r.h) continue;
                this.putRect(rect);
            }
        }
    }

    private void putRect(MapRect r) {
        int x = r.x + this.layout.x;
        int y = r.y + this.layout.y;
        int w = r.w - this.layout.w;
        int h = r.h - this.layout.h;
        if (w < this.off && h < this.off || w <= 2 || h <= 2) {
            r.leaf = true;
            this.rectangles.add(r);
            return;
        }
        this.rectangles.add(r);
        MapList ch = this.children(r.pre);
        int cs = ch.size();
        if (cs != 0) {
            r.leaf = false;
            this.makeMap(new MapRect(x, y, w, h, r.pre, r.level + 1), ch, 0, cs - 1);
        }
    }
}

