/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.map;

import java.awt.Color;
import java.awt.Graphics;
import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.map.MapPainter;
import org.basex.gui.view.map.MapRect;
import org.basex.gui.view.map.MapRects;
import org.basex.gui.view.map.MapRenderer;
import org.basex.gui.view.map.MapView;

final class MapDefault
extends MapPainter {
    MapDefault(MapView m, GUIProp pr) {
        super(m, pr);
    }

    @Override
    void drawRectangles(Graphics g, MapRects rects, float scale) {
        MapRect l = this.view.layout.layout;
        l.x = (int)scale * l.x;
        l.y = (int)scale * l.y;
        l.w = (int)scale * l.w;
        l.h = (int)scale * l.h;
        int ww = this.view.getWidth();
        int hh = this.view.getWidth();
        Data data = this.view.gui.context.data;
        int off = this.prop.num(GUIProp.MAPOFFSETS);
        int rs = rects.size;
        int ri = 0;
        while (ri < rs) {
            MapRect r = rects.get(ri);
            int pre = r.pre;
            int lvl = r.level;
            boolean full = r.w == ww && r.h == hh;
            Color col = this.color(rects, ri);
            boolean mark = col != null;
            r.pos = this.view.gui.context.marked.ftpos != null ? this.view.gui.context.marked.ftpos.get(data, pre) : null;
            g.setColor(mark ? col : GUIConstants.color(lvl));
            if (r.w < l.x + l.w || r.h < l.y + l.h || off < 2 || ViewData.leaf(this.prop, data, pre)) {
                g.fillRect(r.x, r.y, r.w, r.h);
            } else {
                g.fillRect(r.x, r.y, l.x, r.h);
                g.fillRect(r.x, r.y, r.w, l.y);
                g.fillRect(r.x + r.w - l.w, r.y, l.w, r.h);
                g.fillRect(r.x, r.y + r.h - l.h, r.w, l.h);
            }
            if (!full) {
                col = mark ? GUIConstants.colormark3 : GUIConstants.color(lvl + 2);
                g.setColor(col);
                g.drawRect(r.x, r.y, r.w, r.h);
                col = mark ? GUIConstants.colormark4 : GUIConstants.color(Math.max(0, lvl - 2));
                g.setColor(col);
                g.drawLine(r.x + r.w, r.y, r.x + r.w, r.y + r.h);
                g.drawLine(r.x, r.y + r.h, r.x + r.w, r.y + r.h);
            }
            if (r.w > 3 && r.h >= this.prop.num(GUIProp.FONTSIZE)) {
                this.drawRectangle(g, r);
            }
            ++ri;
        }
    }

    @Override
    boolean drawRectangle(Graphics g, MapRect rect) {
        rect.x += 3;
        rect.w -= 3;
        int pre = rect.pre;
        Context context = this.view.gui.context;
        Data data = context.data;
        Nodes current = context.current;
        int kind = data.kind(pre);
        int fsz = this.prop.num(GUIProp.FONTSIZE);
        if (kind == 1 || kind == 0) {
            byte[] name = kind == 0 ? ViewData.content(data, pre, true) : (current.size() == 1L && pre != 0 && pre == current.list[0] ? ViewData.path(data, pre) : ViewData.tag(this.prop, data, pre));
            g.setColor(Color.black);
            g.setFont(GUIConstants.font);
            BaseXLayout.chopString(g, name, rect.x, rect.y, rect.w, fsz);
        } else {
            g.setColor(GUIConstants.color(rect.level * 2 + 8));
            g.setFont(GUIConstants.mfont);
            byte[] text = ViewData.content(data, pre, false);
            boolean bl = rect.thumb = MapRenderer.calcHeight(g, rect, text, fsz) >= rect.h;
            if (rect.thumb) {
                MapRenderer.drawThumbnails(g, rect, text, fsz);
            } else {
                MapRenderer.drawText(g, rect, text, fsz);
            }
        }
        rect.x -= 3;
        rect.w += 3;
        return true;
    }
}

