/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import java.awt.Container;
import java.awt.Window;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.Nodes;
import org.basex.gui.GUI;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.dialog.DialogHelp;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.util.Array;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;

public final class ViewNotifier {
    public static final long LARGEDB = 200000000L;
    public static final int MAXHIST = 20;
    public int hist;
    final GUI gui;
    private final Nodes[] marked = new Nodes[20];
    private final Nodes[] cont = new Nodes[20];
    private final String[] queries = new String[20];
    private View[] view = new View[0];
    private int maxhist;

    public ViewNotifier(GUI main) {
        this.gui = main;
    }

    void add(View v) {
        this.view = Array.add(this.view, v);
    }

    public void init() {
        int n;
        int n2;
        Container[] containerArray;
        Context ctx = this.gui.context;
        Data data = ctx.data;
        if (data != null) {
            View v;
            this.cont[0] = ctx.current;
            this.marked[0] = new Nodes(data);
            long fs = data.meta.dbsize();
            boolean close = false;
            View[] viewArray = this.view;
            int n3 = this.view.length;
            int n4 = 0;
            while (n4 < n3) {
                v = viewArray[n4];
                close |= v.visible() && v.db();
                ++n4;
            }
            if (close && fs > 200000000L && Dialog.confirm(this.gui, Util.info(Text.OPENLARGE, Performance.format(fs)))) {
                viewArray = this.view;
                n3 = this.view.length;
                n4 = 0;
                while (n4 < n3) {
                    v = viewArray[n4];
                    if (v.visible() && v.db()) {
                        v.visible(false);
                    }
                    ++n4;
                }
            }
        } else {
            containerArray = this.gui.getOwnedWindows();
            n2 = containerArray.length;
            n = 0;
            while (n < n2) {
                Dialog d;
                Window w = containerArray[n];
                if (w.isVisible() && w instanceof Dialog && !(d = (Dialog)w).isModal() && !(w instanceof DialogHelp)) {
                    ((Dialog)w).cancel();
                }
                ++n;
            }
        }
        this.gui.context.focused = -1;
        this.hist = 0;
        this.maxhist = 0;
        containerArray = this.view;
        n2 = this.view.length;
        n = 0;
        while (n < n2) {
            Container v = containerArray[n];
            ((View)v).refreshInit();
            ++n;
        }
        this.gui.layoutViews();
        this.gui.setTitle(data != null ? data.meta.name : null);
    }

    public void focus(int pre, View vw) {
        if (this.gui.context.focused == pre) {
            return;
        }
        this.gui.context.focused = pre;
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v != vw && v.visible()) {
                v.refreshFocus();
            }
            ++n2;
        }
        if (pre != -1) {
            this.gui.status.setText(Token.string(ViewData.path(this.gui.context.data, pre)));
        }
    }

    public void mark(Nodes mark, View vw) {
        Context context = this.gui.context;
        context.marked = mark;
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v != vw && v.visible()) {
                v.refreshMark();
            }
            ++n2;
        }
        this.gui.filter.setEnabled(mark.size() != 0L);
        this.gui.refreshControls();
    }

    public void mark(int mode, View vw) {
        int f = this.gui.context.focused;
        if (f == -1) {
            return;
        }
        Context context = this.gui.context;
        Nodes nodes = context.marked;
        if (mode == 0) {
            nodes = new Nodes(f, context.data);
        } else if (mode == 1) {
            nodes.union(new int[]{f});
        } else {
            nodes.toggle(f);
        }
        this.mark(nodes, vw);
    }

    public void hist(boolean forward) {
        Context context = this.gui.context;
        String query = "";
        if (forward) {
            if (this.hist == this.maxhist) {
                return;
            }
            query = this.queries[++this.hist];
        } else {
            if (this.hist == 0) {
                return;
            }
            this.marked[this.hist] = context.marked;
            query = this.queries[--this.hist];
        }
        context.set(this.cont[this.hist], this.marked[this.hist]);
        this.gui.input.setText(query);
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v.visible()) {
                v.refreshContext(forward, false);
            }
            ++n2;
        }
        this.gui.refreshControls();
    }

    public void context(Nodes nodes, boolean quick, View vw) {
        Context context = this.gui.context;
        Nodes n = new Nodes(new int[0], context.data, context.marked.ftpos);
        if (!this.cont[this.hist].sameAs(quick ? context.current : context.marked)) {
            this.checkHist();
            if (!quick) {
                String in;
                this.queries[this.hist] = in = this.gui.input.getText();
                this.marked[this.hist] = context.marked;
                this.cont[++this.hist] = nodes;
                this.queries[this.hist] = in;
                this.marked[this.hist] = n;
            } else {
                this.queries[this.hist] = "";
                this.marked[this.hist] = new Nodes(context.data);
                this.cont[++this.hist] = context.current;
            }
            this.maxhist = this.hist;
        }
        context.set(nodes, n);
        View[] viewArray = this.view;
        int n2 = this.view.length;
        int n3 = 0;
        while (n3 < n2) {
            View v = viewArray[n3];
            if (v != vw && v.visible()) {
                v.refreshContext(true, quick);
            }
            ++n3;
        }
        this.gui.refreshControls();
    }

    public void update() {
        Context context = this.gui.context;
        if (context.data == null) {
            return;
        }
        this.hist = 0;
        this.maxhist = 0;
        context.marked = new Nodes(new int[0], context.data);
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            if (v.visible()) {
                v.refreshUpdate();
            }
            ++n2;
        }
        this.gui.refreshControls();
    }

    public void layout() {
        if (this.gui.help != null) {
            this.gui.help.refresh();
        }
        View[] viewArray = this.view;
        int n = this.view.length;
        int n2 = 0;
        while (n2 < n) {
            View v = viewArray[n2];
            v.refreshLayout();
            ++n2;
        }
    }

    public String tooltip(boolean back) {
        return back ? (this.hist > 0 ? (this.hist > 1 ? this.queries[this.hist - 2] : "") : null) : (this.hist < this.maxhist ? this.queries[this.hist + 1] : null);
    }

    private void checkHist() {
        int hl = this.queries.length;
        if (this.hist + 1 == hl) {
            Array.move(this.queries, 1, 0, hl - 1);
            Array.move(this.cont, 1, 0, hl - 1);
            Array.move(this.marked, 1, 0, hl - 1);
            --this.hist;
        }
    }
}

