/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view;

import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXSplit;
import org.basex.gui.view.ViewLayout;
import org.basex.gui.view.ViewPanel;
import org.basex.util.Array;

final class ViewAlignment
implements ViewLayout {
    final boolean horiz;
    ViewLayout[] comp = new ViewLayout[0];

    ViewAlignment(boolean h) {
        this.horiz = h;
    }

    void add(ViewLayout obj) {
        this.add(obj, this.comp.length);
    }

    void add(ViewLayout obj, int o) {
        int n = this.comp.length;
        ViewLayout[] tmp = new ViewLayout[n + 1];
        System.arraycopy(this.comp, 0, tmp, 0, o);
        System.arraycopy(this.comp, o, tmp, o + 1, n - o);
        this.comp = tmp;
        this.comp[o] = obj;
    }

    private void remove(int o) {
        this.comp = Array.delete(this.comp, o);
    }

    @Override
    public boolean isVisible() {
        ViewLayout[] viewLayoutArray = this.comp;
        int n = this.comp.length;
        int n2 = 0;
        while (n2 < n) {
            ViewLayout c = viewLayoutArray[n2];
            if (c.isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setVisibility(boolean db) {
        ViewLayout[] viewLayoutArray = this.comp;
        int n = this.comp.length;
        int n2 = 0;
        while (n2 < n) {
            ViewLayout c = viewLayoutArray[n2];
            c.setVisibility(db);
            ++n2;
        }
    }

    @Override
    public boolean delete(ViewPanel panel) {
        int o = 0;
        while (o < this.comp.length) {
            if (this.comp[o].delete(panel)) {
                if (this.comp[o] instanceof ViewPanel) {
                    this.remove(o--);
                } else {
                    this.comp[o] = ((ViewAlignment)this.comp[o]).comp[0];
                }
            }
            ++o;
        }
        return this.comp.length < 2;
    }

    @Override
    public void createView(BaseXBack panel) {
        if (!this.isVisible()) {
            return;
        }
        BaseXSplit split = new BaseXSplit(this.horiz);
        ViewLayout[] viewLayoutArray = this.comp;
        int n = this.comp.length;
        int n2 = 0;
        while (n2 < n) {
            ViewLayout c = viewLayoutArray[n2];
            c.createView(split);
            ++n2;
        }
        panel.add(split);
    }

    @Override
    public String layoutString() {
        StringBuilder str = new StringBuilder(this.horiz ? "H " : "V ");
        ViewLayout[] viewLayoutArray = this.comp;
        int n = this.comp.length;
        int n2 = 0;
        while (n2 < n) {
            ViewLayout c = viewLayoutArray[n2];
            str.append(c.layoutString());
            ++n2;
        }
        str.append("- ");
        return str.toString();
    }

    public String toString() {
        return String.valueOf(this.horiz ? "Horizontal" : "Vertical") + " Layout";
    }
}

