/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.layout;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.dialog.Dialog;
import org.basex.io.IOFile;
import org.basex.util.Util;

public final class BaseXFileChooser {
    private GUI gui;
    private JFileChooser fc;
    private FileDialog fd;
    private String suffix;

    public BaseXFileChooser(String title, String path, GUI main) {
        if (main.gprop.is(GUIProp.SIMPLEFD)) {
            this.fd = new FileDialog((Frame)main, title);
            this.fd.setDirectory(new File(path).getPath());
        } else {
            this.fc = new JFileChooser(path);
            File file = new File(path);
            if (!file.isDirectory()) {
                this.fc.setSelectedFile(file);
            }
            this.fc.setDialogTitle(title);
            this.gui = main;
        }
    }

    public void addFilter(String dsc, String ... suf) {
        if (this.fc != null) {
            FileFilter ff = this.fc.getFileFilter();
            this.fc.addChoosableFileFilter(new Filter(suf, dsc));
            this.fc.setFileFilter(ff);
        } else {
            this.fd.setFile("*" + suf[0]);
        }
        if (this.suffix == null) {
            this.suffix = suf[0];
        }
    }

    public IOFile select(Mode mode) {
        IOFile io = null;
        if (this.fd != null) {
            if (mode == Mode.FDOPEN) {
                this.fd.setFile(" ");
            }
            this.fd.setMode(mode == Mode.FSAVE || mode == Mode.DSAVE ? 1 : 0);
            this.fd.setVisible(true);
            String f = this.fd.getFile();
            if (f == null) {
                return null;
            }
            String dir = this.fd.getDirectory();
            return new IOFile(mode == Mode.DOPEN || mode == Mode.DSAVE ? dir : String.valueOf(dir) + "/" + this.fd.getFile());
        }
        int state = 0;
        switch (mode) {
            case FOPEN: {
                state = this.fc.showOpenDialog(this.gui);
                break;
            }
            case FDOPEN: {
                this.fc.setFileSelectionMode(2);
                state = this.fc.showOpenDialog(this.gui);
                break;
            }
            case FSAVE: {
                state = this.fc.showSaveDialog(this.gui);
                break;
            }
            case DOPEN: 
            case DSAVE: {
                this.fc.setFileSelectionMode(1);
                state = this.fc.showDialog(this.gui, null);
            }
        }
        if (state != 0) {
            return null;
        }
        io = new IOFile(this.fc.getSelectedFile().getPath());
        if (mode != Mode.FSAVE) {
            return io;
        }
        if (this.suffix != null && io.path().indexOf(".") == -1) {
            io = new IOFile(String.valueOf(io.path()) + this.suffix);
        }
        return !io.exists() || Dialog.confirm(this.gui, Util.info(Text.FILEREPLACE, io)) ? io : null;
    }

    private static class Filter
    extends FileFilter {
        private final String[] sufs;
        private final String desc;

        Filter(String[] s, String d) {
            this.sufs = s;
            this.desc = d;
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String name = file.getName().toLowerCase();
            String[] stringArray = this.sufs;
            int n = this.sufs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (name.endsWith(s)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public String getDescription() {
            StringBuilder sb = new StringBuilder();
            String[] stringArray = this.sufs;
            int n = this.sufs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append('*').append(s);
                ++n2;
            }
            return String.valueOf(this.desc) + " (" + sb + ")";
        }
    }

    public static enum Mode {
        FOPEN,
        FDOPEN,
        DOPEN,
        FSAVE,
        DSAVE;

    }
}

