/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.gui.GUI;
import org.basex.gui.dialog.Dialog;
import org.basex.gui.layout.BaseXBack;
import org.basex.gui.layout.BaseXButton;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXMem;
import org.basex.gui.layout.TableLayout;
import org.basex.util.Performance;
import org.basex.util.Util;

public final class DialogProgress
extends Dialog
implements ActionListener {
    private static final int MAX = 500;
    private final Timer timer = new Timer(100, this);
    private final BaseXLabel info = new BaseXLabel(" ", true, true);
    private final BaseXMem mem;
    private final Command command;
    private final JProgressBar bar;

    DialogProgress(GUI main, String message, Command cmd) {
        super(main, message, false);
        this.set(this.info, "North");
        if (cmd.supportsProg()) {
            this.bar = new JProgressBar(0, 500);
            this.set(this.bar, "Center");
        } else {
            this.bar = null;
        }
        BaseXLayout.setWidth(this.info, 500);
        BaseXBack s = new BaseXBack(new BorderLayout()).border(10, 0, 0, 0);
        BaseXBack m = new BaseXBack(new TableLayout(1, 2, 5, 0));
        this.mem = new BaseXMem(this, false);
        m.add(new BaseXLabel(Text.MEMUSED));
        m.add(this.mem);
        s.add((Component)m, "West");
        if (cmd.stoppable()) {
            BaseXButton cancel = new BaseXButton(Text.BUTTONCANCEL, this);
            cancel.setMnemonic();
            s.add((Component)cancel, "East");
        }
        this.set(s, "South");
        this.command = cmd;
        this.timer.start();
        this.finish(null);
    }

    @Override
    public void cancel() {
        this.command.stop();
        this.close();
    }

    @Override
    public void close() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.timer.stop();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setTitle(this.command.title());
        String detail = this.command.detail();
        this.info.setText(detail.isEmpty() ? " " : detail);
        this.mem.repaint();
        if (this.bar != null) {
            this.bar.setValue((int)(this.command.progress() * 500.0));
        }
    }

    public static void execute(final Dialog d, final String t, final Command ... cmds) {
        new Thread(){

            @Override
            public void run() {
                d.setEnabled(false);
                GUI gui = d.gui;
                Command[] commandArray = cmds;
                int n = cmds.length;
                int n2 = 0;
                while (n2 < n) {
                    Command cmd = commandArray[n2];
                    boolean newData = cmd.newData(gui.context);
                    if (newData) {
                        gui.notify.init();
                    }
                    DialogProgress wait = new DialogProgress(gui, t, cmd);
                    wait.setAlwaysOnTop(true);
                    Performance perf = new Performance();
                    gui.updating = cmd.updating(gui.context);
                    boolean ok = cmd.run(gui.context);
                    gui.updating = false;
                    String info = cmd.info();
                    String time = perf.toString();
                    gui.info.setInfo(info, cmd, time, ok);
                    gui.info.reset();
                    gui.status.setText(Util.info(Text.PROCTIME, time));
                    wait.dispose();
                    if (!ok) {
                        Dialog.error(gui, info.equals("Interrupted.") ? Text.CANCELCREATE : info);
                    }
                    if (newData) {
                        gui.notify.init();
                    } else if (cmd.updating(gui.context)) {
                        gui.notify.update();
                    }
                    ++n2;
                }
                d.setEnabled(true);
                d.action(null);
            }
        }.start();
    }
}

