/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import org.basex.core.cmd.InfoStorage;
import org.basex.data.DataText;
import org.basex.data.MetaData;
import org.basex.data.NSNode;
import org.basex.data.Namespaces;
import org.basex.index.DocIndex;
import org.basex.index.Index;
import org.basex.index.IndexIterator;
import org.basex.index.IndexToken;
import org.basex.index.Names;
import org.basex.index.path.PathSummary;
import org.basex.io.random.TableAccess;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.IntList;

public abstract class Data {
    public static final byte DOC = 0;
    public static final byte ELEM = 1;
    public static final byte TEXT = 2;
    public static final byte ATTR = 3;
    public static final byte COMM = 4;
    public static final byte PI = 5;
    public MetaData meta;
    public Names tagindex;
    public Names atnindex;
    public Namespaces ns;
    public PathSummary pthindex;
    public DocIndex docindex = new DocIndex(this);
    public int nameID;
    public int sizeID;
    protected TableAccess table;
    protected Index txtindex;
    protected Index atvindex;
    protected Index ftxindex;
    private byte[] b = new byte[16];
    private int bp;

    public void init() throws IOException {
        this.nameID = this.atnindex.id(DataText.NAME);
        this.sizeID = this.atnindex.id(DataText.SIZE);
    }

    public abstract void close() throws IOException;

    public abstract void flush();

    public final boolean empty() {
        return this.meta.size == 1 && this.kind(0) == 0;
    }

    public final boolean single() {
        return this.meta.size == this.size(0, 0);
    }

    public abstract void closeIndex(IndexToken.IndexType var1) throws IOException;

    public abstract void setIndex(IndexToken.IndexType var1, Index var2);

    public final synchronized IndexIterator ids(IndexToken token) {
        switch (token.type()) {
            case TEXT: {
                return this.txtindex.ids(token);
            }
            case ATTRIBUTE: {
                return this.atvindex.ids(token);
            }
            case FULLTEXT: {
                return this.ftxindex.ids(token);
            }
        }
        return null;
    }

    public final synchronized int nrIDs(IndexToken token) {
        switch (token.type()) {
            case TEXT: {
                return this.txtindex.nrIDs(token);
            }
            case ATTRIBUTE: {
                return this.atvindex.nrIDs(token);
            }
            case FULLTEXT: {
                return this.ftxindex.nrIDs(token);
            }
        }
        return Integer.MAX_VALUE;
    }

    public final IntList doc() {
        return this.docindex.doc();
    }

    public final IntList doc(String input) {
        return this.docindex.doc(input);
    }

    public final synchronized byte[] info(IndexToken.IndexType type) {
        switch (type) {
            case TAG: {
                return this.tagindex.info();
            }
            case ATTNAME: {
                return this.atnindex.info();
            }
            case TEXT: {
                return this.txtindex.info();
            }
            case ATTRIBUTE: {
                return this.atvindex.info();
            }
            case FULLTEXT: {
                return this.ftxindex.info();
            }
            case PATH: {
                return this.pthindex.info(this);
            }
        }
        return Token.EMPTY;
    }

    public final byte[] atom(int pre) {
        switch (this.kind(pre)) {
            case 2: 
            case 4: {
                return this.text(pre, true);
            }
            case 3: {
                return this.text(pre, false);
            }
            case 5: {
                byte[] txt = this.text(pre, true);
                int i = Token.indexOf(txt, 32);
                return i == -1 ? Token.EMPTY : Token.substring(txt, i + 1);
            }
        }
        TokenBuilder tb = null;
        byte[] t = Token.EMPTY;
        int p = pre;
        int s = p + this.size(p, this.kind(p));
        while (p != s) {
            int k = this.kind(p);
            if (k == 2) {
                byte[] txt = this.text(p, true);
                if (t == Token.EMPTY) {
                    t = txt;
                } else {
                    if (tb == null) {
                        tb = new TokenBuilder(t);
                    }
                    tb.add(txt);
                }
            }
            p += this.attSize(p, k);
        }
        return tb == null ? t : tb.finish();
    }

    public final int pre(int id) {
        int p = Math.max(0, id);
        while (p < this.meta.size) {
            if (id == this.id(p)) {
                return p;
            }
            ++p;
        }
        p = 0;
        int ps = Math.min(this.meta.size, id);
        while (p < ps) {
            if (id == this.id(p)) {
                return p;
            }
            ++p;
        }
        return -1;
    }

    public final int id(int pre) {
        return this.table.read4(pre, 12);
    }

    public final int kind(int pre) {
        return this.table.read1(pre, 0) & 7;
    }

    public final int parent(int pre, int kind) {
        return pre - this.dist(pre, kind);
    }

    private int dist(int pre, int kind) {
        switch (kind) {
            case 1: {
                return this.table.read4(pre, 4);
            }
            case 2: 
            case 4: 
            case 5: {
                return this.table.read4(pre, 8);
            }
            case 3: {
                int d = this.table.read1(pre, 0) >> 3 & 0x1F;
                if (d >= 31) {
                    while (d < pre && this.kind(pre - d) == 3) {
                        ++d;
                    }
                }
                return d;
            }
        }
        return pre + 1;
    }

    public final int size(int pre, int kind) {
        return kind == 1 || kind == 0 ? this.table.read4(pre, 8) : 1;
    }

    public final int attSize(int pre, int kind) {
        int s;
        int n = s = kind == 1 ? this.table.read1(pre, 0) >> 3 & 0x1F : 1;
        if (s >= 31) {
            while (s < this.meta.size - pre && this.kind(pre + s) == 3) {
                ++s;
            }
        }
        return s;
    }

    public final byte[] attValue(int att, int pre) {
        int a = pre + this.attSize(pre, this.kind(pre));
        int p = pre;
        while (++p != a) {
            if (this.name(p) != att) continue;
            return this.text(p, false);
        }
        return null;
    }

    public final int name(int pre) {
        return this.table.read2(pre, 1) & Short.MAX_VALUE;
    }

    public final byte[] name(int pre, int kind) {
        if (kind == 5) {
            byte[] name = this.text(pre, true);
            int i = Token.indexOf(name, 32);
            return i == -1 ? name : Token.substring(name, 0, i);
        }
        return (kind == 1 ? this.tagindex : this.atnindex).key(this.name(pre));
    }

    public final int uri(int pre, int kind) {
        return kind == 1 || kind == 3 ? this.table.read1(pre, kind == 1 ? 3 : 11) & 0xFF : 0;
    }

    public final boolean nsFlag(int pre) {
        return (this.table.read1(pre, 1) & 0x80) != 0;
    }

    public final Atts ns(int pre) {
        Atts as = new Atts();
        if (this.nsFlag(pre)) {
            int[] nsp = this.ns.get(pre);
            int n = 0;
            while (n < nsp.length) {
                as.add(this.ns.pref(nsp[n]), this.ns.uri(nsp[n + 1]));
                n += 2;
            }
        }
        return as;
    }

    protected final long textOff(int pre) {
        return this.table.read5(pre, 3);
    }

    public abstract byte[] text(int var1, boolean var2);

    public abstract long textItr(int var1, boolean var2);

    public abstract double textDbl(int var1, boolean var2);

    public abstract int textLen(int var1, boolean var2);

    public final void update(int pre, int kind, byte[] name, byte[] uri) {
        this.meta.update();
        if (kind == 5) {
            this.text(pre, Token.trim(Token.concat(name, Token.SPACE, this.atom(pre))), true);
        } else {
            int p;
            int ou = this.ns.uri(name, pre);
            boolean ne = ou == 0 && uri.length != 0;
            int n = p = kind == 3 ? this.parent(pre, kind) : pre;
            int u = ne ? this.ns.add(p, p, Token.pref(name), uri) : (ou != 0 && Token.eq(this.ns.uri(ou), uri) ? ou : 0);
            this.table.write1(pre, kind == 1 ? 3 : 11, u);
            this.table.write2(pre, 1, (this.nsFlag(pre) ? 32768 : 0) | (kind == 1 ? this.tagindex : this.atnindex).index(name, null, false));
            this.table.write2(p, 1, (ne || this.nsFlag(p) ? 32768 : 0) | this.name(p));
        }
    }

    public final void update(int pre, int kind, byte[] value) {
        this.meta.update();
        if (kind == 0) {
            this.docindex.update();
        }
        this.text(pre, kind == 5 ? Token.trim(Token.concat(this.name(pre, kind), Token.SPACE, value)) : value, kind != 3);
    }

    public final void replace(int rpre, Data data) {
        this.meta.update();
        this.docindex.replace(rpre, data);
        int dsize = data.meta.size;
        this.buffer(dsize);
        int rkind = this.kind(rpre);
        int rsize = this.size(rpre, rkind);
        int rpar = this.parent(rpre, rkind);
        int dpre = 0;
        while (dpre < dsize) {
            int dkind = data.kind(dpre);
            int dpar = data.parent(dpre, dkind);
            int pre = rpre + dpre;
            int dis = dpar >= 0 ? dpre - dpar : pre - this.parent(rpre, rkind);
            switch (dkind) {
                case 0: {
                    this.doc(pre, data.size(dpre, dkind), data.text(dpre, true));
                    ++this.meta.ndocs;
                    break;
                }
                case 1: {
                    byte[] nm = data.name(dpre, dkind);
                    this.elem(dis, this.tagindex.index(nm, null, false), data.attSize(dpre, dkind), data.size(dpre, dkind), this.ns.uri(nm, true), false);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(pre, dis, data.text(dpre, true), dkind);
                    break;
                }
                case 3: {
                    byte[] nm = data.name(dpre, dkind);
                    this.attr(pre, dis, this.atnindex.index(nm, null, false), data.text(dpre, false), this.ns.uri(nm, false), false);
                }
            }
            ++dpre;
        }
        this.table.replace(rpre, this.buffer(), rsize);
        this.buffer(1);
        int diff = dsize - rsize;
        if (diff == 0) {
            return;
        }
        int p = rpar;
        while (p >= 0) {
            int k = this.kind(p);
            this.size(p, k, this.size(p, k) + diff);
            p = this.parent(p, k);
        }
        this.updateDist(rpre + dsize, diff);
        if (data.kind(0) == 3) {
            int d = 0;
            int i = 0;
            while (i < dsize && data.kind(i++) == 3) {
                ++d;
            }
            if (d > 1) {
                this.attSize(rpar, this.kind(rpar), d + 1);
            }
        }
    }

    public final void delete(int pre) {
        boolean empty;
        this.meta.update();
        int k = this.kind(pre);
        int s = this.size(pre, k);
        boolean bl = empty = pre == 0 && s == this.meta.size;
        if (!empty) {
            this.docindex.delete(pre, s);
        }
        this.ns.delete(pre, s);
        int par = pre;
        if (k == 3) {
            par = this.parent(par, 3);
            this.attSize(par, 1, this.attSize(par, 1) - 1);
            this.size(par, 1, this.size(par, 1) - 1);
            k = this.kind(par);
        }
        while (par > 0 && k != 0) {
            par = this.parent(par, k);
            k = this.kind(par);
            this.size(par, k, this.size(par, k) - s);
        }
        int p = pre;
        if (empty) {
            ++p;
            --s;
        } else if (this.kind(p) == 0) {
            --this.meta.ndocs;
        }
        this.table.delete(pre, s);
        this.updateDist(p, -s);
        this.ns.update(pre, s, false, null);
        if (empty) {
            this.doc(0, 1, Token.EMPTY);
            this.table.set(0, this.buffer());
        }
    }

    public final void insertAttr(int pre, int par, Data data) {
        this.insert(pre, par, data);
        this.attSize(par, 1, this.attSize(par, 1) + data.meta.size);
    }

    public final void insert(int ipre, int ipar, Data data) {
        this.meta.update();
        this.docindex.insert(ipre, data);
        boolean dummy = this.empty() && data.kind(0) == 0;
        int dsize = data.meta.size;
        int buf = Math.min(dsize, 256);
        this.buffer(buf);
        TokenMap nsScope = new TokenMap();
        NSNode n = this.ns.current;
        do {
            int i = 0;
            while (i < n.vals.length) {
                nsScope.add(this.ns.pref(n.vals[i]), this.ns.uri(n.vals[i + 1]));
                i += 2;
            }
            int pos = n.fnd(ipar);
            if (pos < 0) break;
            n = n.ch[pos];
        } while (n.pre <= ipar && ipar < n.pre + this.size(n.pre, 1));
        IntList preStack = new IntList();
        int dpre = -1;
        NSNode t = this.ns.current;
        HashSet<NSNode> newNodes = new HashSet<NSNode>();
        while (++dpre != dsize) {
            if (dpre != 0 && dpre % buf == 0) {
                this.insert(ipre + dpre - buf);
            }
            int pre = ipre + dpre;
            int dkind = data.kind(dpre);
            int dpar = data.parent(dpre, dkind);
            int dis = dpar >= 0 ? dpre - dpar : pre - ipar;
            int par = pre - dis;
            if (dpre == 0) {
                int cI;
                LinkedList<NSNode> cand = new LinkedList<NSNode>();
                NSNode cn = this.ns.root;
                cand.add(cn);
                while ((cI = cn.fnd(par)) > -1) {
                    cn = cn.ch[cI];
                    cand.add(0, cn);
                }
                cn = this.ns.root;
                if (cand.size() > 1) {
                    int ancPre = par;
                    NSNode curr = (NSNode)cand.remove(0);
                    while (ancPre > -1 && cn == this.ns.root) {
                        if (curr.pre == ancPre) {
                            cn = curr;
                        } else if (curr.pre < ancPre) {
                            while ((ancPre = this.parent(ancPre, this.kind(ancPre))) > curr.pre) {
                            }
                            if (curr.pre == ancPre) {
                                cn = curr;
                            }
                        }
                        if (cand.size() <= 0) continue;
                        curr = (NSNode)cand.remove(0);
                    }
                }
                this.ns.setNearestRoot(cn, par);
            }
            while (preStack.size() != 0 && preStack.peek() > par) {
                this.ns.close(preStack.pop());
            }
            switch (dkind) {
                case 0: {
                    int s = data.size(dpre, dkind);
                    this.doc(pre, s, data.text(dpre, true));
                    ++this.meta.ndocs;
                    this.ns.open();
                    preStack.push(pre);
                    break;
                }
                case 1: {
                    boolean ne = false;
                    if (data.nsFlag(dpre)) {
                        Atts at = data.ns(dpre);
                        int a = 0;
                        while (a < at.size) {
                            byte[] old = nsScope.get(at.key[a]);
                            if (old == null || !Token.eq(old, at.val[a])) {
                                newNodes.add(this.ns.add(at.key[a], at.val[a], pre));
                                ne = true;
                            }
                            ++a;
                        }
                    }
                    this.ns.open();
                    byte[] nm = data.name(dpre, dkind);
                    this.elem(dis, this.tagindex.index(nm, null, false), data.attSize(dpre, dkind), data.size(dpre, dkind), this.ns.uri(nm, true), ne);
                    preStack.push(pre);
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    this.text(pre, dis, data.text(dpre, true), dkind);
                    break;
                }
                case 3: {
                    byte[] nm = data.name(dpre, dkind);
                    if (data.nsFlag(dpre)) {
                        this.ns.add(par, preStack.size() == 0 ? ipar : preStack.peek(), Token.pref(nm), data.ns.uri(data.uri(dpre, dkind)));
                        this.table.write2(ipar, 1, 0x8000 | this.name(ipar));
                    }
                    this.attr(pre, dis, this.atnindex.index(nm, null, false), data.text(dpre, false), this.ns.uri(nm, false), false);
                }
            }
        }
        while (preStack.size() != 0) {
            this.ns.close(preStack.pop());
        }
        this.ns.setRoot(t);
        if (this.bp != 0) {
            this.insert(ipre + dpre - 1 - (dpre - 1) % buf);
        }
        this.buffer(1);
        int p = ipar;
        while (p >= 0) {
            int k = this.kind(p);
            this.size(p, k, this.size(p, k) + dsize);
            p = this.parent(p, k);
        }
        this.updateDist(ipre + dsize, dsize);
        this.ns.update(ipre, dsize, true, newNodes);
        if (dummy) {
            this.delete(0);
        }
    }

    private void updateDist(int pre, int size) {
        int p = pre;
        while (p < this.meta.size) {
            int k = this.kind(p);
            this.dist(p, k, this.dist(p, k) + size);
            p += this.size(p, this.kind(p));
        }
    }

    public final void size(int pre, int kind, int value) {
        if (kind == 1 || kind == 0) {
            this.table.write4(pre, 8, value);
        }
    }

    protected final void textOff(int pre, long off) {
        this.table.write5(pre, 3, off);
    }

    protected abstract void text(int var1, byte[] var2, boolean var3);

    private void dist(int pre, int kind, int value) {
        if (kind == 3) {
            this.table.write1(pre, 0, value << 3 | 3);
        } else if (kind != 0) {
            this.table.write4(pre, kind == 1 ? 4 : 8, value);
        }
    }

    private void attSize(int pre, int kind, int value) {
        if (kind == 1) {
            this.table.write1(pre, 0, value << 3 | 1);
        }
    }

    public final void buffer(int size) {
        int bs = size << 4;
        if (this.b.length != bs) {
            this.b = new byte[bs];
        }
    }

    public final void insert(int pre) {
        this.table.insert(pre, this.buffer());
    }

    public final void doc(int pre, int size, byte[] value) {
        int i = this.newID();
        long v = this.index(value, pre, true);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void elem(int dist, int name, int asize, int size, int uri, boolean ne) {
        int i = this.newID();
        int n = ne ? 128 : 0;
        this.s(Math.min(31, asize) << 3 | 1);
        this.s(n | (byte)(name >> 8));
        this.s(name);
        this.s(uri);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(size >> 24);
        this.s(size >> 16);
        this.s(size >> 8);
        this.s(size);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void text(int pre, int dist, byte[] value, int kind) {
        int i = this.newID();
        long v = this.index(value, pre, true);
        this.s(kind);
        this.s(0);
        this.s(0);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(dist >> 24);
        this.s(dist >> 16);
        this.s(dist >> 8);
        this.s(dist);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    public final void attr(int pre, int dist, int name, byte[] value, int uri, boolean ne) {
        int i = this.newID();
        long v = this.index(value, pre, false);
        int n = ne ? 128 : 0;
        this.s(Math.min(31, dist) << 3 | 3);
        this.s(n | (byte)(name >> 8));
        this.s(name);
        this.s(v >> 32);
        this.s(v >> 24);
        this.s(v >> 16);
        this.s(v >> 8);
        this.s(v);
        this.s(0);
        this.s(0);
        this.s(0);
        this.s(uri);
        this.s(i >> 24);
        this.s(i >> 16);
        this.s(i >> 8);
        this.s(i);
    }

    private void s(int value) {
        this.b[this.bp++] = (byte)value;
    }

    private int newID() {
        return ++this.meta.lastid;
    }

    private void s(long value) {
        this.b[this.bp++] = (byte)value;
    }

    private byte[] buffer() {
        byte[] bb = this.bp == this.b.length ? this.b : Arrays.copyOf(this.b, this.bp);
        this.bp = 0;
        return bb;
    }

    protected abstract long index(byte[] var1, int var2, boolean var3);

    public final String toString(int start, int end) {
        return Token.string(InfoStorage.table(this, start, end));
    }

    public final String toString() {
        return this.toString(0, this.meta.size);
    }
}

