/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Context;
import org.basex.core.Text;
import org.basex.io.IOFile;

public final class DropBackup
extends Command {
    public DropBackup(String name) {
        super(4, name);
    }

    @Override
    protected boolean run() {
        if (!DropBackup.validName(this.args[0], true)) {
            return this.error(Text.NAMEINVALID, this.args[0]);
        }
        String[] stringArray = this.databases(this.args[0]);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String db = stringArray[n2];
            DropBackup.drop(db.contains("-") ? db : String.valueOf(db) + '-', this.context);
            ++n2;
        }
        return this.info(Text.DBBACKDROP, String.valueOf(this.args[0]) + "*" + ".zip");
    }

    public static int drop(String db, Context ctx) {
        IOFile dir = ctx.mprop.dbpath();
        int c = 0;
        IOFile[] iOFileArray = dir.children();
        int n = iOFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IOFile f = iOFileArray[n2];
            String n3 = f.name();
            if (n3.startsWith(db) && n3.endsWith(".zip") && f.delete()) {
                ++c;
            }
            ++n2;
        }
        return c;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.DROP) + " " + (Object)((Object)Commands.CmdDrop.BACKUP)).args();
    }
}

