/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.Text;
import org.basex.core.cmd.DropDB;

public final class Copy
extends Command {
    private int of;
    private int tf;

    public Copy(String db, String newdb) {
        super(4, db, newdb);
    }

    @Override
    protected boolean run() {
        String db = this.args[0];
        String newdb = this.args[1];
        if (!Copy.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        if (!Copy.validName(newdb, false)) {
            return this.error(Text.NAMEINVALID, newdb);
        }
        if (!this.mprop.dbexists(db)) {
            return this.error(Text.DBNOTFOUND, db);
        }
        if (this.mprop.dbexists(newdb)) {
            return this.error(Text.DBEXISTS, newdb);
        }
        return this.copy(db, newdb) ? this.info(Text.DBCOPY, db, this.perf) : this.error(Text.DBNOCOPY, db);
    }

    private boolean copy(String db, String newdb) {
        File src = this.mprop.dbpath(db);
        File trg = this.mprop.dbpath(newdb);
        String[] files = src.list();
        if (files == null || !trg.mkdir()) {
            return false;
        }
        this.tf = files.length;
        boolean ok = true;
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            ++this.of;
            try {
                Copy.copy(new File(src, file), new File(trg, file));
            }
            catch (IOException ex) {
                ok = false;
                break;
            }
            ++n2;
        }
        if (!ok) {
            DropDB.drop(newdb, this.mprop);
        }
        return ok;
    }

    public static synchronized void copy(File src, File trg) throws IOException {
        byte[] buf = new byte[(int)Math.min(src.length(), 0x400000L)];
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            int i;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(trg);
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    protected String tit() {
        return Text.BUTTONCOPY;
    }

    @Override
    public boolean supportsProg() {
        return true;
    }

    @Override
    protected double prog() {
        return (double)this.of / (double)this.tf;
    }
}

