/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.file;

import java.io.IOException;
import org.basex.build.SingleParser;
import org.basex.build.file.ParserProp;
import org.basex.core.Prop;
import org.basex.io.IO;
import org.basex.io.in.BufferInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class TextParser
extends SingleParser {
    private static final byte[] TEXT = Token.token("text");
    private static final byte[] LINE = Token.token("line");
    private final boolean lines;
    private final String encoding;

    public TextParser(IO path, String ta, Prop prop) throws IOException {
        super(path, ta);
        ParserProp props = new ParserProp(prop.get(Prop.PARSEROPT));
        this.lines = props.is(ParserProp.LINES);
        String e = props.get(ParserProp.ENCODING);
        this.encoding = e != null ? e : "UTF-8";
    }

    @Override
    public void parse() throws IOException {
        int ch;
        this.builder.startElem(TEXT, this.atts);
        BufferInput bi = new BufferInput(this.src.path());
        bi.encoding(this.encoding);
        TokenBuilder tb = new TokenBuilder();
        while ((ch = bi.readChar()) != 0) {
            if (ch == 10 && this.lines) {
                this.builder.startElem(LINE, this.atts);
                this.builder.text(tb.finish());
                this.builder.endElem(LINE);
                tb.reset();
                continue;
            }
            if (ch == 13) continue;
            tb.add(ch);
        }
        bi.close();
        if (!this.lines) {
            this.builder.text(tb.finish());
        }
        this.builder.endElem(TEXT);
    }
}

