/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.BuildException;
import org.basex.build.Parser;
import org.basex.core.Progress;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.data.Namespaces;
import org.basex.index.Names;
import org.basex.index.path.PathSummary;
import org.basex.util.Atts;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public abstract class Builder
extends Progress {
    public MetaData meta;
    protected final PathSummary path = new PathSummary();
    protected final Namespaces ns = new Namespaces();
    protected final Parser parser;
    protected final Prop prop;
    protected final String name;
    protected final Names tags;
    protected final Names atts;
    protected int ssize;
    protected int spos;
    private final IntList pstack = new IntList();
    private final IntList tstack = new IntList();
    private boolean inDoc;
    private int lvl;
    private int c;

    protected Builder(String nm, Parser parse, Prop pr) {
        this.parser = parse;
        this.prop = pr;
        this.name = nm;
        int cats = pr.num(Prop.CATEGORIES);
        this.tags = new Names(cats);
        this.atts = new Names(cats);
    }

    protected final void parse() throws IOException {
        Performance perf = Util.debug ? new Performance() : null;
        Util.debug(String.valueOf(this.tit()) + "...", new Object[0]);
        this.parser.parse(this);
        if (this.lvl != 0) {
            this.error("%: Closing tag </%> expected.", this.parser.detail(), this.tags.key(this.tstack.get(this.lvl)));
        }
        this.meta.lastid = this.meta.size - 1;
        if (this.meta.size == 0) {
            this.startDoc(Token.token(this.name));
            this.endDoc();
            this.setSize(0, this.meta.size);
        }
        Util.gc(perf);
    }

    public final void startDoc(byte[] value) throws IOException {
        this.pstack.set(this.lvl++, this.meta.size);
        if (this.meta.pathindex) {
            this.path.index(0, (byte)0, this.lvl);
        }
        this.addDoc(value);
        this.ns.open();
    }

    public final void endDoc() throws IOException {
        int pre = this.pstack.get(--this.lvl);
        this.setSize(pre, this.meta.size - pre);
        ++this.meta.ndocs;
        this.ns.close(this.meta.size);
        this.inDoc = false;
    }

    public final void startNS(byte[] pref, byte[] uri) {
        this.ns.add(pref, uri, this.meta.size);
    }

    public final int startElem(byte[] nm, Atts att) throws IOException {
        int pre = this.addElem(nm, att);
        ++this.lvl;
        return pre;
    }

    public final void emptyElem(byte[] nm, Atts att) throws IOException {
        this.addElem(nm, att);
        this.ns.close(this.pstack.get(this.lvl));
    }

    public final void endElem(byte[] nm) throws IOException {
        this.checkStop();
        if (--this.lvl == 0 || this.tags.id(nm) != this.tstack.get(this.lvl)) {
            this.error("%: </%> found, </%> expected.", this.parser.detail(), nm, this.tags.key(this.tstack.get(this.lvl)));
        }
        int pre = this.pstack.get(this.lvl);
        this.setSize(pre, this.meta.size - pre);
        this.ns.close(pre);
    }

    public final void text(byte[] value) throws IOException {
        boolean ignore;
        byte[] t = this.meta.chop ? Token.trim(value) : value;
        boolean bl = ignore = !this.inDoc || this.lvl == 1;
        if ((this.meta.chop && t.length != 0 || !Token.ws(t)) && ignore) {
            this.error(this.inDoc ? "%: No text allowed after closed root tag." : "%: No text allowed before root tag.", this.parser.detail());
        }
        if (t.length != 0 && !ignore) {
            this.addText(t, (byte)2);
        }
    }

    public final void comment(byte[] value) throws IOException {
        this.addText(value, (byte)4);
    }

    public final void pi(byte[] pi) throws IOException {
        this.addText(pi, (byte)5);
    }

    public final void encoding(String enc) {
        this.meta.encoding = enc.equals("UTF-8") || enc.equals("UTF8") ? "UTF-8" : enc;
    }

    @Override
    public final String tit() {
        return Text.PROGCREATE;
    }

    @Override
    public final String det() {
        return this.spos == 0 ? this.parser.detail() : Text.DBFINISH;
    }

    @Override
    public final double prog() {
        return this.spos == 0 ? this.parser.progress() : (double)this.spos / (double)this.ssize;
    }

    public abstract Data build() throws IOException;

    public abstract void close() throws IOException;

    protected abstract void addDoc(byte[] var1) throws IOException;

    protected abstract void addElem(int var1, int var2, int var3, int var4, boolean var5) throws IOException;

    protected abstract void addAttr(int var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract void addText(byte[] var1, int var2, byte var3) throws IOException;

    protected abstract void setSize(int var1, int var2) throws IOException;

    private int addElem(byte[] nm, Atts att) throws IOException {
        int n = this.tags.index(nm, null, true);
        if (this.meta.pathindex) {
            this.path.index(n, (byte)1, this.lvl);
        }
        int pre = this.meta.size;
        this.tstack.set(this.lvl, n);
        this.pstack.set(this.lvl, pre);
        int dis = this.lvl != 0 ? pre - this.pstack.get(this.lvl - 1) : 1;
        int as = att.size;
        boolean ne = this.ns.open();
        int u = this.ns.uri(nm, true);
        this.addElem(dis, n, Math.min(31, as + 1), u, ne);
        int a = 0;
        while (a < as) {
            n = this.atts.index(att.key[a], att.val[a], true);
            u = this.ns.uri(att.key[a], false);
            if (this.meta.pathindex) {
                this.path.index(n, (byte)3, this.lvl + 1);
            }
            this.addAttr(n, att.val[a], Math.min(31, a + 1), u);
            ++a;
        }
        if (this.lvl != 0) {
            if (this.lvl > 1) {
                this.tags.stat((int)this.tstack.get((int)(this.lvl - 1))).leaf = false;
            } else if (this.inDoc) {
                this.error("%: More than one root node: '<%>'", this.parser.detail(), nm);
            }
        }
        if (this.meta.size != 1) {
            this.inDoc = true;
        }
        if (Util.debug && (this.c++ & 0x7FFFF) == 0) {
            Util.err(".", new Object[0]);
        }
        this.limit(this.tags.size(), 32768, "%: Too many different tag names (limit: %).");
        this.limit(this.atts.size(), 32768, "%: Too many different attribute names (limit: %).");
        this.limit(this.ns.size(), 256, "%: Too many different namespaces (limit: %).");
        if (this.meta.size < 0) {
            this.limit(0, 0, "%: Document is too large for being processed.");
        }
        return pre;
    }

    private void limit(int value, int limit, String msg) throws IOException {
        if (value >= limit) {
            this.error(msg, this.parser.detail(), limit);
        }
    }

    private void addText(byte[] value, byte kind) throws IOException {
        if (kind == 2) {
            this.tags.index(this.tstack.get(this.lvl - 1), value);
        } else if (this.lvl > 1) {
            this.tags.stat((int)this.tstack.get((int)(this.lvl - 1))).leaf = false;
        }
        if (this.meta.pathindex) {
            this.path.index(0, kind, this.lvl);
        }
        this.addText(value, this.lvl == 0 ? 1 : this.meta.size - this.pstack.get(this.lvl - 1), kind);
    }

    private void error(String msg, Object ... ext) throws IOException {
        throw new BuildException(msg, ext);
    }
}

