/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.audit.impl;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.task.api.LightweightIdentifier;
import com.evolveum.midpoint.task.api.LightweightIdentifierGenerator;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="auditService")
public class AuditServiceImpl
implements AuditService {
    private static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static Logger AUDIT_LOGGER = LoggerFactory.getLogger((String)"com.evolveum.midpoint.audit.log");
    private static final Trace LOGGER = TraceManager.getTrace(AuditServiceImpl.class);
    @Autowired
    private LightweightIdentifierGenerator lightweightIdentifierGenerator;

    public void audit(AuditEventRecord record, Task task) {
        this.assertCorrectness(record, task);
        this.completeRecord(record, task);
        this.recordRecord(record);
    }

    private void assertCorrectness(AuditEventRecord record, Task task) {
        if (task == null) {
            LOGGER.warn("Task is null in a call to audit service");
        } else if (task.getOwner() == null) {
            LOGGER.warn("Task '{}' has no owner in a call to audit service", new Object[]{task.getName()});
        }
    }

    private void completeRecord(AuditEventRecord record, Task task) {
        LightweightIdentifier id = null;
        if (record.getEventIdentifier() == null) {
            id = this.lightweightIdentifierGenerator.generate();
            record.setEventIdentifier(id.toString());
        }
        if (record.getTimestamp() == null) {
            if (id == null) {
                record.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            } else {
                record.setTimestamp(Long.valueOf(id.getTimestamp()));
            }
        }
        if (record.getTaskIdentifier() == null && task != null) {
            record.setTaskIdentifier(task.getTaskIdentifier());
        }
        if (record.getTaskOID() == null && task != null) {
            record.setTaskOID(task.getOid());
        }
        if (record.getTaskOID() == null && task != null) {
            record.setTaskOID(task.getOid());
        }
        if (record.getSessionIdentifier() == null) {
            // empty if block
        }
        if (record.getInitiator() == null && task != null) {
            record.setInitiator(task.getOwner());
        }
        record.getHostIdentifier();
    }

    private void recordRecord(AuditEventRecord record) {
        if (AUDIT_LOGGER.isInfoEnabled()) {
            AUDIT_LOGGER.info("{}", (Object)this.toSummary(record));
        }
        if (AUDIT_LOGGER.isDebugEnabled()) {
            AUDIT_LOGGER.debug("{}", (Object)this.toDetails(record));
        }
    }

    private String toSummary(AuditEventRecord record) {
        return String.valueOf(AuditServiceImpl.formatTimestamp(record.getTimestamp())) + " eid=" + record.getEventIdentifier() + ", et=" + record.getEventType() + ", es=" + record.getEventStage() + ", sid=" + record.getSessionIdentifier() + ", tid=" + record.getTaskIdentifier() + ", toid=" + record.getTaskOID() + ", hid=" + record.getHostIdentifier() + ", I=" + AuditServiceImpl.formatObject((PrismObject<? extends ObjectType>)record.getInitiator()) + ", T=" + AuditServiceImpl.formatObject((PrismObject<? extends ObjectType>)record.getTarget()) + ", TO=" + AuditServiceImpl.formatObject((PrismObject<? extends ObjectType>)record.getTargetOwner()) + ", D=" + this.formatDeltaSummary(record.getDeltas()) + ", ch=" + record.getChannel() + ", o=" + record.getOutcome();
    }

    private String toDetails(AuditEventRecord record) {
        StringBuilder sb = new StringBuilder("Details of event ");
        sb.append(record.getEventIdentifier()).append(" stage ").append(record.getEventStage()).append("\n");
        sb.append("Deltas:");
        for (ObjectDelta delta : record.getDeltas()) {
            sb.append("\n");
            if (delta == null) {
                sb.append("null");
                continue;
            }
            sb.append(delta.debugDump(1));
        }
        return sb.toString();
    }

    private static String formatTimestamp(Long timestamp) {
        if (timestamp == null) {
            return "null";
        }
        return TIMESTAMP_FORMAT.format(new Date(timestamp));
    }

    private static String formatObject(PrismObject<? extends ObjectType> object) {
        if (object == null) {
            return "null";
        }
        return String.valueOf(((ObjectType)object.asObjectable()).toDebugType()) + ":" + object.getOid() + "(" + object.getName() + ")";
    }

    private static String formatUser(UserType user) {
        if (user == null) {
            return "null";
        }
        return String.valueOf(user.getOid()) + "(" + user.getName() + ")";
    }

    private String formatDeltaSummary(Collection<ObjectDelta<?>> deltas) {
        if (deltas == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder("[");
        Iterator<ObjectDelta<?>> iterator = deltas.iterator();
        while (iterator.hasNext()) {
            ObjectDelta<?> delta = iterator.next();
            sb.append(delta.getOid()).append(":").append(delta.getChangeType());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }
}

