/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.ProgressException;
import org.basex.core.Text;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.Util;

final class XMLStreamWrapper
extends Parser {
    private int nodes;
    private final XMLStreamReader reader;

    XMLStreamWrapper(XMLStreamReader sr) {
        super("");
        this.reader = sr;
    }

    public void parse(Builder builder) throws IOException {
        try {
            builder.startDoc(Token.token((String)this.src.name()));
            while (this.reader.hasNext()) {
                int kind = this.reader.next();
                switch (kind) {
                    case 1: {
                        int as = this.reader.getAttributeCount();
                        Atts att = new Atts();
                        int a = 0;
                        while (a < as) {
                            att.add(Token.token((String)this.reader.getAttributeLocalName(a)), Token.token((String)this.reader.getAttributeValue(a)));
                            ++a;
                        }
                        builder.startElem(Token.token((String)this.reader.getLocalName()), att);
                        ++this.nodes;
                        break;
                    }
                    case 2: {
                        builder.endElem(Token.token((String)this.reader.getLocalName()));
                        break;
                    }
                    case 4: {
                        builder.text(Token.token((String)this.reader.getText()));
                        ++this.nodes;
                        break;
                    }
                    case 3: {
                        builder.pi(Token.token((String)(String.valueOf(this.reader.getPITarget()) + ' ' + this.reader.getPIData())));
                        ++this.nodes;
                        break;
                    }
                    case 5: {
                        builder.comment(Token.token((String)this.reader.getText()));
                        ++this.nodes;
                        break;
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        throw new IOException("Unknown node kind " + kind);
                    }
                }
            }
            builder.endDoc();
        }
        catch (ProgressException ex) {
            throw ex;
        }
        catch (IOException ex) {
            Util.stack((Throwable)ex);
            throw ex;
        }
        catch (XMLStreamException ex) {
            IOException ioe = new IOException(ex.getMessage());
            ioe.setStackTrace(ex.getStackTrace());
            throw ioe;
        }
    }

    public String det() {
        return Util.info((Object)Text.NODESPARSED, (Object[])new Object[]{this.src.name(), this.nodes});
    }
}

