/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQStaticContext;
import org.basex.api.xqj.BXQAbstract;
import org.basex.api.xqj.BXQException;
import org.basex.core.Context;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.item.QNm;
import org.basex.query.item.Uri;
import org.basex.util.Atts;
import org.basex.util.Token;

final class BXQStaticContext
implements XQStaticContext {
    final Context context = new Context();
    final QueryContext ctx;
    boolean scrollable;
    int timeout;
    private XQItemType type;
    private boolean binding = true;
    private boolean holdability = true;
    private boolean xqueryx = true;

    protected BXQStaticContext(String name, String pw) throws XQException {
        if (name != null) {
            this.context.user = this.context.users.get(name);
            if (this.context.user == null || !Token.string((byte[])this.context.user.password).equals(Token.md5((String)pw))) {
                throw new BXQException("Access denied for user '%'.", name);
            }
        }
        this.ctx = new QueryContext(this.context);
    }

    public void declareNamespace(String prefix, String uri) throws XQException {
        try {
            BXQAbstract.valid(prefix, String.class);
            BXQAbstract.valid(uri, String.class);
            QNm name = new QNm(Token.token((String)prefix), Token.token((String)uri));
            if (!uri.isEmpty()) {
                this.ctx.ns.add(name, null);
            } else {
                this.ctx.ns.delete(name);
            }
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public String getBaseURI() {
        return Token.string((byte[])this.ctx.baseURI.atom());
    }

    public int getBindingMode() {
        return this.binding ? 0 : 1;
    }

    public int getBoundarySpacePolicy() {
        return this.ctx.spaces ? 1 : 2;
    }

    public int getConstructionMode() {
        return this.ctx.construct ? 1 : 2;
    }

    public XQItemType getContextItemStaticType() {
        return this.type;
    }

    public int getCopyNamespacesModeInherit() {
        return this.ctx.nsInherit ? 1 : 2;
    }

    public int getCopyNamespacesModePreserve() {
        return this.ctx.nsPreserve ? 1 : 2;
    }

    public String getDefaultCollation() {
        return Token.string((byte[])this.ctx.collation.atom());
    }

    public String getDefaultElementTypeNamespace() {
        return Token.string((byte[])this.ctx.nsElem);
    }

    public String getDefaultFunctionNamespace() {
        return Token.string((byte[])this.ctx.nsFunc);
    }

    public int getDefaultOrderForEmptySequences() {
        return this.ctx.orderGreatest ? 1 : 2;
    }

    public int getHoldability() {
        return this.holdability ? 1 : 2;
    }

    public String[] getNamespacePrefixes() {
        Atts atts = this.ctx.ns.ns;
        String[] pre = new String[atts.size];
        int p = 0;
        while (p < pre.length) {
            pre[p] = Token.string((byte[])atts.key[p]);
            ++p;
        }
        return pre;
    }

    public String getNamespaceURI(String prefix) throws XQException {
        BXQAbstract.valid(prefix, String.class);
        byte[] uri = this.ctx.ns.find(Token.token((String)prefix));
        if (uri != null) {
            return Token.string((byte[])uri);
        }
        throw new BXQException("Unknown namespace prefix '%'.", prefix);
    }

    public int getOrderingMode() {
        return this.ctx.ordered ? 1 : 2;
    }

    public int getQueryLanguageTypeAndVersion() {
        return this.xqueryx ? 2 : 1;
    }

    public int getQueryTimeout() {
        return this.timeout;
    }

    public int getScrollability() {
        return this.scrollable ? 2 : 1;
    }

    public void setBaseURI(String baseUri) throws XQException {
        BXQAbstract.valid(baseUri, String.class);
        this.ctx.baseURI = Uri.uri((byte[])Token.token((String)baseUri));
    }

    public void setBindingMode(int mode) throws BXQException {
        if (mode != 0 && mode != 1) {
            throw new BXQException("Wrong argument for %.", "Binding Mode");
        }
        this.binding = mode == 0;
    }

    public void setBoundarySpacePolicy(int mode) throws BXQException {
        this.ctx.spaces = this.check(mode, "Boundary Space") == 1;
    }

    public void setConstructionMode(int mode) throws XQException {
        this.ctx.construct = this.check(mode, "Construction Mode") == 1;
    }

    public void setContextItemStaticType(XQItemType contextItemType) {
        this.type = contextItemType;
    }

    public void setCopyNamespacesModeInherit(int mode) throws BXQException {
        this.ctx.nsInherit = this.check(mode, "Namespace Mode") == 1;
    }

    public void setCopyNamespacesModePreserve(int m) throws BXQException {
        this.ctx.nsPreserve = this.check(m, "Namespace Mode") == 1;
    }

    public void setDefaultCollation(String uri) throws XQException {
        BXQAbstract.valid(uri, String.class);
        this.ctx.collation = Uri.uri((byte[])Token.token((String)uri));
    }

    public void setDefaultElementTypeNamespace(String uri) throws XQException {
        BXQAbstract.valid(uri, String.class);
        this.ctx.nsElem = Token.token((String)uri);
    }

    public void setDefaultFunctionNamespace(String uri) throws XQException {
        BXQAbstract.valid(uri, String.class);
        this.ctx.nsFunc = Token.token((String)uri);
    }

    public void setDefaultOrderForEmptySequences(int mode) throws BXQException {
        this.ctx.orderGreatest = this.check(mode, "Ordering Mode") == 1;
    }

    public void setHoldability(int hold) throws BXQException {
        this.holdability = this.check(hold, "Holdability") == 1;
    }

    public void setOrderingMode(int mode) throws BXQException {
        this.ctx.ordered = this.check(mode, "Ordering Mode") == 1;
    }

    public void setQueryLanguageTypeAndVersion(int m) throws BXQException {
        this.xqueryx = this.check(m, "Language Type") == 2;
    }

    public void setQueryTimeout(int seconds) throws BXQException {
        if (seconds < 0) {
            throw new BXQException("Timeout must be positive.", new Object[0]);
        }
        this.timeout = seconds;
    }

    public void setScrollability(int mode) throws BXQException {
        this.scrollable = this.check(mode, "Scrollability") == 2;
    }

    private int check(int val, String msg) throws BXQException {
        if (val != 1 && val != 2) {
            throw new BXQException("Wrong argument for %.", msg);
        }
        return val;
    }
}

