/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQResultSequence;
import org.basex.api.xqj.BXQAbstract;
import org.basex.api.xqj.BXQConnection;
import org.basex.api.xqj.BXQDataFactory;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItem;
import org.basex.api.xqj.IterStreamReader;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SAXSerializer;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryException;
import org.basex.query.item.Item;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.util.Util;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

final class BXQSequence
extends BXQAbstract
implements XQResultSequence {
    final Iter result;
    private BXQItem it;
    private int pos;
    private final BXQConnection conn;
    private boolean next;
    private final boolean scrollable;

    BXQSequence(Iter item, BXQDataFactory c) throws XQException {
        this(item, c, null);
    }

    BXQSequence(Iter item, BXQAbstract c, BXQConnection cn) throws XQException {
        super(c);
        this.result = item;
        this.conn = cn;
        this.scrollable = cn == null || cn.getStaticContext().getScrollability() == 2;
    }

    public XQConnection getConnection() throws XQException {
        this.opened();
        return this.conn;
    }

    public boolean absolute(int p) throws XQException {
        ItemCache ic = this.sequence();
        this.cursor(ic, p >= 0 ? p - 1 : (int)ic.size() + p);
        return this.pos > 0;
    }

    public void afterLast() throws XQException {
        this.cursor(this.sequence(), Integer.MAX_VALUE);
    }

    public void beforeFirst() throws XQException {
        this.cursor(this.sequence(), -1);
    }

    public int count() throws XQException {
        return (int)this.sequence().size();
    }

    public boolean first() throws XQException {
        return this.cursor(this.sequence(), 0);
    }

    public String getAtomicValue() throws XQException {
        return this.item().getAtomicValue();
    }

    public boolean getBoolean() throws XQException {
        return this.item().getBoolean();
    }

    public byte getByte() throws XQException {
        return this.item().getByte();
    }

    public double getDouble() throws XQException {
        return this.item().getDouble();
    }

    public float getFloat() throws XQException {
        return this.item().getFloat();
    }

    public int getInt() throws XQException {
        return this.item().getInt();
    }

    public XQItem getItem() throws XQException {
        return this.item();
    }

    public XMLStreamReader getItemAsStream() throws XQException {
        this.opened();
        return this.item().getItemAsStream();
    }

    public String getItemAsString(Properties p) throws XQException {
        return this.item().getItemAsString(p);
    }

    public XQItemType getItemType() throws XQException {
        this.pos();
        return this.it.getItemType();
    }

    public long getLong() throws XQException {
        return this.item().getLong();
    }

    public Node getNode() throws XQException {
        return this.item().getNode();
    }

    public URI getNodeUri() throws XQException {
        this.pos();
        return this.it.getNodeUri();
    }

    public Object getObject() throws XQException {
        return this.item().getObject();
    }

    public int getPosition() throws XQException {
        ItemCache ic = this.sequence();
        return this.pos != -1 ? this.pos : (int)ic.size() + 1;
    }

    public XMLStreamReader getSequenceAsStream() throws XQException {
        this.opened();
        if (this.it != null && !this.next) {
            throw new BXQException("Current item has already been requested.", new Object[0]);
        }
        return new IterStreamReader(this.result);
    }

    public String getSequenceAsString(Properties p) throws XQException {
        this.opened();
        if (this.it != null && !this.next) {
            throw new BXQException("Current item has already been requested.", new Object[0]);
        }
        if (!this.next && !this.next()) {
            return "";
        }
        ArrayOutput ao = new ArrayOutput();
        try {
            XMLSerializer xml = new XMLSerializer((OutputStream)ao);
            do {
                BXQItem item = this.item();
                item.serialize(item.it, (Serializer)xml);
            } while (this.next());
            xml.close();
        }
        catch (IOException ex) {
            throw new BXQException(ex);
        }
        return ao.toString();
    }

    public short getShort() throws XQException {
        return this.item().getShort();
    }

    public boolean instanceOf(XQItemType type) throws XQException {
        this.pos();
        return this.it.instanceOf(type);
    }

    public boolean isAfterLast() throws XQException {
        this.sequence();
        return this.pos == -1;
    }

    public boolean isBeforeFirst() throws XQException {
        this.sequence();
        return this.pos == 0 && (long)this.pos < this.sequence().size();
    }

    public boolean isFirst() throws XQException {
        this.sequence();
        return this.pos == 1;
    }

    public boolean isLast() throws XQException {
        return (long)this.pos == this.sequence().size();
    }

    public boolean isOnItem() throws XQException {
        this.opened();
        return this.pos > 0;
    }

    public boolean isScrollable() throws XQException {
        this.opened();
        return this.scrollable;
    }

    public boolean last() throws XQException {
        ItemCache ic = this.sequence();
        return this.cursor(ic, (int)ic.size() - 1);
    }

    public boolean next() throws XQException {
        this.opened();
        if (this.pos < 0) {
            return false;
        }
        try {
            Item i = this.result.next();
            this.next = i != null;
            ++this.pos;
            this.it = new BXQItem(i, this, this.conn);
            if (!this.next) {
                this.pos = -1;
            }
            return this.next;
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public boolean previous() throws XQException {
        return this.relative(-1);
    }

    public boolean relative(int p) throws XQException {
        return this.cursor(this.sequence(), this.getPosition() + p - 1);
    }

    public void writeItem(OutputStream os, Properties p) throws XQException {
        this.item().writeItem(os, p);
    }

    public void writeItem(Writer ow, Properties p) throws XQException {
        this.item().writeItem(ow, p);
    }

    public void writeItemToResult(Result r) throws XQException {
        this.item().writeItemToResult(r);
    }

    public void writeItemToSAX(ContentHandler sax) throws XQException {
        this.item().writeItemToSAX(sax);
    }

    /*
     * Unable to fully structure code
     */
    public void writeSequence(OutputStream os, Properties p) throws XQException {
        if (this.it == null || this.next) ** GOTO lbl4
        throw new BXQException("Current item has already been requested.", new Object[0]);
lbl-1000:
        // 1 sources

        {
            this.item().writeItem(os, p);
lbl4:
            // 2 sources

            ** while (this.next())
        }
lbl5:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    public void writeSequence(Writer ow, Properties p) throws XQException {
        if (this.it == null || this.next) ** GOTO lbl4
        throw new BXQException("Current item has already been requested.", new Object[0]);
lbl-1000:
        // 1 sources

        {
            this.item().writeItem(ow, p);
lbl4:
            // 2 sources

            ** while (this.next())
        }
lbl5:
        // 1 sources

    }

    public void writeSequenceToResult(Result res) throws XQException {
        BXQSequence.valid(res, Result.class);
        if (this.it != null && !this.next) {
            throw new BXQException("Current item has already been requested.", new Object[0]);
        }
        if (res instanceof StreamResult) {
            StreamResult sr = (StreamResult)res;
            if (sr.getWriter() != null) {
                this.writeSequence(sr.getWriter(), null);
            } else {
                this.writeSequence(sr.getOutputStream(), null);
            }
        } else if (res instanceof SAXResult) {
            SAXSerializer ser = new SAXSerializer(null);
            SAXResult sax = (SAXResult)res;
            ser.setContentHandler(sax.getHandler());
            ser.setLexicalHandler(sax.getLexicalHandler());
            while (this.next()) {
                this.serialize(this.item().it, (Serializer)ser);
            }
        } else {
            Util.notimplemented((Object[])new Object[0]);
        }
    }

    public void writeSequenceToSAX(ContentHandler sax) throws XQException {
        BXQSequence.valid(sax, ContentHandler.class);
        this.writeSequenceToResult(new SAXResult(sax));
    }

    private BXQItem item() throws XQException {
        this.pos();
        if (!this.next) {
            throw new BXQException("Current item has already been requested.", new Object[0]);
        }
        this.next = this.scrollable;
        return this.it;
    }

    private void pos() throws XQException {
        if (!this.isOnItem()) {
            throw new BXQException("Cursor does not point to an item.", new Object[0]);
        }
    }

    private ItemCache sequence() throws XQException {
        this.opened();
        if (!this.scrollable) {
            throw new BXQException("Sequence is forwards-only", new Object[0]);
        }
        return (ItemCache)this.result;
    }

    private boolean cursor(ItemCache seq, int p) throws XQException {
        this.pos = p < 0 ? 0 : ((long)p >= seq.size() ? -1 : p);
        seq.pos(this.pos - 1);
        return p >= 0 && this.next();
    }
}

