/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.xquery.XQDataFactory;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQSequence;
import org.basex.api.xqj.BXQAbstract;
import org.basex.api.xqj.BXQException;
import org.basex.api.xqj.BXQItem;
import org.basex.api.xqj.BXQItemType;
import org.basex.api.xqj.BXQSequence;
import org.basex.api.xqj.BXQStaticContext;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Bln;
import org.basex.query.item.Dbl;
import org.basex.query.item.Flt;
import org.basex.query.item.Item;
import org.basex.query.item.Itr;
import org.basex.query.item.NodeType;
import org.basex.query.item.Str;
import org.basex.query.item.Type;
import org.basex.query.iter.ItemCache;
import org.basex.query.iter.Iter;
import org.basex.util.Token;
import org.basex.util.Util;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;

class BXQDataFactory
extends BXQAbstract
implements XQDataFactory {
    protected BXQDataFactory(String name, String pw) throws XQException {
        super(null);
        this.ctx = new BXQStaticContext(name, pw);
    }

    public BXQItemType createAtomicType(int b, QName qn, URI uri) throws XQException {
        return this.createAtomicType(b);
    }

    public BXQItemType createAtomicType(int b) throws XQException {
        this.opened();
        return new BXQItemType(b);
    }

    public BXQItemType createAttributeType(QName qn, int it, QName qn2, URI uri) throws XQException {
        return this.createAttributeType(qn, it);
    }

    public BXQItemType createAttributeType(QName qn, int it) throws XQException {
        this.opened();
        this.checkAttr(it);
        return new BXQItemType((Type)NodeType.ATT, qn, it);
    }

    public BXQItemType createCommentType() throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.COM);
    }

    public BXQItemType createDocumentElementType(XQItemType it) throws XQException {
        this.opened();
        BXQDataFactory.valid(it, XQItemType.class);
        if (it.getItemKind() != 7) {
            throw new BXQException("Node must not be ELEMENT.", new Object[0]);
        }
        return new BXQItemType((Type)NodeType.DEL, it.getNodeName(), it.getBaseType());
    }

    public BXQItemType createDocumentSchemaElementType(XQItemType it) throws XQException {
        this.opened();
        BXQDataFactory.valid(it, XQItemType.class);
        if (it.getItemKind() != 12) {
            throw new BXQException("Node must not be ELEMENT.", new Object[0]);
        }
        return new BXQItemType((Type)NodeType.DEL, it.getNodeName(), it.getBaseType());
    }

    public BXQItemType createDocumentType() throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.DOC);
    }

    public BXQItemType createElementType(QName qn, int it, QName qn2, URI uri, boolean n) throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.ELM, qn, it);
    }

    public BXQItemType createElementType(QName qn, int it) throws XQException {
        return this.createElementType(qn, it, null, null, false);
    }

    public BXQItem createItem(XQItem v) throws XQException {
        this.opened();
        BXQDataFactory.valid(v, XQItem.class);
        try {
            Type type = ((BXQItemType)v.getItemType()).getType();
            return new BXQItem(type.e(((BXQItem)v).it, this.ctx.ctx, null));
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public BXQItem createItemFromAtomicValue(String v, XQItemType it) throws XQException {
        BXQDataFactory.valid(it, XQItemType.class);
        try {
            Str val = Str.get((Object)BXQDataFactory.valid(v, String.class));
            return new BXQItem(this.check((Type)AtomType.STR, it).e((Item)val, this.ctx.ctx, null));
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public BXQItem createItemFromBoolean(boolean v, XQItemType it) throws XQException {
        this.check((Type)AtomType.BLN, it);
        return new BXQItem((Item)Bln.get((boolean)v));
    }

    public BXQItem createItemFromByte(byte v, XQItemType it) throws XQException {
        return this.itr(v, (Type)AtomType.BYT, it);
    }

    public BXQItem createItemFromDocument(InputStream is, String base, XQItemType it) throws XQException {
        this.check((Type)NodeType.DOC, it);
        return new BXQItem((Item)this.createNode(is));
    }

    public BXQItem createItemFromDocument(Reader r, String base, XQItemType it) throws XQException {
        this.check((Type)NodeType.DOC, it);
        return new BXQItem((Item)this.createNode(r));
    }

    public BXQItem createItemFromDocument(Source s, XQItemType it) throws XQException {
        return new BXQItem((Item)this.createNode(s, it));
    }

    public BXQItem createItemFromDocument(String v, String base, XQItemType it) throws XQException {
        BXQDataFactory.valid(v, String.class);
        this.check((Type)NodeType.DOC, it);
        return new BXQItem((Item)this.createNode((IO)new IOContent(Token.token((String)v))));
    }

    public BXQItem createItemFromDocument(XMLStreamReader sr, XQItemType it) throws XQException {
        this.check((Type)NodeType.DOC, it);
        return new BXQItem((Item)this.createNode(sr));
    }

    public BXQItem createItemFromDouble(double v, XQItemType it) throws XQException {
        this.check((Type)AtomType.DBL, it);
        return new BXQItem((Item)Dbl.get((double)v));
    }

    public BXQItem createItemFromFloat(float v, XQItemType it) throws XQException {
        this.check((Type)AtomType.FLT, it);
        return new BXQItem((Item)Flt.get((float)v));
    }

    public BXQItem createItemFromInt(int v, XQItemType it) throws XQException {
        return this.itr(v, (Type)AtomType.INT, it);
    }

    public BXQItem createItemFromLong(long v, XQItemType it) throws XQException {
        return this.itr(v, (Type)AtomType.LNG, it);
    }

    public BXQItem createItemFromNode(Node v, XQItemType it) throws XQException {
        this.opened();
        this.check((Type)NodeType.DOC, it);
        BXQDataFactory.valid(v, Node.class);
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSOutput output = impl.createLSOutput();
            output.setByteStream(ba);
            impl.createLSSerializer().write(v, output);
        }
        catch (Exception ex) {
            Util.stack((Throwable)ex);
        }
        return new BXQItem((Item)this.createNode((IO)new IOContent(ba.toByteArray())));
    }

    public BXQItem createItemFromObject(Object v, XQItemType t) throws XQException {
        return new BXQItem(this.create(v, t));
    }

    public BXQItem createItemFromShort(short v, XQItemType it) throws XQException {
        return this.itr(v, (Type)AtomType.SHR, it);
    }

    public BXQItem createItemFromString(String v, XQItemType it) throws XQException {
        try {
            Str val = Str.get((Object)BXQDataFactory.valid(v, String.class));
            return new BXQItem(this.check((Type)AtomType.STR, it).e((Item)val, this.ctx.ctx, null));
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public BXQItemType createItemType() throws XQException {
        this.opened();
        return new BXQItemType((Type)AtomType.ITEM);
    }

    public BXQItemType createNodeType() throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.NOD);
    }

    public BXQItemType createProcessingInstructionType(String nm) throws XQException {
        this.opened();
        QName name = nm == null ? null : new QName(nm);
        return new BXQItemType((Type)NodeType.PI, name, -1);
    }

    public BXQItemType createSchemaAttributeType(QName qn, int it, URI uri) throws XQException {
        this.opened();
        this.checkAttr(it);
        return new BXQItemType((Type)NodeType.ATT, qn, it);
    }

    public BXQItemType createSchemaElementType(QName qn, int it, URI uri) throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.ELM, qn, it);
    }

    public BXQSequence createSequence(Iterator it) throws XQException {
        this.opened();
        BXQDataFactory.valid(it, Iterator.class);
        ItemCache ic = new ItemCache();
        while (it.hasNext()) {
            ic.add(this.create(it.next(), null));
        }
        return new BXQSequence((Iter)ic, this);
    }

    public BXQSequence createSequence(XQSequence seq) throws XQException {
        this.opened();
        BXQDataFactory.valid(seq, XQSequence.class);
        BXQSequence s = (BXQSequence)seq;
        s.opened();
        try {
            return new BXQSequence((Iter)s.result.finish().cache(), this);
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }

    public BXQItemType createSequenceType(XQItemType it, int occ) throws XQException {
        this.opened();
        BXQDataFactory.valid(it, XQItemType.class);
        if (occ < 1 || occ > 5) {
            throw new BXQException("Invalid occurrence indicator.", new Object[0]);
        }
        if (occ == 5 && it != null || occ == 2 && it == null) {
            throw new BXQException("Occurrence indicator and item type do not match.", new Object[0]);
        }
        Type type = ((BXQItemType)it).getType();
        QName name = type.node() ? it.getNodeName() : null;
        return new BXQItemType(type, name, it.getBaseType(), occ);
    }

    public BXQItemType createTextType() throws XQException {
        this.opened();
        return new BXQItemType((Type)NodeType.TXT);
    }

    private void checkAttr(int it) throws XQException {
        if (it != 1 && it != 2) {
            return;
        }
        throw new BXQException("Node must not be UNTYPED or ANYTYPE.", new Object[0]);
    }

    private BXQItem itr(long v, Type e, XQItemType t) throws XQException {
        try {
            return new BXQItem(this.check(e, t).e((Item)Itr.get((long)v), this.ctx.ctx, null));
        }
        catch (QueryException ex) {
            throw new BXQException((Exception)((Object)ex));
        }
    }
}

