/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.basex.api.xmldb.BXResourceIterator;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.data.Result;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.XMLSerializer;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.ResourceSet;
import org.xmldb.api.base.XMLDBException;

final class BXResourceSet
implements ResourceSet,
BXXMLDBText {
    private final ArrayList<Resource> res = new ArrayList();
    private final Collection coll;

    BXResourceSet(Result r, Collection c) {
        int s = 0;
        while ((long)s < r.size()) {
            this.res.add((Resource)new BXXMLResource(r, s, c));
            ++s;
        }
        this.coll = c;
    }

    public Resource getResource(long i) throws XMLDBException {
        if (i >= 0L && i < (long)this.res.size()) {
            return this.res.get((int)i);
        }
        throw new XMLDBException(300);
    }

    public void addResource(Resource r) {
        this.res.add(r);
    }

    public void removeResource(long index) {
        this.res.remove((int)index);
    }

    public BXResourceIterator getIterator() {
        return new BXResourceIterator(this.res);
    }

    public Resource getMembersAsResource() throws XMLDBException {
        ArrayOutput ao = new ArrayOutput();
        try {
            XMLSerializer xml = new XMLSerializer((OutputStream)ao);
            for (Resource r : this.getIterator()) {
                xml.openResult();
                ao.print(r.getContent().toString());
                xml.closeResult();
            }
        }
        catch (IOException ex) {
            throw new XMLDBException(1, ex.getMessage());
        }
        return new BXXMLResource(ao.toArray(), this.coll);
    }

    public long getSize() {
        return this.res.size();
    }

    public void clear() {
        this.res.clear();
    }
}

