/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.jaxrx;

import java.io.OutputStream;
import java.util.Scanner;
import javax.ws.rs.core.StreamingOutput;
import org.basex.api.jaxrx.BXCode;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Prop;
import org.basex.core.Text;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.Set;
import org.basex.server.Query;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;

abstract class BXOutput
extends BXCode
implements StreamingOutput {
    final ResourcePath path;
    OutputStream out;

    BXOutput(ResourcePath pt) {
        super(pt);
        this.path = pt;
    }

    public void write(OutputStream os) {
        this.out = os;
        if (this.path != null) {
            try {
                if (this.path.getDepth() != 0) {
                    this.session.execute((Command)new Open(this.path.getResourcePath()));
                }
            }
            catch (BaseXException ex) {
                throw new JaxRxException(this.status((Exception)((Object)ex)), ex.getMessage());
            }
            try {
                this.session.execute((Command)new Set((Object)Prop.SERIALIZER, (Object)this.serial(this.path)));
            }
            catch (BaseXException ex) {
                throw new JaxRxException(400, ex.getMessage());
            }
        }
        this.run();
    }

    final String exec(Object command, OutputStream os) {
        this.session.setOutputStream(os);
        try {
            return this.session.execute(command.toString());
        }
        catch (BaseXException ex) {
            throw new JaxRxException(400, ex.getMessage());
        }
    }

    final String query(String query) {
        int s = this.num(this.path, QueryParameter.START, 1);
        int m = this.num(this.path, QueryParameter.COUNT, Integer.MAX_VALUE - s);
        Query cq = null;
        try {
            this.session.execute((Command)new Set((Object)Prop.SERIALIZER, (Object)this.serial(this.path)));
            this.session.setOutputStream(this.out);
            cq = this.session.query(query.isEmpty() ? "." : query);
            String var = this.path.getValue(QueryParameter.VAR);
            if (var != null) {
                Scanner sc = new Scanner(var);
                sc.useDelimiter("\u0001");
                while (sc.hasNext()) {
                    String v = sc.next();
                    String[] sp = v.split("\u0002", 3);
                    if (sp.length < 2) {
                        sp = v.split("=", 2);
                    }
                    cq.bind(sp[0], sp.length > 1 ? sp[1] : "", sp.length > 2 ? sp[2] : "");
                }
            }
            int c = 0;
            cq.init();
            while (++c < s + m && cq.more()) {
                if (c < s) continue;
                cq.next();
            }
            return null;
        }
        catch (BaseXException ex) {
            throw new JaxRxException(this.status((Exception)((Object)ex)), ex.getMessage());
        }
        finally {
            if (cq != null) {
                try {
                    cq.close();
                }
                catch (BaseXException baseXException) {}
            }
        }
    }

    private int status(Exception ex) {
        String msg = ex.getMessage();
        return msg != null && msg.contains(Text.PERMNO.substring(2)) ? 403 : 404;
    }
}

