/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.jaxrx;

import com.sun.jersey.core.spi.factory.ResponseBuilderImpl;
import java.io.IOException;
import org.basex.api.jaxrx.JaxRxServer;
import org.basex.core.Context;
import org.basex.io.serial.SerializerProp;
import org.basex.server.LocalSession;
import org.basex.server.LoginException;
import org.basex.server.Session;
import org.basex.util.Util;
import org.jaxrx.core.JaxRxException;
import org.jaxrx.core.QueryParameter;
import org.jaxrx.core.ResourcePath;

abstract class BXCode {
    private static final Context CONTEXT = Boolean.parseBoolean(System.getProperty("org.basex.jaxrx.local")) ? new Context() : null;
    final Session session;

    BXCode(ResourcePath path) {
        this.session = BXCode.getSession(path);
    }

    static Session getSession(ResourcePath path) {
        if (CONTEXT != null) {
            return new LocalSession(CONTEXT);
        }
        try {
            return JaxRxServer.login(path);
        }
        catch (LoginException ex) {
            ResponseBuilderImpl rb = new ResponseBuilderImpl();
            rb.header("WWW-Authenticate", (Object)"Basic ");
            rb.status(401);
            rb.entity((Object)"Username/password is wrong.");
            throw new JaxRxException(rb.build());
        }
        catch (Exception ex) {
            Util.stack((Throwable)ex);
            throw new JaxRxException(ex);
        }
    }

    abstract String code() throws IOException;

    final String run() {
        try {
            String string = this.code();
            return string;
        }
        catch (IOException ex) {
            throw new JaxRxException((Exception)ex);
        }
        finally {
            try {
                this.session.close();
            }
            catch (Exception exception) {}
        }
    }

    final String db(ResourcePath path) {
        return path.getResource(0);
    }

    int num(ResourcePath path, QueryParameter qp, int def) {
        String val = path.getValue(qp);
        if (val == null) {
            return def;
        }
        try {
            int i = Integer.parseInt(val);
            if (i > 0) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw new JaxRxException(400, "Parameter '" + qp + "' is no valid integer: " + val);
    }

    final String path(ResourcePath path) {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        while (i < path.getDepth()) {
            sb.append('/').append(path.getResource(i));
            ++i;
        }
        return sb.substring(Math.min(1, sb.length()));
    }

    final String serial(ResourcePath path) {
        String wrap;
        String ser = path.getValue(QueryParameter.OUTPUT);
        if (ser == null) {
            ser = "";
        }
        if ((wrap = path.getValue(QueryParameter.WRAP)) == null || wrap.equals("yes")) {
            ser = String.valueOf(ser) + "," + SerializerProp.S_WRAP_PREFIX[0] + "=" + "jax-rx" + "," + SerializerProp.S_WRAP_URI[0] + "=" + "http://jax-rx.sourceforge.net";
        } else if (!wrap.equals("no")) {
            throw new JaxRxException(400, SerializerProp.error((Object)QueryParameter.WRAP, (String)wrap, (String[])new String[]{"yes", "no"}).getMessage());
        }
        return ser.replaceAll("^,", "");
    }
}

