/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.util;

import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.ROwnable;
import com.evolveum.midpoint.repo.sql.util.ContainerIdGenerator;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class ContainerOidGenerator
implements IdentifierGenerator {
    private static final Trace LOGGER = TraceManager.getTrace(ContainerIdGenerator.class);

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (object instanceof RAnyContainer) {
            RAnyContainer any = (RAnyContainer)object;
            RContainer owner = any.getOwner();
            String oid = owner.getOid();
            if (oid == null) {
                oid = this.generate(owner);
                owner.setOid(oid);
            }
            LOGGER.trace("Created oid='{}' for any.", new Object[]{oid});
            return oid;
        }
        return this.generate(object);
    }

    private String generate(Object object) {
        RContainer container = null;
        if (object instanceof ROwnable) {
            container = ((ROwnable)object).getContainerOwner();
        } else if (object instanceof RObject) {
            container = (RContainer)object;
        }
        if (container == null) {
            throw new HibernateException("Couldn't create id for '" + object.getClass().getSimpleName() + "' (should not happen).");
        }
        if (StringUtils.isNotEmpty((String)container.getOid())) {
            LOGGER.trace("Created oid='{}' for '{}'.", new Object[]{container.getOid(), this.toString(object)});
            return container.getOid();
        }
        String oid = UUID.randomUUID().toString();
        LOGGER.trace("Created oid='{}' for '{}'.", new Object[]{oid, this.toString(object)});
        return oid;
    }

    private String toString(Object object) {
        RContainer container = (RContainer)object;
        StringBuilder builder = new StringBuilder();
        builder.append(object.getClass().getSimpleName());
        builder.append("[");
        builder.append(container.getOid());
        builder.append(",");
        builder.append(container.getId());
        builder.append("]");
        return builder.toString();
    }
}

