/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.util;

import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.ROwnable;
import com.evolveum.midpoint.repo.sql.data.common.RRole;
import com.evolveum.midpoint.repo.sql.data.common.RUser;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class ContainerIdGenerator
implements IdentifierGenerator {
    private static final Trace LOGGER = TraceManager.getTrace(ContainerIdGenerator.class);

    public Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (object instanceof RAnyContainer) {
            RAnyContainer any = (RAnyContainer)object;
            RContainer owner = any.getOwner();
            Long id = owner.getId();
            if (id == null) {
                id = this.generate(owner);
                owner.setId(id);
            }
            LOGGER.trace("Created id='{}' for any.", new Object[]{id});
            return id;
        }
        if (!(object instanceof RContainer)) {
            throw new HibernateException("Couldn't create id for '" + object.getClass().getSimpleName() + "' not instance of RContainer.");
        }
        return this.generate((RContainer)object);
    }

    private Long generate(RContainer container) {
        if (container instanceof RObject) {
            LOGGER.trace("Created id='0' for '{}'.", new Object[]{this.toString(container)});
            return 0L;
        }
        if (container.getId() != null && container.getId() != 0L) {
            LOGGER.trace("Created id='{}' for '{}'.", new Object[]{container.getId(), this.toString(container)});
            return container.getId();
        }
        if (container instanceof ROwnable) {
            RContainer parent = ((ROwnable)((Object)container)).getContainerOwner();
            if (parent instanceof RUser) {
                RUser user = (RUser)parent;
                Long id = this.getNextId(user.getAssignments());
                LOGGER.trace("Created id='{}' for '{}'.", new Object[]{id, this.toString(container)});
                return id;
            }
            if (parent instanceof RRole) {
                RRole role = (RRole)parent;
                HashSet<RContainer> containers = new HashSet<RContainer>();
                if (role.getAssignments() != null) {
                    containers.addAll(role.getAssignments());
                }
                if (role.getExclusions() != null) {
                    containers.addAll(role.getExclusions());
                }
                Long id = this.getNextId(containers);
                LOGGER.trace("Created id='{}' for '{}'.", new Object[]{id, this.toString(container)});
                return id;
            }
            return null;
        }
        throw new HibernateException("Couldn't create id for '" + container.getClass().getSimpleName() + "' (should not happen).");
    }

    private String toString(Object object) {
        RContainer container = (RContainer)object;
        StringBuilder builder = new StringBuilder();
        builder.append(object.getClass().getSimpleName());
        builder.append("[");
        builder.append(container.getOid());
        builder.append(",");
        builder.append(container.getId());
        builder.append("]");
        return builder.toString();
    }

    private Long getNextId(Set<? extends RContainer> set) {
        Long id = 0L;
        if (set != null) {
            for (RContainer rContainer : set) {
                Long contId = rContainer.getId();
                if (contId == null || contId <= id) continue;
                id = contId;
            }
        }
        return id + 1L;
    }
}

