/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.repo.sql.query.Op;
import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.query.QueryInterpreter;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.List;
import javax.xml.namespace.QName;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Restrictions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LogicalOp
extends Op {
    private static final Trace LOGGER = TraceManager.getTrace(LogicalOp.class);

    public LogicalOp(QueryInterpreter interpreter) {
        super(interpreter);
    }

    @Override
    public Criterion interpret(Element filterPart, boolean pushNot) throws QueryException {
        LOGGER.debug("Interpreting '{}', pushNot '{}'", new Object[]{DOMUtil.getQNameWithoutPrefix((Node)filterPart), pushNot});
        this.validate(filterPart);
        Operation operation = this.getOperationType(filterPart);
        List elements = DOMUtil.listChildElements((Node)filterPart);
        LOGGER.debug("It's {} with {} sub elements.", new Object[]{operation, elements.size()});
        switch (elements.size()) {
            case 0: {
                throw new QueryException("Can't have logical filter '" + DOMUtil.getQNameWithoutPrefix((Node)filterPart) + "' without filter children.");
            }
            case 1: {
                boolean newPushNot = pushNot;
                if (Operation.NOT.equals((Object)operation)) {
                    newPushNot = !newPushNot;
                }
                return this.getInterpreter().interpret((Element)elements.get(0), newPushNot);
            }
        }
        switch (operation) {
            case NOT: {
                throw new QueryException("Can't create filter NOT (unary) with more than one element.");
            }
            case AND: {
                Conjunction conjunction = Restrictions.conjunction();
                this.updateJunction(elements, pushNot, (Junction)conjunction);
                return conjunction;
            }
            case OR: {
                Disjunction disjunction = Restrictions.disjunction();
                this.updateJunction(elements, pushNot, (Junction)disjunction);
                return disjunction;
            }
        }
        throw new QueryException("Unknown state in logical filter.");
    }

    private Junction updateJunction(List<Element> elements, boolean pushNot, Junction junction) throws QueryException {
        for (Element element : elements) {
            if (SchemaConstantsGenerated.Q_TYPE.equals(DOMUtil.getQNameWithoutPrefix((Node)element))) {
                LOGGER.debug("Unsupported (unused) element '" + SchemaConstantsGenerated.Q_TYPE + "' in logical filter in query.");
                continue;
            }
            junction.add(this.getInterpreter().interpret(element, pushNot));
        }
        return junction;
    }

    private Operation getOperationType(Element filterPart) throws QueryException {
        if (DOMUtil.isElementName((Element)filterPart, (QName)SchemaConstantsGenerated.Q_AND)) {
            return Operation.AND;
        }
        if (DOMUtil.isElementName((Element)filterPart, (QName)SchemaConstantsGenerated.Q_OR)) {
            return Operation.OR;
        }
        if (DOMUtil.isElementName((Element)filterPart, (QName)SchemaConstantsGenerated.Q_OR)) {
            return Operation.NOT;
        }
        throw new QueryException("Unknown filter type '" + DOMUtil.getQNameWithoutPrefix((Node)filterPart) + "'.");
    }

    @Override
    protected QName[] canHandle() {
        return new QName[]{SchemaConstantsGenerated.Q_AND, SchemaConstantsGenerated.Q_OR, SchemaConstantsGenerated.Q_NOT};
    }

    private static enum Operation {
        AND,
        OR,
        NOT;

    }
}

