/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.repo.sql.query.Definition;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public class EntityDefinition
extends Definition
implements DebugDumpable {
    private Map<QName, Definition> definitions = new HashMap<QName, Definition>();
    private boolean any;
    private boolean embedded;

    public boolean isAny() {
        return this.any;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public void setAny(boolean any) {
        this.any = any;
    }

    @Override
    public Definition findDefinition(QName qname) {
        return this.findDefinition(qname, Definition.class);
    }

    @Override
    public <T extends Definition> T findDefinition(QName qname, Class<T> type) {
        Validate.notNull((Object)qname, (String)"QName must not be null.");
        Validate.notNull(type, (String)"Class type must not be null.");
        Definition definition = this.definitions.get(qname);
        if (definition == null) {
            return null;
        }
        if (type.isAssignableFrom(definition.getClass())) {
            return (T)definition;
        }
        return null;
    }

    @Override
    public boolean isEntity() {
        return true;
    }

    void putDefinition(QName qname, Definition definition) {
        this.definitions.put(qname, definition);
    }

    public String toString() {
        return this.debugDump();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append("n: ");
        sb.append(this.getName());
        sb.append(", t: ");
        sb.append(this.getType());
        sb.append(", a: ");
        sb.append(this.isAny());
        sb.append(", e: ");
        sb.append(this.isEmbedded());
        sb.append("\n");
        DebugUtil.debugDumpMapMultiLine((StringBuilder)sb, this.definitions, (int)(indent + 1));
        return sb.toString();
    }
}

