/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RActivation;
import com.evolveum.midpoint.repo.sql.data.common.RAssignment;
import com.evolveum.midpoint.repo.sql.data.common.RCredentials;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RPolyString;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.query.QueryEntity;
import com.evolveum.midpoint.repo.sql.util.ContainerIdGenerator;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@Table(appliesTo="m_user", indexes={@Index(name="iUserEnabled", columnNames={"enabled"}), @Index(name="iFullName", columnNames={"fullName_norm"}), @Index(name="iFamilyName", columnNames={"familyName_norm"}), @Index(name="iGivenName", columnNames={"givenName_norm"}), @Index(name="iLocality", columnNames={"locality_norm"}), @Index(name="iAdditionalName", columnNames={"additionalName_norm"}), @Index(name="iHonorificPrefix", columnNames={"honorificPrefix_norm"}), @Index(name="iHonorificSuffix", columnNames={"honorificSuffix_norm"})})
@ForeignKey(name="fk_user")
public class RUser
extends RObject {
    @QueryAttribute
    private String name;
    @QueryAttribute(polyString=true)
    private RPolyString fullName;
    @QueryAttribute
    private RPolyString givenName;
    @QueryAttribute
    private RPolyString familyName;
    @QueryAttribute
    private RPolyString additionalName;
    @QueryAttribute
    private RPolyString honorificPrefix;
    @QueryAttribute
    private RPolyString honorificSuffix;
    @QueryAttribute
    private String emailAddress;
    @QueryAttribute
    private String telephoneNumber;
    @QueryAttribute
    private String employeeNumber;
    private Set<String> employeeType;
    private Set<RPolyString> organizationalUnit;
    @QueryAttribute
    private RPolyString locality;
    @QueryEntity(embedded=true)
    private RCredentials credentials;
    @QueryEntity(embedded=true)
    private RActivation activation;
    @QueryAttribute
    private String costCenter;
    @QueryAttribute
    private String locale;
    @QueryAttribute
    private String timezone;
    @QueryAttribute
    private RPolyString title;
    @QueryAttribute
    private RPolyString nickName;
    @QueryAttribute
    private String preferredLanguage;
    private Set<RObjectReference> accountRefs;
    private Set<RAssignment> assignments;

    @OneToMany(mappedBy="owner", orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    public Set<RObjectReference> getAccountRefs() {
        if (this.accountRefs == null) {
            this.accountRefs = new HashSet<RObjectReference>();
        }
        return this.accountRefs;
    }

    @OneToMany(mappedBy="owner", orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    public Set<RAssignment> getAssignments() {
        if (this.assignments == null) {
            this.assignments = new HashSet<RAssignment>();
        }
        return this.assignments;
    }

    @Embedded
    public RActivation getActivation() {
        return this.activation;
    }

    @Embedded
    public RPolyString getAdditionalName() {
        return this.additionalName;
    }

    @Embedded
    public RCredentials getCredentials() {
        return this.credentials;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    @ElementCollection
    @ForeignKey(name="fk_user_org_unit")
    @CollectionTable(name="m_user_organizational_unit", joinColumns={@JoinColumn(name="user_oid", referencedColumnName="oid"), @JoinColumn(name="user_id", referencedColumnName="id")})
    @Cascade(value={CascadeType.ALL})
    public Set<RPolyString> getOrganizationalUnit() {
        return this.organizationalUnit;
    }

    public String getTelephoneNumber() {
        return this.telephoneNumber;
    }

    @ElementCollection
    @ForeignKey(name="fk_user_employee_type")
    @CollectionTable(name="m_user_employee_type", joinColumns={@JoinColumn(name="user_oid", referencedColumnName="oid"), @JoinColumn(name="user_id", referencedColumnName="id")})
    @Cascade(value={CascadeType.ALL})
    public Set<String> getEmployeeType() {
        return this.employeeType;
    }

    @Embedded
    public RPolyString getFamilyName() {
        return this.familyName;
    }

    @Embedded
    public RPolyString getFullName() {
        return this.fullName;
    }

    @Embedded
    public RPolyString getGivenName() {
        return this.givenName;
    }

    @Embedded
    public RPolyString getLocality() {
        return this.locality;
    }

    @Index(name="iEmployeeNumber")
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    @Embedded
    public RPolyString getHonorificPrefix() {
        return this.honorificPrefix;
    }

    @Embedded
    public RPolyString getHonorificSuffix() {
        return this.honorificSuffix;
    }

    @Index(name="iUserName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public String getCostCenter() {
        return this.costCenter;
    }

    public String getLocale() {
        return this.locale;
    }

    @Embedded
    public RPolyString getNickName() {
        return this.nickName;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public String getTimezone() {
        return this.timezone;
    }

    @Embedded
    public RPolyString getTitle() {
        return this.title;
    }

    public void setCostCenter(String costCenter) {
        this.costCenter = costCenter;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setNickName(RPolyString nickName) {
        this.nickName = nickName;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setTitle(RPolyString title) {
        this.title = title;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setActivation(RActivation activation) {
        this.activation = activation;
    }

    public void setAdditionalName(RPolyString additionalName) {
        this.additionalName = additionalName;
    }

    public void setCredentials(RCredentials credentials) {
        this.credentials = credentials;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setEmployeeNumber(String employeeNumber) {
        this.employeeNumber = employeeNumber;
    }

    public void setEmployeeType(Set<String> employeeType) {
        this.employeeType = employeeType;
    }

    public void setFamilyName(RPolyString familyName) {
        this.familyName = familyName;
    }

    public void setGivenName(RPolyString givenName) {
        this.givenName = givenName;
    }

    public void setHonorificPrefix(RPolyString honorificPrefix) {
        this.honorificPrefix = honorificPrefix;
    }

    public void setHonorificSuffix(RPolyString honorificSuffix) {
        this.honorificSuffix = honorificSuffix;
    }

    public void setLocality(RPolyString locality) {
        this.locality = locality;
    }

    public void setOrganizationalUnit(Set<RPolyString> organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void setTelephoneNumber(String telephoneNumber) {
        this.telephoneNumber = telephoneNumber;
    }

    public void setAssignments(Set<RAssignment> assignments) {
        this.assignments = assignments;
    }

    public void setAccountRefs(Set<RObjectReference> accountRefs) {
        this.accountRefs = accountRefs;
    }

    public void setFullName(RPolyString fullName) {
        this.fullName = fullName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RUser rUser = (RUser)o;
        if (this.name != null ? !this.name.equals(rUser.name) : rUser.name != null) {
            return false;
        }
        if (this.activation != null ? !this.activation.equals(rUser.activation) : rUser.activation != null) {
            return false;
        }
        if (this.additionalName != null ? !this.additionalName.equals(rUser.additionalName) : rUser.additionalName != null) {
            return false;
        }
        if (this.credentials != null ? !this.credentials.equals(rUser.credentials) : rUser.credentials != null) {
            return false;
        }
        if (this.emailAddress != null ? !this.emailAddress.equals(rUser.emailAddress) : rUser.emailAddress != null) {
            return false;
        }
        if (this.employeeNumber != null ? !this.employeeNumber.equals(rUser.employeeNumber) : rUser.employeeNumber != null) {
            return false;
        }
        if (this.employeeType != null ? !this.employeeType.equals(rUser.employeeType) : rUser.employeeType != null) {
            return false;
        }
        if (this.familyName != null ? !this.familyName.equals(rUser.familyName) : rUser.familyName != null) {
            return false;
        }
        if (this.fullName != null ? !this.fullName.equals(rUser.fullName) : rUser.fullName != null) {
            return false;
        }
        if (this.givenName != null ? !this.givenName.equals(rUser.givenName) : rUser.givenName != null) {
            return false;
        }
        if (this.honorificPrefix != null ? !this.honorificPrefix.equals(rUser.honorificPrefix) : rUser.honorificPrefix != null) {
            return false;
        }
        if (this.honorificSuffix != null ? !this.honorificSuffix.equals(rUser.honorificSuffix) : rUser.honorificSuffix != null) {
            return false;
        }
        if (this.locality != null ? !this.locality.equals(rUser.locality) : rUser.locality != null) {
            return false;
        }
        if (this.organizationalUnit != null ? !this.organizationalUnit.equals(rUser.organizationalUnit) : rUser.organizationalUnit != null) {
            return false;
        }
        if (this.telephoneNumber != null ? !this.telephoneNumber.equals(rUser.telephoneNumber) : rUser.telephoneNumber != null) {
            return false;
        }
        if (this.assignments != null ? !this.assignments.equals(rUser.assignments) : rUser.assignments != null) {
            return false;
        }
        if (this.accountRefs != null ? !this.accountRefs.equals(rUser.accountRefs) : rUser.accountRefs != null) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(rUser.locale) : rUser.locale != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(rUser.title) : rUser.title != null) {
            return false;
        }
        if (this.nickName != null ? !this.nickName.equals(rUser.nickName) : rUser.nickName != null) {
            return false;
        }
        if (this.preferredLanguage != null ? !this.preferredLanguage.equals(rUser.preferredLanguage) : rUser.preferredLanguage != null) {
            return false;
        }
        if (this.timezone != null ? !this.timezone.equals(rUser.timezone) : rUser.timezone != null) {
            return false;
        }
        return !(this.costCenter != null ? !this.costCenter.equals(rUser.costCenter) : rUser.costCenter != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.fullName != null ? this.fullName.hashCode() : 0);
        result = 31 * result + (this.givenName != null ? this.givenName.hashCode() : 0);
        result = 31 * result + (this.familyName != null ? this.familyName.hashCode() : 0);
        result = 31 * result + (this.honorificPrefix != null ? this.honorificPrefix.hashCode() : 0);
        result = 31 * result + (this.honorificSuffix != null ? this.honorificSuffix.hashCode() : 0);
        result = 31 * result + (this.employeeNumber != null ? this.employeeNumber.hashCode() : 0);
        result = 31 * result + (this.locality != null ? this.locality.hashCode() : 0);
        result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
        result = 31 * result + (this.activation != null ? this.activation.hashCode() : 0);
        result = 31 * result + (this.costCenter != null ? this.costCenter.hashCode() : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.nickName != null ? this.nickName.hashCode() : 0);
        result = 31 * result + (this.preferredLanguage != null ? this.preferredLanguage.hashCode() : 0);
        result = 31 * result + (this.timezone != null ? this.timezone.hashCode() : 0);
        return result;
    }

    public static void copyFromJAXB(UserType jaxb, RUser repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setFullName(RPolyString.copyFromJAXB(jaxb.getFullName()));
        repo.setGivenName(RPolyString.copyFromJAXB(jaxb.getGivenName()));
        repo.setFamilyName(RPolyString.copyFromJAXB(jaxb.getFamilyName()));
        repo.setHonorificPrefix(RPolyString.copyFromJAXB(jaxb.getHonorificPrefix()));
        repo.setHonorificSuffix(RPolyString.copyFromJAXB(jaxb.getHonorificSuffix()));
        repo.setEmployeeNumber(jaxb.getEmployeeNumber());
        repo.setLocality(RPolyString.copyFromJAXB(jaxb.getLocality()));
        repo.setAdditionalName(RPolyString.copyFromJAXB(jaxb.getAdditionalName()));
        repo.setEmailAddress(jaxb.getEmailAddress());
        repo.setTelephoneNumber(jaxb.getTelephoneNumber());
        repo.setCostCenter(jaxb.getCostCenter());
        repo.setLocale(jaxb.getLocale());
        repo.setTimezone(jaxb.getTimezone());
        repo.setPreferredLanguage(jaxb.getPreferredLanguage());
        repo.setTitle(RPolyString.copyFromJAXB(jaxb.getTitle()));
        repo.setNickName(RPolyString.copyFromJAXB(jaxb.getNickName()));
        if (jaxb.getActivation() != null) {
            RActivation activation = new RActivation();
            RActivation.copyFromJAXB(jaxb.getActivation(), activation, prismContext);
            repo.setActivation(activation);
        }
        if (jaxb.getCredentials() != null) {
            RCredentials credentials = new RCredentials();
            RCredentials.copyFromJAXB(jaxb.getCredentials(), credentials, prismContext);
            repo.setCredentials(credentials);
        }
        repo.setEmployeeType(RUtil.listToSet(jaxb.getEmployeeType()));
        repo.setOrganizationalUnit(RUtil.listPolyToSet(jaxb.getOrganizationalUnit()));
        for (ObjectReferenceType accountRef : jaxb.getAccountRef()) {
            RObjectReference ref = RUtil.jaxbRefToRepo(accountRef, repo, prismContext);
            if (ref == null) continue;
            repo.getAccountRefs().add(ref);
        }
        ContainerIdGenerator gen = new ContainerIdGenerator();
        for (AssignmentType assignment : jaxb.getAssignment()) {
            RAssignment rAssignment = new RAssignment();
            rAssignment.setOwner(repo);
            RAssignment.copyFromJAXB(assignment, rAssignment, (ObjectType)jaxb, prismContext);
            gen.generate(null, rAssignment);
            repo.getAssignments().add(rAssignment);
        }
    }

    public static void copyToJAXB(RUser repo, UserType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setFullName(RPolyString.copyToJAXB(repo.getFullName()));
        jaxb.setGivenName(RPolyString.copyToJAXB(repo.getGivenName()));
        jaxb.setFamilyName(RPolyString.copyToJAXB(repo.getFamilyName()));
        jaxb.setHonorificPrefix(RPolyString.copyToJAXB(repo.getHonorificPrefix()));
        jaxb.setHonorificSuffix(RPolyString.copyToJAXB(repo.getHonorificSuffix()));
        jaxb.setEmployeeNumber(repo.getEmployeeNumber());
        jaxb.setLocality(RPolyString.copyToJAXB(repo.getLocality()));
        jaxb.setAdditionalName(RPolyString.copyToJAXB(repo.getAdditionalName()));
        jaxb.setEmailAddress(repo.getEmailAddress());
        jaxb.setTelephoneNumber(repo.getTelephoneNumber());
        jaxb.setCostCenter(repo.getCostCenter());
        jaxb.setTimezone(repo.getTimezone());
        jaxb.setLocale(repo.getLocale());
        jaxb.setPreferredLanguage(repo.getPreferredLanguage());
        jaxb.setTitle(RPolyString.copyToJAXB(repo.getTitle()));
        jaxb.setNickName(RPolyString.copyToJAXB(repo.getNickName()));
        if (repo.getActivation() != null) {
            jaxb.setActivation(repo.getActivation().toJAXB(prismContext));
        }
        if (repo.getCredentials() != null) {
            PropertyPath path = new PropertyPath(new QName[]{UserType.F_CREDENTIALS});
            jaxb.setCredentials(repo.getCredentials().toJAXB((ObjectType)jaxb, path, prismContext));
        }
        jaxb.getEmployeeType().addAll((Collection)RUtil.safeSetToList(repo.getEmployeeType()));
        jaxb.getOrganizationalUnit().addAll(RUtil.safeSetPolyToList(repo.getOrganizationalUnit()));
        for (RObjectReference repoRef : repo.getAccountRefs()) {
            jaxb.getAccountRef().add(repoRef.toJAXB(prismContext));
        }
        for (RAssignment rAssignment : repo.getAssignments()) {
            jaxb.getAssignment().add(rAssignment.toJAXB(prismContext));
        }
    }

    public UserType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        UserType object = new UserType();
        RUtil.revive((Objectable)object, prismContext);
        RUser.copyToJAXB(this, object, prismContext);
        return object;
    }
}

