/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.REmbeddedReference;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.ROperationResult;
import com.evolveum.midpoint.repo.sql.data.common.ROperationResultStatusType;
import com.evolveum.midpoint.repo.sql.data.common.RTaskBindingType;
import com.evolveum.midpoint.repo.sql.data.common.RTaskExclusivityStatusType;
import com.evolveum.midpoint.repo.sql.data.common.RTaskExecutionStatusType;
import com.evolveum.midpoint.repo.sql.data.common.RTaskRecurrenceType;
import com.evolveum.midpoint.repo.sql.data.common.RThreadStopActionType;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScheduleType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UriStack;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.OneToOne;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_task")
public class RTask
extends RObject {
    private static final Trace LOGGER = TraceManager.getTrace(RTask.class);
    @QueryAttribute
    private String name;
    private String taskIdentifier;
    @QueryAttribute(enumerated=true)
    private RTaskExecutionStatusType executionStatus;
    private RTaskExclusivityStatusType exclusivityStatus;
    private String node;
    @QueryAttribute
    private String category;
    private XMLGregorianCalendar claimExpirationTimestamp;
    private String handlerUri;
    private String otherHandlersUriStack;
    private ROperationResult result;
    private XMLGregorianCalendar lastRunStartTimestamp;
    private XMLGregorianCalendar lastRunFinishTimestamp;
    private XMLGregorianCalendar nextRunStartTime;
    private Long progress;
    private RTaskRecurrenceType recurrence;
    private RTaskBindingType binding;
    private String schedule;
    private String modelOperationState;
    private REmbeddedReference objectRef;
    private REmbeddedReference ownerRef;
    private ROperationResultStatusType resultStatus;
    private String canRunOnNode;
    private RThreadStopActionType threadStopAction;

    @Column(nullable=true)
    public String getCanRunOnNode() {
        return this.canRunOnNode;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=true)
    public ROperationResultStatusType getResultStatus() {
        return this.resultStatus;
    }

    public String getCategory() {
        return this.category;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=true)
    public RThreadStopActionType getThreadStopAction() {
        return this.threadStopAction;
    }

    @Embedded
    public REmbeddedReference getObjectRef() {
        return this.objectRef;
    }

    @Embedded
    public REmbeddedReference getOwnerRef() {
        return this.ownerRef;
    }

    @Type(type="org.hibernate.type.TextType")
    @Column(nullable=true)
    public String getModelOperationState() {
        return this.modelOperationState;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getOtherHandlersUriStack() {
        return this.otherHandlersUriStack;
    }

    @Type(type="org.hibernate.type.TextType")
    @Column(nullable=true)
    public String getSchedule() {
        return this.schedule;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(nullable=true)
    public RTaskBindingType getBinding() {
        return this.binding;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RTaskExclusivityStatusType getExclusivityStatus() {
        return this.exclusivityStatus;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RTaskExecutionStatusType getExecutionStatus() {
        return this.executionStatus;
    }

    @Enumerated(value=EnumType.ORDINAL)
    public RTaskRecurrenceType getRecurrence() {
        return this.recurrence;
    }

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public ROperationResult getResult() {
        return this.result;
    }

    @Index(name="iTaskName")
    @Column(name="objectName")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCanRunOnNode(String canRunOnNode) {
        this.canRunOnNode = canRunOnNode;
    }

    public void setResultStatus(ROperationResultStatusType resultStatus) {
        this.resultStatus = resultStatus;
    }

    public void setThreadStopAction(RThreadStopActionType threadStopAction) {
        this.threadStopAction = threadStopAction;
    }

    public void setObjectRef(REmbeddedReference objectRef) {
        this.objectRef = objectRef;
    }

    public void setOwnerRef(REmbeddedReference ownerRef) {
        this.ownerRef = ownerRef;
    }

    public XMLGregorianCalendar getClaimExpirationTimestamp() {
        return this.claimExpirationTimestamp;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getHandlerUri() {
        return this.handlerUri;
    }

    @Column(nullable=true)
    public XMLGregorianCalendar getLastRunFinishTimestamp() {
        return this.lastRunFinishTimestamp;
    }

    @Column(nullable=true)
    public XMLGregorianCalendar getLastRunStartTimestamp() {
        return this.lastRunStartTimestamp;
    }

    @Column(nullable=true)
    public XMLGregorianCalendar getNextRunStartTime() {
        return this.nextRunStartTime;
    }

    @Column(nullable=true)
    public String getNode() {
        return this.node;
    }

    @Column(nullable=true)
    public Long getProgress() {
        return this.progress;
    }

    @Column(nullable=true)
    public String getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public void setBinding(RTaskBindingType binding) {
        this.binding = binding;
    }

    public void setClaimExpirationTimestamp(XMLGregorianCalendar claimExpirationTimestamp) {
        this.claimExpirationTimestamp = claimExpirationTimestamp;
    }

    public void setExclusivityStatus(RTaskExclusivityStatusType exclusivityStatus) {
        this.exclusivityStatus = exclusivityStatus;
    }

    public void setExecutionStatus(RTaskExecutionStatusType executionStatus) {
        this.executionStatus = executionStatus;
    }

    public void setHandlerUri(String handlerUri) {
        this.handlerUri = handlerUri;
    }

    public void setLastRunFinishTimestamp(XMLGregorianCalendar lastRunFinishTimestamp) {
        this.lastRunFinishTimestamp = lastRunFinishTimestamp;
    }

    public void setLastRunStartTimestamp(XMLGregorianCalendar lastRunStartTimestamp) {
        this.lastRunStartTimestamp = lastRunStartTimestamp;
    }

    public void setNextRunStartTime(XMLGregorianCalendar nextRunStartTime) {
        this.nextRunStartTime = nextRunStartTime;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setProgress(Long progress) {
        this.progress = progress;
    }

    public void setRecurrence(RTaskRecurrenceType recurrence) {
        this.recurrence = recurrence;
    }

    public void setResult(ROperationResult result) {
        this.result = result;
    }

    public void setTaskIdentifier(String taskIdentifier) {
        this.taskIdentifier = taskIdentifier;
    }

    public void setModelOperationState(String modelOperationState) {
        this.modelOperationState = modelOperationState;
    }

    public void setOtherHandlersUriStack(String otherHandlersUriStack) {
        this.otherHandlersUriStack = otherHandlersUriStack;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RTask rTask = (RTask)o;
        if (this.name != null ? !this.name.equals(rTask.name) : rTask.name != null) {
            return false;
        }
        if (this.binding != rTask.binding) {
            return false;
        }
        if (this.claimExpirationTimestamp != null ? !this.claimExpirationTimestamp.equals(rTask.claimExpirationTimestamp) : rTask.claimExpirationTimestamp != null) {
            return false;
        }
        if (this.exclusivityStatus != rTask.exclusivityStatus) {
            return false;
        }
        if (this.executionStatus != rTask.executionStatus) {
            return false;
        }
        if (this.handlerUri != null ? !this.handlerUri.equals(rTask.handlerUri) : rTask.handlerUri != null) {
            return false;
        }
        if (this.lastRunFinishTimestamp != null ? !this.lastRunFinishTimestamp.equals(rTask.lastRunFinishTimestamp) : rTask.lastRunFinishTimestamp != null) {
            return false;
        }
        if (this.lastRunStartTimestamp != null ? !this.lastRunStartTimestamp.equals(rTask.lastRunStartTimestamp) : rTask.lastRunStartTimestamp != null) {
            return false;
        }
        if (this.modelOperationState != null ? !this.modelOperationState.equals(rTask.modelOperationState) : rTask.modelOperationState != null) {
            return false;
        }
        if (this.nextRunStartTime != null ? !this.nextRunStartTime.equals(rTask.nextRunStartTime) : rTask.nextRunStartTime != null) {
            return false;
        }
        if (this.node != null ? !this.node.equals(rTask.node) : rTask.node != null) {
            return false;
        }
        if (this.objectRef != null ? !this.objectRef.equals(rTask.objectRef) : rTask.objectRef != null) {
            return false;
        }
        if (this.otherHandlersUriStack != null ? !this.otherHandlersUriStack.equals(rTask.otherHandlersUriStack) : rTask.otherHandlersUriStack != null) {
            return false;
        }
        if (this.ownerRef != null ? !this.ownerRef.equals(rTask.ownerRef) : rTask.ownerRef != null) {
            return false;
        }
        if (this.progress != null ? !this.progress.equals(rTask.progress) : rTask.progress != null) {
            return false;
        }
        if (this.recurrence != rTask.recurrence) {
            return false;
        }
        if (this.result != null ? !this.result.equals(rTask.result) : rTask.result != null) {
            return false;
        }
        if (this.schedule != null ? !this.schedule.equals(rTask.schedule) : rTask.schedule != null) {
            return false;
        }
        if (this.taskIdentifier != null ? !this.taskIdentifier.equals(rTask.taskIdentifier) : rTask.taskIdentifier != null) {
            return false;
        }
        if (this.resultStatus != null ? !this.resultStatus.equals((Object)rTask.resultStatus) : rTask.resultStatus != null) {
            return false;
        }
        if (this.canRunOnNode != null ? !this.canRunOnNode.equals(rTask.canRunOnNode) : rTask.canRunOnNode != null) {
            return false;
        }
        if (this.threadStopAction != null ? !this.threadStopAction.equals((Object)rTask.threadStopAction) : rTask.threadStopAction != null) {
            return false;
        }
        return !(this.category != null ? !this.category.equals(rTask.category) : rTask.category != null);
    }

    @Override
    public int hashCode() {
        int result1 = super.hashCode();
        result1 = 31 * result1 + (this.name != null ? this.name.hashCode() : 0);
        result1 = 31 * result1 + (this.taskIdentifier != null ? this.taskIdentifier.hashCode() : 0);
        result1 = 31 * result1 + (this.executionStatus != null ? this.executionStatus.hashCode() : 0);
        result1 = 31 * result1 + (this.exclusivityStatus != null ? this.exclusivityStatus.hashCode() : 0);
        result1 = 31 * result1 + (this.node != null ? this.node.hashCode() : 0);
        result1 = 31 * result1 + (this.claimExpirationTimestamp != null ? this.claimExpirationTimestamp.hashCode() : 0);
        result1 = 31 * result1 + (this.handlerUri != null ? this.handlerUri.hashCode() : 0);
        result1 = 31 * result1 + (this.otherHandlersUriStack != null ? this.otherHandlersUriStack.hashCode() : 0);
        result1 = 31 * result1 + (this.lastRunStartTimestamp != null ? this.lastRunStartTimestamp.hashCode() : 0);
        result1 = 31 * result1 + (this.lastRunFinishTimestamp != null ? this.lastRunFinishTimestamp.hashCode() : 0);
        result1 = 31 * result1 + (this.nextRunStartTime != null ? this.nextRunStartTime.hashCode() : 0);
        result1 = 31 * result1 + (this.progress != null ? this.progress.hashCode() : 0);
        result1 = 31 * result1 + (this.recurrence != null ? this.recurrence.hashCode() : 0);
        result1 = 31 * result1 + (this.binding != null ? this.binding.hashCode() : 0);
        result1 = 31 * result1 + (this.schedule != null ? this.schedule.hashCode() : 0);
        result1 = 31 * result1 + (this.modelOperationState != null ? this.modelOperationState.hashCode() : 0);
        result1 = 31 * result1 + (this.resultStatus != null ? this.resultStatus.hashCode() : 0);
        result1 = 31 * result1 + (this.canRunOnNode != null ? this.canRunOnNode.hashCode() : 0);
        result1 = 31 * result1 + (this.threadStopAction != null ? this.threadStopAction.hashCode() : 0);
        result1 = 31 * result1 + (this.category != null ? this.category.hashCode() : 0);
        return result1;
    }

    public static void copyToJAXB(RTask repo, TaskType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setTaskIdentifier(repo.getTaskIdentifier());
        jaxb.setClaimExpirationTimestamp(repo.getClaimExpirationTimestamp());
        if (repo.getExclusivityStatus() != null) {
            jaxb.setExclusivityStatus(repo.getExclusivityStatus().getStatus());
        }
        if (repo.getExecutionStatus() != null) {
            jaxb.setExecutionStatus(repo.getExecutionStatus().getStatus());
        }
        jaxb.setHandlerUri(repo.getHandlerUri());
        jaxb.setLastRunFinishTimestamp(repo.getLastRunFinishTimestamp());
        jaxb.setLastRunStartTimestamp(repo.getLastRunStartTimestamp());
        jaxb.setNode(repo.getNode());
        jaxb.setProgress(repo.getProgress());
        if (repo.getBinding() != null) {
            jaxb.setBinding(repo.getBinding().getBinding());
        }
        jaxb.setNextRunStartTime(repo.getNextRunStartTime());
        if (repo.getRecurrence() != null) {
            jaxb.setRecurrence(repo.getRecurrence().getRecurrence());
        }
        if (repo.getResultStatus() != null) {
            jaxb.setResultStatus(repo.getResultStatus().getStatus());
        }
        jaxb.setCanRunOnNode(repo.getCanRunOnNode());
        if (repo.getThreadStopAction() != null) {
            jaxb.setThreadStopAction(repo.getThreadStopAction().getAction());
        }
        jaxb.setCategory(repo.getCategory());
        if (repo.getObjectRef() != null) {
            jaxb.setObjectRef(repo.getObjectRef().toJAXB(prismContext));
        }
        if (repo.getOwnerRef() != null) {
            jaxb.setOwnerRef(repo.getOwnerRef().toJAXB(prismContext));
        }
        if (repo.getResult() != null) {
            jaxb.setResult(repo.getResult().toJAXB(prismContext));
        }
        try {
            jaxb.setModelOperationState(RUtil.toJAXB(TaskType.class, new PropertyPath(new QName[]{TaskType.F_MODEL_OPERATION_STATE}), repo.getModelOperationState(), ModelOperationStateType.class, prismContext));
            jaxb.setOtherHandlersUriStack(RUtil.toJAXB(TaskType.class, new PropertyPath(new QName[]{TaskType.F_OTHER_HANDLERS_URI_STACK}), repo.getOtherHandlersUriStack(), UriStack.class, prismContext));
            jaxb.setSchedule(RUtil.toJAXB(TaskType.class, new PropertyPath(new QName[]{TaskType.F_SCHEDULE}), repo.getSchedule(), ScheduleType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(TaskType jaxb, RTask repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setTaskIdentifier(jaxb.getTaskIdentifier());
        repo.setClaimExpirationTimestamp(jaxb.getClaimExpirationTimestamp());
        repo.setExclusivityStatus(RTaskExclusivityStatusType.toRepoType(jaxb.getExclusivityStatus()));
        repo.setExecutionStatus(RTaskExecutionStatusType.toRepoType(jaxb.getExecutionStatus()));
        repo.setHandlerUri(jaxb.getHandlerUri());
        repo.setLastRunFinishTimestamp(jaxb.getLastRunFinishTimestamp());
        repo.setLastRunStartTimestamp(jaxb.getLastRunStartTimestamp());
        repo.setNode(jaxb.getNode());
        repo.setProgress(jaxb.getProgress());
        repo.setBinding(RTaskBindingType.toRepoType(jaxb.getBinding()));
        repo.setNextRunStartTime(jaxb.getNextRunStartTime());
        repo.setRecurrence(RTaskRecurrenceType.toRepoType(jaxb.getRecurrence()));
        repo.setResultStatus(ROperationResultStatusType.toRepoType(jaxb.getResultStatus()));
        repo.setCanRunOnNode(jaxb.getCanRunOnNode());
        repo.setThreadStopAction(RThreadStopActionType.toRepoType(jaxb.getThreadStopAction()));
        repo.setCategory(jaxb.getCategory());
        repo.setObjectRef(RUtil.jaxbRefToEmbeddedRepoRef(jaxb.getObjectRef(), prismContext));
        repo.setOwnerRef(RUtil.jaxbRefToEmbeddedRepoRef(jaxb.getOwnerRef(), prismContext));
        if (jaxb.getResult() != null) {
            ROperationResult result = new ROperationResult();
            result.setOwner(repo);
            ROperationResult.copyFromJAXB(jaxb.getResult(), result, prismContext);
            repo.setResult(result);
        }
        try {
            repo.setModelOperationState(RUtil.toRepo(jaxb.getModelOperationState(), prismContext));
            repo.setOtherHandlersUriStack(RUtil.toRepo(jaxb.getOtherHandlersUriStack(), prismContext));
            repo.setSchedule(RUtil.toRepo(jaxb.getSchedule(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public TaskType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        TaskType object = new TaskType();
        RUtil.revive((Objectable)object, prismContext);
        RTask.copyToJAXB(this, object, prismContext);
        return object;
    }
}

