/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RAssignment;
import com.evolveum.midpoint.repo.sql.data.common.RExclusion;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.ContainerIdGenerator;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExclusionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.RoleType;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@ForeignKey(name="fk_role")
public class RRole
extends RObject {
    @QueryAttribute
    private String name;
    private Set<RAssignment> assignments;
    private Set<RExclusion> exclusions;

    @OneToMany(mappedBy="owner", orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    public Set<RAssignment> getAssignments() {
        if (this.assignments == null) {
            this.assignments = new HashSet<RAssignment>();
        }
        return this.assignments;
    }

    @OneToMany(mappedBy="owner", orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    public Set<RExclusion> getExclusions() {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<RExclusion>();
        }
        return this.exclusions;
    }

    @Index(name="iRoleName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExclusions(Set<RExclusion> exclusions) {
        this.exclusions = exclusions;
    }

    public void setAssignments(Set<RAssignment> assignments) {
        this.assignments = assignments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RRole rRole = (RRole)o;
        if (this.name != null ? !this.name.equals(rRole.name) : rRole.name != null) {
            return false;
        }
        if (this.assignments != null ? !this.assignments.equals(rRole.assignments) : rRole.assignments != null) {
            return false;
        }
        return !(this.exclusions != null ? !this.exclusions.equals(rRole.exclusions) : rRole.exclusions != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RRole repo, RoleType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        if (repo.getAssignments() != null) {
            for (RAssignment rAssignment : repo.getAssignments()) {
                jaxb.getAssignment().add(rAssignment.toJAXB(prismContext));
            }
        }
        if (repo.getExclusions() != null) {
            for (RExclusion rExclusion : repo.getExclusions()) {
                jaxb.getExclusion().add(rExclusion.toJAXB(prismContext));
            }
        }
    }

    public static void copyFromJAXB(RoleType jaxb, RRole repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        if (jaxb.getAssignment() != null && !jaxb.getAssignment().isEmpty()) {
            repo.setAssignments(new HashSet<RAssignment>());
        }
        ContainerIdGenerator gen = new ContainerIdGenerator();
        for (AssignmentType assignment : jaxb.getAssignment()) {
            RAssignment rAssignment = new RAssignment();
            rAssignment.setOwner(repo);
            RAssignment.copyFromJAXB(assignment, rAssignment, (ObjectType)jaxb, prismContext);
            gen.generate(null, rAssignment);
            repo.getAssignments().add(rAssignment);
        }
        if (jaxb.getExclusion() != null && !jaxb.getExclusion().isEmpty()) {
            repo.setExclusions(new HashSet<RExclusion>());
        }
        for (ExclusionType exclusion : jaxb.getExclusion()) {
            RExclusion rExclusion = new RExclusion();
            rExclusion.setOwner(repo);
            RExclusion.copyFromJAXB(exclusion, rExclusion, (ObjectType)jaxb, prismContext);
            gen.generate(null, rExclusion);
            repo.getExclusions().add(rExclusion);
        }
    }

    public RoleType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        RoleType object = new RoleType();
        RRole.copyToJAXB(this, object, prismContext);
        RUtil.revive((Objectable)object, prismContext);
        return object;
    }
}

