/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.NodeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.xml.datatype.XMLGregorianCalendar;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@ForeignKey(name="fk_node")
public class RNode
extends RObject {
    @QueryAttribute
    private String name;
    private String nodeIdentifier;
    private String hostname;
    private Integer jmxPort;
    private XMLGregorianCalendar lastCheckInTime;
    private Boolean running;
    private Boolean clustered;
    private String internalNodeIdentifier;

    @Column(nullable=true)
    public String getHostname() {
        return this.hostname;
    }

    public Boolean getClustered() {
        return this.clustered;
    }

    public String getInternalNodeIdentifier() {
        return this.internalNodeIdentifier;
    }

    @Column(nullable=true)
    public Integer getJmxPort() {
        return this.jmxPort;
    }

    @Column(nullable=true)
    public XMLGregorianCalendar getLastCheckInTime() {
        return this.lastCheckInTime;
    }

    public Boolean getRunning() {
        return this.running;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    @Index(name="iNodeName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNodeIdentifier(String nodeIdentifier) {
        this.nodeIdentifier = nodeIdentifier;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setClustered(Boolean clustered) {
        this.clustered = clustered;
    }

    public void setInternalNodeIdentifier(String internalNodeIdentifier) {
        this.internalNodeIdentifier = internalNodeIdentifier;
    }

    public void setJmxPort(Integer jmxPort) {
        this.jmxPort = jmxPort;
    }

    public void setLastCheckInTime(XMLGregorianCalendar lastCheckInTime) {
        this.lastCheckInTime = lastCheckInTime;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RNode rNode = (RNode)o;
        if (this.name != null ? !this.name.equals(rNode.name) : rNode.name != null) {
            return false;
        }
        if (this.clustered != null ? !this.clustered.equals(rNode.clustered) : rNode.clustered != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(rNode.hostname) : rNode.hostname != null) {
            return false;
        }
        if (this.internalNodeIdentifier != null ? !this.internalNodeIdentifier.equals(rNode.internalNodeIdentifier) : rNode.internalNodeIdentifier != null) {
            return false;
        }
        if (this.jmxPort != null ? !this.jmxPort.equals(rNode.jmxPort) : rNode.jmxPort != null) {
            return false;
        }
        if (this.lastCheckInTime != null ? !this.lastCheckInTime.equals(rNode.lastCheckInTime) : rNode.lastCheckInTime != null) {
            return false;
        }
        if (this.nodeIdentifier != null ? !this.nodeIdentifier.equals(rNode.nodeIdentifier) : rNode.nodeIdentifier != null) {
            return false;
        }
        return !(this.running != null ? !this.running.equals(rNode.running) : rNode.running != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.nodeIdentifier != null ? this.nodeIdentifier.hashCode() : 0);
        result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 31 * result + (this.jmxPort != null ? this.jmxPort.hashCode() : 0);
        result = 31 * result + (this.lastCheckInTime != null ? this.lastCheckInTime.hashCode() : 0);
        result = 31 * result + (this.running != null ? this.running.hashCode() : 0);
        result = 31 * result + (this.clustered != null ? this.clustered.hashCode() : 0);
        result = 31 * result + (this.internalNodeIdentifier != null ? this.internalNodeIdentifier.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RNode repo, NodeType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setHostname(repo.getHostname());
        jaxb.setNodeIdentifier(repo.getNodeIdentifier());
        jaxb.setJmxPort(repo.getJmxPort());
        jaxb.setLastCheckInTime(repo.getLastCheckInTime());
        jaxb.setRunning(repo.getRunning());
        jaxb.setClustered(repo.getClustered());
        jaxb.setInternalNodeIdentifier(repo.getInternalNodeIdentifier());
    }

    public static void copyFromJAXB(NodeType jaxb, RNode repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setHostname(jaxb.getHostname());
        repo.setNodeIdentifier(jaxb.getNodeIdentifier());
        repo.setJmxPort(jaxb.getJmxPort());
        repo.setLastCheckInTime(jaxb.getLastCheckInTime());
        repo.setRunning(jaxb.isRunning());
        repo.setClustered(jaxb.isClustered());
        repo.setInternalNodeIdentifier(jaxb.getInternalNodeIdentifier());
    }

    public NodeType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        NodeType object = new NodeType();
        RUtil.revive((Objectable)object, prismContext);
        RNode.copyToJAXB(this, object, prismContext);
        return object;
    }
}

