/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.GenericObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;

@Entity
@ForeignKey(name="fk_generic_object")
public class RGenericObject
extends RObject {
    @QueryAttribute
    private String name;
    private String objectType;

    public String getObjectType() {
        return this.objectType;
    }

    @Index(name="iGenericObjectName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RGenericObject that = (RGenericObject)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.objectType != null ? !this.objectType.equals(that.objectType) : that.objectType != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.objectType != null ? this.objectType.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RGenericObject repo, GenericObjectType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setObjectType(repo.getObjectType());
    }

    public static void copyFromJAXB(GenericObjectType jaxb, RGenericObject repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setObjectType(jaxb.getObjectType());
    }

    public GenericObjectType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        GenericObjectType object = new GenericObjectType();
        RUtil.revive((Objectable)object, prismContext);
        RGenericObject.copyToJAXB(this, object, prismContext);
        return object;
    }
}

