/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import java.util.Collection;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.xml.namespace.QName;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;

@Entity
@ForeignKey(name="fk_connector")
public class RConnector
extends RObject {
    private static final Trace LOGGER = TraceManager.getTrace(RConnector.class);
    @QueryAttribute
    private String name;
    @QueryAttribute
    private String framework;
    private RObjectReference connectorHostRef;
    @QueryAttribute
    private String connectorType;
    @QueryAttribute
    private String connectorVersion;
    @QueryAttribute
    private String connectorBundle;
    private Set<String> targetSystemType;
    @QueryAttribute
    private String namespace;
    private String xmlSchema;

    @OneToOne(optional=true, mappedBy="owner", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    public RObjectReference getConnectorHostRef() {
        return this.connectorHostRef;
    }

    public String getConnectorBundle() {
        return this.connectorBundle;
    }

    public String getConnectorType() {
        return this.connectorType;
    }

    public String getConnectorVersion() {
        return this.connectorVersion;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @ElementCollection
    @ForeignKey(name="fk_connector_target_system")
    @CollectionTable(name="m_connector_target_system", joinColumns={@JoinColumn(name="connector_oid", referencedColumnName="oid"), @JoinColumn(name="connector_id", referencedColumnName="id")})
    @Cascade(value={CascadeType.ALL})
    public Set<String> getTargetSystemType() {
        return this.targetSystemType;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getXmlSchema() {
        return this.xmlSchema;
    }

    public String getFramework() {
        return this.framework;
    }

    @Index(name="iConnectorName")
    @Column(name="objectName", unique=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFramework(String framework) {
        this.framework = framework;
    }

    public void setConnectorHostRef(RObjectReference connectorHostRef) {
        this.connectorHostRef = connectorHostRef;
    }

    public void setConnectorBundle(String connectorBundle) {
        this.connectorBundle = connectorBundle;
    }

    public void setConnectorType(String connectorType) {
        this.connectorType = connectorType;
    }

    public void setConnectorVersion(String connectorVersion) {
        this.connectorVersion = connectorVersion;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTargetSystemType(Set<String> targetSystemType) {
        this.targetSystemType = targetSystemType;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RConnector that = (RConnector)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.connectorBundle != null ? !this.connectorBundle.equals(that.connectorBundle) : that.connectorBundle != null) {
            return false;
        }
        if (this.connectorHostRef != null ? !this.connectorHostRef.equals(that.connectorHostRef) : that.connectorHostRef != null) {
            return false;
        }
        if (this.connectorType != null ? !this.connectorType.equals(that.connectorType) : that.connectorType != null) {
            return false;
        }
        if (this.connectorVersion != null ? !this.connectorVersion.equals(that.connectorVersion) : that.connectorVersion != null) {
            return false;
        }
        if (this.framework != null ? !this.framework.equals(that.framework) : that.framework != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        if (this.targetSystemType != null ? !this.targetSystemType.equals(that.targetSystemType) : that.targetSystemType != null) {
            return false;
        }
        return !(this.xmlSchema != null ? !this.xmlSchema.equals(that.xmlSchema) : that.xmlSchema != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.framework != null ? this.framework.hashCode() : 0);
        result = 31 * result + (this.connectorType != null ? this.connectorType.hashCode() : 0);
        result = 31 * result + (this.connectorVersion != null ? this.connectorVersion.hashCode() : 0);
        result = 31 * result + (this.connectorBundle != null ? this.connectorBundle.hashCode() : 0);
        result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
        result = 31 * result + (this.xmlSchema != null ? this.xmlSchema.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RConnector repo, ConnectorType jaxb, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyToJAXB(repo, (ObjectType)jaxb, prismContext);
        jaxb.setName(repo.getName());
        jaxb.setConnectorBundle(repo.getConnectorBundle());
        jaxb.setConnectorType(repo.getConnectorType());
        jaxb.setConnectorVersion(repo.getConnectorVersion());
        jaxb.setFramework(repo.getFramework());
        jaxb.setNamespace(repo.getNamespace());
        try {
            jaxb.setSchema(RUtil.toJAXB(ConnectorType.class, new PropertyPath(new QName[]{ConnectorType.F_SCHEMA}), repo.getXmlSchema(), XmlSchemaType.class, prismContext));
            if (repo.getConnectorHostRef() != null) {
                jaxb.setConnectorHostRef(repo.getConnectorHostRef().toJAXB(prismContext));
            }
            jaxb.getTargetSystemType().addAll((Collection)RUtil.safeSetToList(repo.getTargetSystemType()));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static void copyFromJAXB(ConnectorType jaxb, RConnector repo, PrismContext prismContext) throws DtoTranslationException {
        RObject.copyFromJAXB((ObjectType)jaxb, repo, prismContext);
        repo.setName(jaxb.getName());
        repo.setConnectorBundle(jaxb.getConnectorBundle());
        repo.setConnectorType(jaxb.getConnectorType());
        repo.setConnectorVersion(jaxb.getConnectorVersion());
        repo.setFramework(jaxb.getFramework());
        repo.setNamespace(jaxb.getNamespace());
        repo.setConnectorHostRef(RUtil.jaxbRefToRepo(jaxb.getConnectorHostRef(), repo, prismContext));
        if (jaxb.getConnectorHost() != null) {
            LOGGER.warn("Connector host from connector type won't be saved. It should be translated to connector host reference.");
        }
        try {
            repo.setXmlSchema(RUtil.toRepo(jaxb.getSchema(), prismContext));
            repo.setTargetSystemType(RUtil.listToSet(jaxb.getTargetSystemType()));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public ConnectorType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        ConnectorType object = new ConnectorType();
        RUtil.revive((Objectable)object, prismContext);
        RConnector.copyToJAXB(this, object, prismContext);
        return object;
    }
}

