/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RAnyContainerId;
import com.evolveum.midpoint.repo.sql.data.common.RAnyConverter;
import com.evolveum.midpoint.repo.sql.data.common.RClobValue;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.RDateValue;
import com.evolveum.midpoint.repo.sql.data.common.RLongValue;
import com.evolveum.midpoint.repo.sql.data.common.RStringValue;
import com.evolveum.midpoint.repo.sql.data.common.RValue;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExtensionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowAttributesType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.Table;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;

@Entity
@IdClass(value=RAnyContainerId.class)
@Table(name="m_any")
public class RAnyContainer
implements Serializable {
    private RContainer owner;
    private String ownerOid;
    private Long ownerId;
    private RContainerType ownerType;
    private Set<RStringValue> strings;
    private Set<RLongValue> longs;
    private Set<RDateValue> dates;
    private Set<RClobValue> clobs;

    @ForeignKey(name="none")
    @MapsId(value="owner")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="owner_oid", referencedColumnName="oid"), @JoinColumn(name="owner_id", referencedColumnName="id")})
    public RContainer getOwner() {
        return this.owner;
    }

    @Column(name="owner_id")
    public Long getOwnerId() {
        if (this.ownerId == null && this.owner != null) {
            this.ownerId = this.owner.getId();
        }
        return this.ownerId;
    }

    @Column(name="owner_oid", length=36)
    public String getOwnerOid() {
        if (this.ownerOid == null && this.owner != null) {
            this.ownerOid = this.owner.getOid();
        }
        return this.ownerOid;
    }

    @Id
    @GeneratedValue(generator="ContainerTypeGenerator")
    @GenericGenerator(name="ContainerTypeGenerator", strategy="com.evolveum.midpoint.repo.sql.util.ContainerTypeGenerator")
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ownerType")
    public RContainerType getOwnerType() {
        return this.ownerType;
    }

    @ElementCollection
    @ForeignKey(name="fk_any_long")
    @CollectionTable(name="m_any_long", joinColumns={@JoinColumn(name="owner_oid"), @JoinColumn(name="owner_id"), @JoinColumn(name="ownerType")})
    @Cascade(value={CascadeType.ALL})
    public Set<RLongValue> getLongs() {
        return this.longs;
    }

    @ElementCollection
    @ForeignKey(name="fk_any_string")
    @CollectionTable(name="m_any_string", joinColumns={@JoinColumn(name="owner_oid"), @JoinColumn(name="owner_id"), @JoinColumn(name="ownerType")})
    @Cascade(value={CascadeType.ALL})
    public Set<RStringValue> getStrings() {
        return this.strings;
    }

    @ElementCollection
    @ForeignKey(name="fk_any_clob")
    @CollectionTable(name="m_any_clob", joinColumns={@JoinColumn(name="owner_oid"), @JoinColumn(name="owner_id"), @JoinColumn(name="ownerType")})
    @Cascade(value={CascadeType.ALL})
    public Set<RClobValue> getClobs() {
        return this.clobs;
    }

    @ElementCollection
    @ForeignKey(name="fk_any_date")
    @CollectionTable(name="m_any_date", joinColumns={@JoinColumn(name="owner_oid"), @JoinColumn(name="owner_id"), @JoinColumn(name="ownerType")})
    @Cascade(value={CascadeType.ALL})
    public Set<RDateValue> getDates() {
        return this.dates;
    }

    public void setOwnerType(RContainerType ownerType) {
        this.ownerType = ownerType;
    }

    public void setClobs(Set<RClobValue> clobs) {
        this.clobs = clobs;
    }

    public void setDates(Set<RDateValue> dates) {
        this.dates = dates;
    }

    public void setLongs(Set<RLongValue> longs) {
        this.longs = longs;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerOid(String ownerOid) {
        this.ownerOid = ownerOid;
    }

    public void setStrings(Set<RStringValue> strings) {
        this.strings = strings;
    }

    public void setOwner(RContainer owner) {
        this.owner = owner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RAnyContainer that = (RAnyContainer)o;
        if (this.clobs != null ? !this.clobs.equals(that.clobs) : that.clobs != null) {
            return false;
        }
        if (this.dates != null ? !this.dates.equals(that.dates) : that.dates != null) {
            return false;
        }
        if (this.longs != null ? !this.longs.equals(that.longs) : that.longs != null) {
            return false;
        }
        return !(this.strings != null ? !this.strings.equals(that.strings) : that.strings != null);
    }

    public int hashCode() {
        int result = this.ownerType != null ? this.ownerType.hashCode() : 0;
        return result;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static void copyToJAXB(RAnyContainer repo, ResourceObjectShadowAttributesType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        RAnyContainer.copyToJAXB(repo, jaxb.asPrismContainerValue(), prismContext);
    }

    public static void copyToJAXB(RAnyContainer repo, ExtensionType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        RAnyContainer.copyToJAXB(repo, jaxb.asPrismContainerValue(), prismContext);
    }

    private static void copyToJAXB(RAnyContainer repo, PrismContainerValue containerValue, PrismContext prismContext) throws DtoTranslationException {
        RAnyConverter converter = new RAnyConverter(prismContext);
        if (repo.getClobs() != null) {
            for (RClobValue rClobValue : repo.getClobs()) {
                converter.convertFromRValue(rClobValue, containerValue);
            }
        }
        if (repo.getDates() != null) {
            for (RDateValue rDateValue : repo.getDates()) {
                converter.convertFromRValue(rDateValue, containerValue);
            }
        }
        if (repo.getLongs() != null) {
            for (RLongValue rLongValue : repo.getLongs()) {
                converter.convertFromRValue(rLongValue, containerValue);
            }
        }
        if (repo.getStrings() != null) {
            for (RStringValue rStringValue : repo.getStrings()) {
                converter.convertFromRValue(rStringValue, containerValue);
            }
        }
    }

    public static void copyFromJAXB(ResourceObjectShadowAttributesType jaxb, RAnyContainer repo, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        RAnyContainer.copyFromJAXB(jaxb.asPrismContainerValue(), repo, prismContext);
    }

    public static void copyFromJAXB(ExtensionType jaxb, RAnyContainer repo, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        RAnyContainer.copyFromJAXB(jaxb.asPrismContainerValue(), repo, prismContext);
    }

    private static void copyFromJAXB(PrismContainerValue containerValue, RAnyContainer repo, PrismContext prismContext) throws DtoTranslationException {
        RAnyConverter converter = new RAnyConverter(prismContext);
        HashSet<RValue> values = new HashSet<RValue>();
        try {
            List items = containerValue.getItems();
            for (Item item : items) {
                values.addAll(converter.convertToRValue(item));
            }
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        for (RValue value : values) {
            if (value instanceof RClobValue) {
                if (repo.getClobs() == null) {
                    repo.setClobs(new HashSet<RClobValue>());
                }
                repo.getClobs().add((RClobValue)value);
                continue;
            }
            if (value instanceof RDateValue) {
                if (repo.getDates() == null) {
                    repo.setDates(new HashSet<RDateValue>());
                }
                repo.getDates().add((RDateValue)value);
                continue;
            }
            if (value instanceof RLongValue) {
                if (repo.getLongs() == null) {
                    repo.setLongs(new HashSet<RLongValue>());
                }
                repo.getLongs().add((RLongValue)value);
                continue;
            }
            if (!(value instanceof RStringValue)) continue;
            if (repo.getStrings() == null) {
                repo.setStrings(new HashSet<RStringValue>());
            }
            repo.getStrings().add((RStringValue)value);
        }
    }
}

