/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql;

import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactory;
import com.evolveum.midpoint.repo.api.RepositoryServiceFactoryException;
import com.evolveum.midpoint.repo.sql.SqlRepositoryConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryServiceImpl;
import com.evolveum.midpoint.repo.sql.query.QueryRegistry;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.h2.tools.Server;

public class SqlRepositoryFactory
implements RepositoryServiceFactory {
    private static final Trace LOGGER = TraceManager.getTrace(SqlRepositoryFactory.class);
    private static final String USER_HOME_VARIABLE = "user.home";
    private static final String MIDPOINT_HOME_VARIABLE = "midpoint.home";
    private SqlRepositoryConfiguration sqlConfiguration;
    private Server server;

    public SqlRepositoryConfiguration getSqlConfiguration() {
        Validate.notNull((Object)this.sqlConfiguration, (String)"Sql repository configuration not available (null).");
        return this.sqlConfiguration;
    }

    public void destroy() throws RepositoryServiceFactoryException {
        if (!this.getSqlConfiguration().isEmbedded()) {
            LOGGER.info("Repository is not running in embedded mode, shutdown complete.");
            return;
        }
        if (this.getSqlConfiguration().isAsServer()) {
            LOGGER.info("Shutting down embedded H2");
            if (this.server != null && this.server.isRunning(true)) {
                this.server.stop();
            }
        } else {
            LOGGER.info("H2 running as local instance (from file).");
        }
        LOGGER.info("Shutdown complete.");
    }

    public void destroyService(RepositoryService service) throws RepositoryServiceFactoryException {
    }

    public void init(Configuration configuration) throws RepositoryServiceFactoryException {
        Validate.notNull((Object)configuration, (String)"Configuration must not be null.");
        LOGGER.info("Initializing SQL repository factory");
        SqlRepositoryConfiguration config = new SqlRepositoryConfiguration(configuration);
        this.normalizeConfiguration(config);
        config.validate();
        this.sqlConfiguration = config;
        if (this.getSqlConfiguration().isEmbedded()) {
            this.dropDatabaseIfExists(config);
            if (this.getSqlConfiguration().isAsServer()) {
                LOGGER.info("Starting h2 in server mode.");
                this.startServer();
            } else {
                LOGGER.info("H2 prepared to run in local mode (from file).");
            }
            LOGGER.info("H2 files are in '{}'.", new Object[]{new File(this.sqlConfiguration.getBaseDir()).getAbsolutePath()});
        } else {
            LOGGER.info("Repository is not running in embedded mode.");
        }
        try {
            QueryRegistry.getInstance();
        }
        catch (Exception ex) {
            throw new RepositoryServiceFactoryException("Couldn't initialize query registry, reason: " + ex.getMessage(), (Throwable)ex);
        }
        LOGGER.info("Repository initialization finished.");
    }

    public RepositoryService getRepositoryService() throws RepositoryServiceFactoryException {
        return new SqlRepositoryServiceImpl();
    }

    private void normalizeConfiguration(SqlRepositoryConfiguration config) throws RepositoryServiceFactoryException {
        File baseDir;
        if (!config.isEmbedded()) {
            return;
        }
        if (StringUtils.isEmpty((String)config.getFileName())) {
            config.setFileName("midpoint");
        }
        if (StringUtils.isEmpty((String)config.getBaseDir())) {
            LOGGER.warn("Base dir path in configuration was not defined.");
            if (StringUtils.isNotEmpty((String)System.getProperty(MIDPOINT_HOME_VARIABLE))) {
                config.setBaseDir(System.getProperty(MIDPOINT_HOME_VARIABLE));
                LOGGER.info("Using {} with value {} as base dir for configuration.", new Object[]{MIDPOINT_HOME_VARIABLE, config.getBaseDir()});
            } else if (StringUtils.isNotEmpty((String)System.getProperty(USER_HOME_VARIABLE))) {
                config.setBaseDir(System.getProperty(USER_HOME_VARIABLE));
                LOGGER.info("Using {} with value {} as base dir for configuration.", new Object[]{USER_HOME_VARIABLE, config.getBaseDir()});
            } else {
                config.setBaseDir(".");
                LOGGER.info("Using '.' as base dir for configuration ({}, or {} was not defined).", new Object[]{MIDPOINT_HOME_VARIABLE, USER_HOME_VARIABLE});
            }
        }
        if (!(baseDir = new File(config.getBaseDir())).exists() || !baseDir.isDirectory()) {
            throw new RepositoryServiceFactoryException("File '" + config.getBaseDir() + "' defined as baseDir doesn't exist or is not directory.");
        }
        StringBuilder jdbcUrl = new StringBuilder("jdbc:h2:");
        if (config.isAsServer()) {
            jdbcUrl.append("tcp://127.0.0.1:");
            jdbcUrl.append(config.getPort());
            jdbcUrl.append("/");
            jdbcUrl.append(config.getFileName());
        } else {
            jdbcUrl.append("file:");
            File databaseFile = new File(config.getBaseDir(), config.getFileName());
            jdbcUrl.append(databaseFile.getAbsolutePath());
        }
        jdbcUrl.append(";DB_CLOSE_ON_EXIT=FALSE");
        jdbcUrl.append(";LOCK_MODE=1");
        jdbcUrl.append(";LOCK_TIMEOUT=10000");
        config.setJdbcUrl(jdbcUrl.toString());
        LOGGER.trace("JDBC url created: {}", new Object[]{config.getJdbcUrl()});
        config.setJdbcUsername("sa");
        config.setJdbcPassword("");
        config.setDriverClassName("org.h2.Driver");
        config.setHibernateDialect("org.hibernate.dialect.H2Dialect");
        config.setHibernateHbm2ddl("update");
    }

    private String getRelativeBaseDirPath(String baseDir) {
        return new File(".").toURI().relativize(new File(baseDir).toURI()).getPath();
    }

    private void checkPort(int port) throws RepositoryServiceFactoryException {
        if (port >= 65635 || port < 0) {
            throw new RepositoryServiceFactoryException("Port must be in range 0-65634, not '" + port + "'.");
        }
        ServerSocket ss = null;
        try {
            try {
                ss = new ServerSocket(port);
                ss.setReuseAddress(true);
            }
            catch (Exception e) {
                throw new RepositoryServiceFactoryException("Configured port (" + port + ") for H2 already in use.", (Throwable)e);
            }
        }
        finally {
            try {
                if (ss != null) {
                    ss.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Reported IO error, while closing ServerSocket used to test availability of port for H2 Server", (Throwable)ex);
            }
        }
    }

    private void startServer() throws RepositoryServiceFactoryException {
        SqlRepositoryConfiguration config = this.getSqlConfiguration();
        this.checkPort(config.getPort());
        try {
            this.server = Server.createTcpServer((String[])this.createArguments(config));
            this.server.start();
        }
        catch (Exception ex) {
            throw new RepositoryServiceFactoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    private String[] createArguments(SqlRepositoryConfiguration config) {
        ArrayList<String> args = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)config.getBaseDir())) {
            args.add("-baseDir");
            args.add(this.getRelativeBaseDirPath(config.getBaseDir()));
        }
        if (config.isTcpSSL()) {
            args.add("-tcpSSL");
        }
        if (config.getPort() > 0) {
            args.add("-tcpPort");
            args.add(Integer.toString(config.getPort()));
        }
        return args.toArray(new String[args.size()]);
    }

    private void dropDatabaseIfExists(SqlRepositoryConfiguration config) throws RepositoryServiceFactoryException {
        if (!config.isDropIfExists()) {
            return;
        }
        File file = new File(config.getBaseDir());
        final String fileName = config.getFileName();
        try {
            File lobDir;
            File dbFile = new File(file, String.valueOf(fileName) + ".h2.db");
            this.removeFile(dbFile);
            File lockFile = new File(file, String.valueOf(fileName) + ".lock.db");
            this.removeFile(lockFile);
            File traceFile = new File(file, String.valueOf(fileName) + ".trace.db");
            this.removeFile(traceFile);
            File[] tempFiles = file.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File parent, String name) {
                    return name.matches("^" + fileName + "\\.[0-9]*\\.temp\\.db$");
                }
            });
            if (tempFiles != null) {
                File[] fileArray = tempFiles;
                int n = tempFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File temp = fileArray[n2];
                    this.removeFile(temp);
                    ++n2;
                }
            }
            if ((lobDir = new File(file, String.valueOf(fileName) + ".lobs.db")).exists() && lobDir.isDirectory()) {
                LOGGER.info("Deleting directory '{}'", new Object[]{lobDir.getAbsolutePath()});
                FileUtils.deleteDirectory((File)lobDir);
            }
        }
        catch (Exception ex) {
            throw new RepositoryServiceFactoryException("Couldn't drop existing database files, reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private void removeFile(File file) throws IOException {
        if (file.exists()) {
            LOGGER.info("Deleting file '{}'", new Object[]{file.getAbsolutePath()});
            file.delete();
        }
    }
}

