/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql;

import com.evolveum.midpoint.repo.api.RepositoryServiceFactoryException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class SqlRepositoryConfiguration {
    private boolean embedded = true;
    private boolean asServer;
    private String baseDir;
    private String fileName;
    private boolean tcpSSL;
    private int port = 5437;
    private boolean dropIfExists;
    private String driverClassName;
    private String jdbcUrl;
    private String jdbcUsername;
    private String jdbcPassword;
    private String hibernateDialect;
    private String hibernateHbm2ddl;

    public SqlRepositoryConfiguration(Configuration configuration) {
        this.setAsServer(configuration.getBoolean("asServer", this.asServer));
        this.setBaseDir(configuration.getString("baseDir", this.baseDir));
        this.setDriverClassName(configuration.getString("driverClassName", this.driverClassName));
        this.setEmbedded(configuration.getBoolean("embedded", this.embedded));
        this.setHibernateDialect(configuration.getString("hibernateDialect", this.hibernateDialect));
        this.setHibernateHbm2ddl(configuration.getString("hibernateHbm2ddl", this.hibernateHbm2ddl));
        this.setJdbcPassword(configuration.getString("jdbcPassword", this.jdbcPassword));
        this.setJdbcUrl(configuration.getString("jdbcUrl", this.jdbcUrl));
        this.setJdbcUsername(configuration.getString("jdbcUsername", this.jdbcUsername));
        this.setPort(configuration.getInt("port", this.port));
        this.setTcpSSL(configuration.getBoolean("tcpSSL", this.tcpSSL));
        this.setFileName(configuration.getString("fileName", this.fileName));
        this.setDropIfExists(configuration.getBoolean("dropIfExists", this.dropIfExists));
    }

    public void validate() throws RepositoryServiceFactoryException {
        this.notEmpty(this.getJdbcUrl(), "JDBC Url is empty or not defined.");
        this.notEmpty(this.getJdbcUsername(), "JDBC user name is empty or not defined.");
        this.notNull(this.getJdbcPassword(), "JDBC password is not defined.");
        this.notEmpty(this.getDriverClassName(), "Driver class name is empty or not defined.");
        this.notEmpty(this.getHibernateDialect(), "Hibernate dialect is empty or not defined.");
        this.notEmpty(this.getHibernateHbm2ddl(), "Hibernate hbm2ddl option is empty or not defined.");
        if (this.isEmbedded()) {
            this.notEmpty(this.getBaseDir(), "Base dir is empty or not defined.");
            if (this.isAsServer() && (this.getPort() < 0 || this.getPort() > 65535)) {
                throw new RepositoryServiceFactoryException("Port must be in interval (0-65535)");
            }
        }
    }

    private void notNull(String value, String message) throws RepositoryServiceFactoryException {
        if (value == null) {
            throw new RepositoryServiceFactoryException(message);
        }
    }

    private void notEmpty(String value, String message) throws RepositoryServiceFactoryException {
        if (StringUtils.isEmpty((String)value)) {
            throw new RepositoryServiceFactoryException(message);
        }
    }

    public boolean isAsServer() {
        return this.asServer;
    }

    public void setAsServer(boolean asServer) {
        this.asServer = asServer;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public void setEmbedded(boolean embedded) {
        this.embedded = embedded;
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public String getHibernateHbm2ddl() {
        return this.hibernateHbm2ddl;
    }

    public void setHibernateHbm2ddl(String hibernateHbm2ddl) {
        this.hibernateHbm2ddl = hibernateHbm2ddl;
    }

    public String getJdbcPassword() {
        return this.jdbcPassword;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcUsername() {
        return this.jdbcUsername;
    }

    public void setJdbcUsername(String jdbcUsername) {
        this.jdbcUsername = jdbcUsername;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isTcpSSL() {
        return this.tcpSSL;
    }

    public void setTcpSSL(boolean tcpSSL) {
        this.tcpSSL = tcpSSL;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isDropIfExists() {
        return this.dropIfExists;
    }

    public void setDropIfExists(boolean dropIfExists) {
        this.dropIfExists = dropIfExists;
    }
}

