/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openicf.csvfile;

import java.io.File;
import java.nio.charset.Charset;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;

public class CSVFileConfiguration
extends AbstractConfiguration {
    private static final Log log = Log.getLog(CSVFileConfiguration.class);
    private File filePath = null;
    private String encoding = "utf-8";
    private String valueQualifier = "\"";
    private String fieldDelimiter = ",";
    private String multivalueDelimiter = ";";
    private boolean usingMultivalue = false;
    private String uniqueAttribute = null;
    private String nameAttribute = null;
    private String passwordAttribute = null;

    @ConfigurationProperty(displayMessageKey="UI_FLAT_ENCODING", helpMessageKey="UI_FLAT_ENCODING_HELP")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_FIELD_DELIMITER", helpMessageKey="UI_FLAT_FIELD_DELIMITER_HELP")
    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(String fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_FILE_PATH", helpMessageKey="UI_FLAT_FILE_PATH_HELP", required=true)
    public File getFilePath() {
        return this.filePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_MULTIVALUE_DELIMITER", helpMessageKey="UI_FLAT_MULTIVALUE_DELIMITER_HELP")
    public String getMultivalueDelimiter() {
        return this.multivalueDelimiter;
    }

    public void setMultivalueDelimiter(String multivalueDelimiter) {
        this.multivalueDelimiter = multivalueDelimiter;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_PASSWORD_ATTRIBUTE", helpMessageKey="UI_FLAT_PASSWORD_ATTRIBUTE_HELP")
    public String getPasswordAttribute() {
        return this.passwordAttribute;
    }

    public void setPasswordAttribute(String passwordAttribute) {
        this.passwordAttribute = passwordAttribute;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_UNIQUE_ATTRIBUTE", helpMessageKey="UI_FLAT_UNIQUE_ATTRIBUTE_HELP", required=true)
    public String getUniqueAttribute() {
        return this.uniqueAttribute;
    }

    public void setUniqueAttribute(String uniqueAttribute) {
        this.uniqueAttribute = uniqueAttribute;
        if (StringUtil.isEmpty((String)this.nameAttribute)) {
            this.nameAttribute = uniqueAttribute;
        }
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_VALUE_QUALIFIER", helpMessageKey="UI_FLAT_VALUE_QUALIFIER_HELP")
    public String getValueQualifier() {
        return this.valueQualifier;
    }

    public void setValueQualifier(String valueQualifier) {
        this.valueQualifier = valueQualifier;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_USING_MULTIVALUE", helpMessageKey="UI_FLAT_USING_MULTIVALUE_HELP")
    public boolean isUsingMultivalue() {
        return this.usingMultivalue;
    }

    public void setUsingMultivalue(boolean usingMultivalue) {
        this.usingMultivalue = usingMultivalue;
    }

    @ConfigurationProperty(displayMessageKey="UI_FLAT_NAME_ATTRIBUTE", helpMessageKey="UI_FLAT_NAME_ATTRIBUTE_HELP", required=true)
    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }

    public void validate() {
        log.info("begin", new Object[0]);
        if (StringUtil.isEmpty((String)this.encoding)) {
            throw new ConfigurationException("Encoding is not defined.");
        }
        if (!Charset.isSupported(this.encoding)) {
            throw new ConfigurationException("Encoding '" + this.encoding + "' is not supported.");
        }
        if (StringUtil.isEmpty((String)this.fieldDelimiter)) {
            throw new ConfigurationException("Field delimiter can't be null or empty.");
        }
        if (StringUtil.isEmpty((String)this.valueQualifier)) {
            throw new ConfigurationException("Value qualifier can't be null or empty.");
        }
        if (StringUtil.isEmpty((String)this.multivalueDelimiter)) {
            throw new ConfigurationException("Multivalue delimiter delimiter can't be null or empty.");
        }
        if (this.fieldDelimiter.equals(this.valueQualifier)) {
            throw new ConfigurationException("Field delimiter '" + this.fieldDelimiter + "' can't be equal to value qualifier.");
        }
        if (StringUtil.isEmpty((String)this.uniqueAttribute)) {
            throw new ConfigurationException("Unique attribute is not defined.");
        }
        if (StringUtil.isEmpty((String)this.nameAttribute)) {
            log.warn("Name attribute not defined, value from unique attribute will be used (" + this.uniqueAttribute + ").", new Object[0]);
            this.nameAttribute = this.uniqueAttribute;
        }
        if (StringUtil.isEmpty((String)this.passwordAttribute)) {
            log.warn("Password attribute is not defined.", new Object[0]);
        }
        Assertions.nullCheck((Object)this.filePath, (String)"File path");
        if (!this.filePath.exists()) {
            throw new ConfigurationException("File '" + this.filePath + "' doesn't exists. At least file with csv header must exist.");
        }
        if (this.filePath.isDirectory()) {
            throw new ConfigurationException("File path '" + this.filePath + "' points to a directory.");
        }
        if (!this.filePath.canRead()) {
            throw new ConfigurationException("File '" + this.filePath + "' can't be read.");
        }
        if (!this.filePath.canWrite()) {
            throw new ConfigurationException("Can't write to file '" + this.filePath.getAbsolutePath() + "'.");
        }
        log.info("end", new Object[0]);
    }

    boolean isUniqueAndNameAttributeEqual() {
        return this.uniqueAttribute == null ? this.nameAttribute == null : this.uniqueAttribute.equals(this.nameAttribute);
    }
}

