/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class ShadowConstraintsChecker {
    private static final Trace LOGGER = TraceManager.getTrace(ShadowConstraintsChecker.class);
    private AccountSyncContext accountContext;
    private PrismContext prismContext;
    private RepositoryService repositoryService;
    private boolean satisfiesConstraints;
    private StringBuilder messageBuilder = new StringBuilder();

    public ShadowConstraintsChecker(AccountSyncContext accountContext) {
        this.accountContext = accountContext;
    }

    public AccountSyncContext getAccountContext() {
        return this.accountContext;
    }

    public void setAccountContext(AccountSyncContext accountContext) {
        this.accountContext = accountContext;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public boolean isSatisfiesConstraints() {
        return this.satisfiesConstraints;
    }

    public String getMessages() {
        return this.messageBuilder.toString();
    }

    public void check(OperationResult result) throws SchemaException, ObjectAlreadyExistsException {
        RefinedAccountDefinition accountDefinition = this.accountContext.getRefinedAccountDefinition();
        PrismObject<AccountShadowType> accountNew = this.accountContext.getAccountNew();
        if (accountNew == null) {
            this.satisfiesConstraints = true;
            return;
        }
        PrismContainer attributesContainer = accountNew.findContainer(AccountShadowType.F_ATTRIBUTES);
        if (attributesContainer == null) {
            this.satisfiesConstraints = true;
            return;
        }
        Collection uniqueAttributeDefs = MiscUtil.union((Collection[])new Collection[]{accountDefinition.getIdentifiers(), accountDefinition.getSecondaryIdentifiers()});
        LOGGER.trace("Secondary IDs {}", (Object)accountDefinition.getSecondaryIdentifiers());
        for (ResourceAttributeDefinition attrDef : uniqueAttributeDefs) {
            boolean unique;
            PrismProperty attr = attributesContainer.findProperty(attrDef.getName());
            LOGGER.trace("Attempt to check uniquness of {} (def {})", (Object)attr, (Object)attrDef);
            if (attr == null || (unique = this.checkAttributeUniqueness(attr, accountDefinition, this.accountContext.getResource(), this.accountContext.getOid(), result))) continue;
            LOGGER.debug("Attribute {} conflicts with existing object (in {})", (Object)attr, (Object)this.accountContext.getResourceAccountType());
            if (this.isInDelta(attr, this.accountContext.getAccountPrimaryDelta())) {
                throw new ObjectAlreadyExistsException("Attribute " + attr + " conflicts with existing object (and it is present in primary " + "account delta therefore no iteration is performed)");
            }
            this.satisfiesConstraints = false;
            return;
        }
        this.satisfiesConstraints = true;
    }

    private boolean checkAttributeUniqueness(PrismProperty<?> identifier, RefinedAccountDefinition accountDefinition, ResourceType resourceType, String oid, OperationResult result) throws SchemaException {
        QueryType query = QueryUtil.createAttributeQuery(identifier, (QName)accountDefinition.getObjectClassDefinition().getTypeName(), (ResourceType)resourceType, (PrismContext)this.prismContext);
        List foundObjects = this.repositoryService.searchObjects(AccountShadowType.class, query, null, result);
        LOGGER.trace("Uniquness check of {} resulted in {} results, using query:\n{}", new Object[]{identifier, foundObjects.size(), DOMUtil.serializeDOMToString((Node)query.getFilter())});
        if (foundObjects.isEmpty()) {
            return true;
        }
        if (foundObjects.size() > 1) {
            this.message("Found more than one object with attribute " + identifier.getHumanReadableDump());
            return false;
        }
        LOGGER.trace("Comparing {} and {}", (Object)((PrismObject)foundObjects.get(0)).getOid(), (Object)oid);
        boolean match = ((PrismObject)foundObjects.get(0)).getOid().equals(oid);
        if (!match) {
            this.message("Found conflicting existing object with attribute " + identifier.getHumanReadableDump() + ": " + foundObjects.get(0));
        }
        return match;
    }

    private boolean isInDelta(PrismProperty<?> attr, ObjectDelta<AccountShadowType> delta) {
        if (delta == null) {
            return false;
        }
        return delta.hasItemDelta(new PropertyPath(new QName[]{ResourceObjectShadowType.F_ATTRIBUTES, attr.getName()}));
    }

    private void message(String message) {
        if (this.messageBuilder.length() != 0) {
            this.messageBuilder.append(", ");
        }
        this.messageBuilder.append(message);
    }
}

