/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedAttributeDefinition;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.model.synchronizer.AccountConstruction;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.constants.ExpressionConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutboundProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(OutboundProcessor.class);
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;

    void processOutbound(SyncContext context, AccountSyncContext accCtx, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        ResourceAccountType rat = accCtx.getResourceAccountType();
        ObjectDelta<AccountShadowType> accountDelta = accCtx.getAccountDelta();
        if (accountDelta != null && accountDelta.getChangeType() == ChangeType.DELETE) {
            LOGGER.trace("Processing outbound expressions for account {} skipped, DELETE account delta", (Object)rat);
            return;
        }
        LOGGER.trace("Processing outbound expressions for account {} starting", (Object)rat);
        RefinedAccountDefinition rAccount = context.getRefinedAccountDefinition(rat);
        if (rAccount == null) {
            LOGGER.error("Definition for account type {} not found in the context, but it should be there, dumping context:\n{}", (Object)rat, (Object)context.dump());
            throw new IllegalStateException("Definition for account type " + rat + " not found in the context, but it should be there");
        }
        ObjectDeltaObject<UserType> userOdo = context.getUserObjectDeltaObject();
        AccountConstruction outboundAccountConstruction = new AccountConstruction(null, (ObjectType)accCtx.getResource());
        for (QName attributeName : rAccount.getNamesOfAttributesWithOutboundExpressions()) {
            RefinedAttributeDefinition refinedAttributeDefinition = rAccount.getAttributeDefinition(attributeName);
            ValueConstructionType outboundValueConstructionType = refinedAttributeDefinition.getOutboundValueConstructionType();
            if (outboundValueConstructionType == null) continue;
            ValueConstruction valueConstruction = this.valueConstructionFactory.createValueConstruction(outboundValueConstructionType, (ItemDefinition)refinedAttributeDefinition, "outbound expression for " + DebugUtil.prettyPrint((QName)refinedAttributeDefinition.getName()) + " in " + ObjectTypeUtil.toShortString((ObjectType)rAccount.getResourceType()));
            valueConstruction.addVariableDefinition(ExpressionConstants.VAR_USER, userOdo);
            valueConstruction.addVariableDefinition(ExpressionConstants.VAR_ITERATION, accCtx.getIteration());
            valueConstruction.addVariableDefinition(ExpressionConstants.VAR_ITERATION_TOKEN, accCtx.getIterationToken());
            valueConstruction.setRootNode(userOdo);
            if (userOdo.getOldObject() == null) {
                valueConstruction.setConditionMaskOld(false);
            }
            if (userOdo.getNewObject() == null) {
                valueConstruction.setConditionMaskNew(false);
            }
            valueConstruction.evaluate(result);
            outboundAccountConstruction.addAttributeConstruction(valueConstruction);
        }
        accCtx.setOutboundAccountConstruction(outboundAccountConstruction);
    }
}

