/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceCredentialsDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourcePasswordDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CredentialsProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(CredentialsProcessor.class);
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;

    public void processCredentials(SyncContext context, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        PrismObject<UserType> userNew;
        ObjectDelta<UserType> userDelta = context.getUserDelta();
        PropertyDelta passwordValueDelta = null;
        if (userDelta != null) {
            passwordValueDelta = userDelta.findPropertyDelta(SchemaConstants.PATH_PASSWORD_VALUE);
            if (userDelta.getChangeType() == ChangeType.MODIFY && passwordValueDelta != null && (passwordValueDelta.isAdd() || passwordValueDelta.isDelete())) {
                throw new SchemaException("User password value cannot be added or deleted, it can only be replaced");
            }
        }
        if ((userNew = context.getUserNew()) == null) {
            LOGGER.trace("userNew is null, skipping credentials processing");
            return;
        }
        PrismProperty userPasswordNew = context.getUserNew().findProperty(SchemaConstants.PATH_PASSWORD_VALUE);
        PrismObjectDefinition accountDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(AccountShadowType.class);
        PrismPropertyDefinition accountPasswordPropertyDefinition = accountDefinition.findPropertyDefinition(SchemaConstants.PATH_PASSWORD_VALUE);
        for (AccountSyncContext accCtx : context.getAccountContexts()) {
            PropertyDelta accountPasswordDelta;
            ResourceAccountType rat = accCtx.getResourceAccountType();
            ObjectDelta<AccountShadowType> accountDelta = accCtx.getAccountDelta();
            if (accountDelta != null && accountDelta.getChangeType() == ChangeType.MODIFY && (accountPasswordDelta = accountDelta.findPropertyDelta(SchemaConstants.PATH_PASSWORD_VALUE)) != null && (accountPasswordDelta.isAdd() || accountDelta.isDelete())) {
                throw new SchemaException("Password for account " + rat + " cannot be added or deleted, it can only be replaced");
            }
            if ((accountDelta == null || accountDelta.getChangeType() != ChangeType.ADD) && passwordValueDelta == null) {
                LOGGER.trace("No change in password and the account is not added, skipping credentials processing for account " + rat);
                continue;
            }
            ResourceAccountTypeDefinitionType resourceAccountDefType = accCtx.getResourceAccountTypeDefinitionType();
            if (resourceAccountDefType == null) {
                LOGGER.trace("No ResourceAccountTypeDefinition, therefore also no password outbound definition, skipping credentials processing for account " + rat);
                continue;
            }
            ResourceCredentialsDefinitionType credentialsType = resourceAccountDefType.getCredentials();
            if (credentialsType == null) {
                LOGGER.trace("No credentials definition in account type {}, skipping credentials processing", (Object)rat);
                continue;
            }
            ResourcePasswordDefinitionType passwordType = credentialsType.getPassword();
            if (passwordType == null) {
                LOGGER.trace("No password definition in credentials in account type {}, skipping credentials processing", (Object)rat);
                continue;
            }
            ValueConstructionType outbound = passwordType.getOutbound();
            if (outbound == null) {
                LOGGER.trace("No outbound definition in password definition in credentials in account type {}, skipping credentials processing", (Object)rat);
                continue;
            }
            ValueConstruction passwordConstruction = this.valueConstructionFactory.createValueConstruction(outbound, (ItemDefinition)accountPasswordPropertyDefinition, "outbound password in account type " + rat);
            passwordConstruction.setInput((Item)userPasswordNew);
            passwordConstruction.evaluate(result);
            PrismProperty accountPasswordNew = (PrismProperty)passwordConstruction.getOutput();
            if (accountPasswordNew == null) {
                LOGGER.trace("Credentials 'password' expression resulted in null, skipping credentials processing for {}", (Object)rat);
                continue;
            }
            PropertyDelta accountPasswordDelta2 = new PropertyDelta(SchemaConstants.PATH_PASSWORD_VALUE, accountPasswordPropertyDefinition);
            accountPasswordDelta2.setValuesToReplace(accountPasswordNew.getClonedValues());
            LOGGER.trace("Adding new password delta for account {}", (Object)rat);
            accCtx.addToSecondaryDelta(accountPasswordDelta2);
        }
    }
}

