/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.synchronizer.AssignmentPath;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.schema.constants.ExpressionConstants;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;

public class AccountConstruction
implements DebugDumpable,
Dumpable {
    private AssignmentPath assignmentPath;
    private AccountConstructionType accountConstructionType;
    private ObjectType source;
    private ObjectDeltaObject<UserType> userOdo;
    private ResourceType resource;
    private ObjectResolver objectResolver;
    private ValueConstructionFactory valueConstructionFactory;
    private Collection<ValueConstruction<? extends PrismPropertyValue<?>>> attributeConstructions;
    private RefinedAccountDefinition refinedAccountDefinition;
    private PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(AccountConstruction.class);

    public AccountConstruction(AccountConstructionType accountConstructionType, ObjectType source) {
        this.accountConstructionType = accountConstructionType;
        this.source = source;
        this.assignmentPath = null;
        this.attributeConstructions = null;
    }

    public void setSource(ObjectType source) {
        this.source = source;
    }

    public void setUserOdo(ObjectDeltaObject<UserType> userOdo) {
        this.userOdo = userOdo;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    PrismContext getPrismContext() {
        return this.prismContext;
    }

    void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public ValueConstructionFactory getValueConstructionFactory() {
        return this.valueConstructionFactory;
    }

    public void setValueConstructionFactory(ValueConstructionFactory valueConstructionFactory) {
        this.valueConstructionFactory = valueConstructionFactory;
    }

    public String getAccountType() {
        if (this.refinedAccountDefinition == null) {
            throw new IllegalStateException("Account type can only be fetched from evaluated AccountConstruction");
        }
        return this.refinedAccountDefinition.getAccountTypeName();
    }

    public Object getDescription() {
        return this.accountConstructionType.getDescription();
    }

    public Collection<ValueConstruction<? extends PrismPropertyValue<?>>> getAttributeConstructions() {
        if (this.attributeConstructions == null) {
            this.attributeConstructions = new ArrayList();
        }
        return this.attributeConstructions;
    }

    public ValueConstruction<? extends PrismPropertyValue<?>> getAttributeConstruction(QName attrName) {
        for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : this.getAttributeConstructions()) {
            if (!valueConstruction.getItemName().equals(attrName)) continue;
            return valueConstruction;
        }
        return null;
    }

    public void addAttributeConstruction(ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction) {
        this.getAttributeConstructions().add(valueConstruction);
    }

    public boolean containsAttributeConstruction(QName attributeName) {
        for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : this.getAttributeConstructions()) {
            if (!attributeName.equals(valueConstruction.getItemName())) continue;
            return true;
        }
        return false;
    }

    public AssignmentPath getAssignmentPath() {
        return this.assignmentPath;
    }

    public void setAssignmentPath(AssignmentPath assignmentPath) {
        this.assignmentPath = assignmentPath;
    }

    public ResourceType getResource(OperationResult result) throws ObjectNotFoundException, SchemaException {
        if (this.resource == null) {
            if (this.accountConstructionType.getResource() != null) {
                this.resource = this.accountConstructionType.getResource();
            } else if (this.accountConstructionType.getResourceRef() != null) {
                try {
                    this.resource = (ResourceType)this.objectResolver.resolve(this.accountConstructionType.getResourceRef(), ResourceType.class, "account construction in " + this.source, result);
                }
                catch (ObjectNotFoundException e) {
                    throw new ObjectNotFoundException("Resource reference seems to be invalid in account construction in " + this.source + ": " + e.getMessage(), (Throwable)e);
                }
            }
            if (this.resource == null) {
                throw new SchemaException("No resource set in account construction in " + this.source);
            }
        }
        return this.resource;
    }

    public void evaluate(OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        this.evaluateAccountType(result);
        this.evaluateAttributes(result);
    }

    private void evaluateAccountType(OperationResult result) throws SchemaException, ObjectNotFoundException {
        String resourceOid = null;
        if (this.accountConstructionType.getResourceRef() != null) {
            resourceOid = this.accountConstructionType.getResourceRef().getOid();
        }
        if (this.accountConstructionType.getResource() != null) {
            resourceOid = this.accountConstructionType.getResource().getOid();
        }
        if (!this.getResource(result).getOid().equals(resourceOid)) {
            throw new IllegalStateException("The specified resource and the resource in construction does not match");
        }
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)this.getResource(result), (PrismContext)this.prismContext);
        this.refinedAccountDefinition = refinedSchema.getAccountDefinition(this.accountConstructionType.getType());
        if (this.refinedAccountDefinition == null) {
            if (this.accountConstructionType.getType() != null) {
                throw new SchemaException("No account type '" + this.accountConstructionType.getType() + "' found in " + ObjectTypeUtil.toShortString((ObjectType)this.getResource(result)) + " as specified in account construction in " + ObjectTypeUtil.toShortString((ObjectType)this.source));
            }
            throw new SchemaException("No default account type found in " + ObjectTypeUtil.toShortString((ObjectType)this.getResource(result)) + " as specified in account construction in " + ObjectTypeUtil.toShortString((ObjectType)this.source));
        }
    }

    private void evaluateAttributes(OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        this.attributeConstructions = new ArrayList();
        for (ValueConstructionType attributeConstructionType : this.accountConstructionType.getAttribute()) {
            ValueConstruction<? extends PrismPropertyValue<?>> attributeConstruction = this.evaluateAttribute(attributeConstructionType, result);
            this.attributeConstructions.add(attributeConstruction);
        }
    }

    private ValueConstruction<? extends PrismPropertyValue<?>> evaluateAttribute(ValueConstructionType attributeConstructionType, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        QName attrName = attributeConstructionType.getRef();
        if (attrName == null) {
            throw new SchemaException("Missing 'ref' in attribute construction in account construction in " + ObjectTypeUtil.toShortString((ObjectType)this.source));
        }
        ResourceAttributeDefinition outputDefinition = this.findAttributeDefinition(attrName);
        if (outputDefinition == null) {
            throw new SchemaException("Attribute " + attrName + " not found in schema for account type " + this.getAccountType() + ", " + ObjectTypeUtil.toShortString((ObjectType)this.getResource(result)) + " as definied in " + ObjectTypeUtil.toShortString((ObjectType)this.source), attrName);
        }
        ValueConstruction attributeConstruction = this.valueConstructionFactory.createValueConstruction(attributeConstructionType, (ItemDefinition)outputDefinition, "for attribute " + DebugUtil.prettyPrint((QName)attrName) + " in " + this.source);
        attributeConstruction.addVariableDefinition(ExpressionConstants.VAR_USER, this.userOdo);
        attributeConstruction.setRootNode(this.userOdo);
        if (!this.assignmentPath.isEmpty()) {
            AssignmentType assignmentType = this.assignmentPath.getFirstAssignment();
            attributeConstruction.addVariableDefinition(ExpressionConstants.VAR_ASSIGNMENT, (PrismValue)assignmentType.asPrismContainerValue());
        }
        if (this.userOdo.getOldObject() == null) {
            attributeConstruction.setConditionMaskOld(false);
        }
        if (this.userOdo.getNewObject() == null) {
            attributeConstruction.setConditionMaskNew(false);
        }
        attributeConstruction.evaluate(result);
        LOGGER.trace("Evaluated construction for " + attrName + ": " + attributeConstruction);
        return attributeConstruction;
    }

    private ResourceAttributeDefinition findAttributeDefinition(QName attributeName) {
        return this.refinedAccountDefinition.getObjectClassDefinition().findAttributeDefinition(attributeName);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.assignmentPath == null ? 0 : this.assignmentPath.hashCode());
        result = 31 * result + (this.attributeConstructions == null ? 0 : this.attributeConstructions.hashCode());
        result = 31 * result + (this.refinedAccountDefinition == null ? 0 : this.refinedAccountDefinition.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccountConstruction other = (AccountConstruction)obj;
        if (this.assignmentPath == null ? other.assignmentPath != null : !this.assignmentPath.equals(other.assignmentPath)) {
            return false;
        }
        if (this.attributeConstructions == null ? other.attributeConstructions != null : !this.attributeConstructions.equals(other.attributeConstructions)) {
            return false;
        }
        if (this.refinedAccountDefinition == null ? other.refinedAccountDefinition != null : !this.refinedAccountDefinition.equals((Object)other.refinedAccountDefinition)) {
            return false;
        }
        if (this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource)) {
            return false;
        }
        return !(this.source == null ? other.source != null : !this.source.equals((Object)other.source));
    }

    public String dump() {
        return this.debugDump();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    /*
     * WARNING - void declaration
     */
    public String debugDump(int indent) {
        void var3_4;
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        while (var3_4 < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++var3_4;
        }
        sb.append("AccountConstruction(");
        if (this.refinedAccountDefinition == null) {
            sb.append("null");
        } else {
            sb.append(this.refinedAccountDefinition.getResourceAccountType());
        }
        sb.append(")");
        if (this.attributeConstructions != null) {
            for (ValueConstruction<? extends PrismPropertyValue<?>> valueConstruction : this.attributeConstructions) {
                sb.append("\n");
                sb.append(valueConstruction.debugDump(indent + 1));
            }
        }
        return sb.toString();
    }

    public String toString() {
        return "AccountConstruction(" + this.attributeConstructions + ")";
    }
}

