/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.audit.api.AuditEventRecord;
import com.evolveum.midpoint.audit.api.AuditEventStage;
import com.evolveum.midpoint.audit.api.AuditEventType;
import com.evolveum.midpoint.audit.api.AuditService;
import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.model.expr.ExpressionHandler;
import com.evolveum.midpoint.model.sync.Action;
import com.evolveum.midpoint.model.sync.ActionManager;
import com.evolveum.midpoint.model.sync.SynchronizationException;
import com.evolveum.midpoint.model.sync.SynchronizationService$AjcClosure1;
import com.evolveum.midpoint.model.sync.SynchronizationService$AjcClosure3;
import com.evolveum.midpoint.model.sync.SynchronizationSituation;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExpressionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectSynchronizationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SynchronizationSituationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service(value="synchronizationService")
public class SynchronizationService
implements ResourceObjectChangeListener {
    private static final Trace LOGGER;
    @Autowired(required=true)
    private ModelController controller;
    @Autowired(required=true)
    private ActionManager<Action> actionManager;
    @Autowired
    private ExpressionHandler expressionHandler;
    @Autowired
    private ChangeNotificationDispatcher notificationManager;
    @Autowired(required=true)
    private AuditService auditService;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private RepositoryService repositoryService;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        SynchronizationService.ajc$preClinit();
        LOGGER = TraceManager.getTrace(SynchronizationService.class);
    }

    @PostConstruct
    public void registerForResourceObjectChangeNotifications() {
        this.notificationManager.registerNotificationListener((ResourceObjectChangeListener)this);
    }

    @PreDestroy
    public void unregisterForResourceObjectChangeNotifications() {
        this.notificationManager.unregisterNotificationListener((ResourceObjectChangeListener)this);
    }

    public void notifyChange(ResourceObjectShadowChangeDescription change, Task task, OperationResult parentResult) {
        ResourceObjectShadowChangeDescription resourceObjectShadowChangeDescription = change;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{resourceObjectShadowChangeDescription, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, resourceObjectShadowChangeDescription, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processResourceObjectChangeListenerNdc(new SynchronizationService$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private boolean isSynchronizationEnabled(ObjectSynchronizationType synchronization) {
        if (synchronization == null || synchronization.isEnabled() == null) {
            return false;
        }
        return synchronization.isEnabled();
    }

    private SynchronizationSituation checkSituation(ResourceObjectShadowChangeDescription change, OperationResult result) {
        OperationResult subResult = result.createSubresult(ResourceObjectChangeListener.CHECK_SITUATION);
        LOGGER.trace("Determining situation for resource object shadow.");
        SynchronizationSituation situation = null;
        try {
            try {
                String shadowOid = this.getOidFromChange(change);
                Validate.notEmpty((String)shadowOid, (String)"Couldn't get resource object shadow oid from change.");
                PrismObject user = this.repositoryService.listAccountShadowOwner(shadowOid, subResult);
                if (user != null) {
                    UserType userType = (UserType)user.asObjectable();
                    LOGGER.trace("Shadow OID {} does have owner: {}", (Object)shadowOid, (Object)userType.getName());
                    SynchronizationSituationType state = null;
                    switch (this.getModificationType(change)) {
                        case ADD: 
                        case MODIFY: {
                            state = SynchronizationSituationType.LINKED;
                            break;
                        }
                        case DELETE: {
                            state = SynchronizationSituationType.DELETED;
                        }
                    }
                    situation = new SynchronizationSituation(userType, state);
                } else {
                    LOGGER.trace("Resource object shadow doesn't have owner.");
                    situation = this.checkSituationWithCorrelation(change, result);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error occurred during resource object shadow owner lookup.");
                throw new SystemException("Error occurred during resource object shadow owner lookup, reason: " + ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            subResult.computeStatus();
        }
        LOGGER.trace("checkSituation::end - {}, {}", new Object[]{situation.getUser() == null ? "null" : situation.getUser().getOid(), situation.getSituation()});
        return situation;
    }

    private String getOidFromChange(ResourceObjectShadowChangeDescription change) {
        if (change.getCurrentShadow() != null && StringUtils.isNotEmpty((String)change.getCurrentShadow().getOid())) {
            return change.getCurrentShadow().getOid();
        }
        if (change.getOldShadow() != null && StringUtils.isNotEmpty((String)change.getOldShadow().getOid())) {
            return change.getOldShadow().getOid();
        }
        if (change.getObjectDelta() == null || StringUtils.isEmpty((String)change.getObjectDelta().getOid())) {
            throw new IllegalArgumentException("Oid was not defined in change (not in current, old shadow, delta).");
        }
        return change.getObjectDelta().getOid();
    }

    private SynchronizationSituation checkSituationWithCorrelation(ResourceObjectShadowChangeDescription change, OperationResult result) throws SynchronizationException, SchemaException {
        if (ChangeType.DELETE.equals((Object)this.getModificationType(change))) {
            return new SynchronizationSituation(null, SynchronizationSituationType.DELETED);
        }
        PrismObject resourceShadow = change.getCurrentShadow();
        ObjectDelta syncDelta = change.getObjectDelta();
        if (resourceShadow == null && syncDelta != null && ChangeType.ADD.equals((Object)syncDelta.getChangeType())) {
            PrismObject shadow;
            LOGGER.trace("Trying to compute current shadow from change delta add.");
            resourceShadow = shadow = syncDelta.computeChangedObject(syncDelta.getObjectToAdd());
            change.setCurrentShadow(shadow);
        }
        Validate.notNull((Object)resourceShadow, (String)"Current shadow must not be null.");
        ResourceType resource = (ResourceType)change.getResource().asObjectable();
        this.validateResourceInShadow((ResourceObjectShadowType)resourceShadow.asObjectable(), resource);
        ObjectSynchronizationType synchronization = ResourceTypeUtil.determineSynchronization((ResourceType)resource, UserType.class);
        SynchronizationSituationType state = null;
        LOGGER.trace("SYNCHRONIZATION: CORRELATION: Looking for list of users based on correlation rule.");
        List<PrismObject<UserType>> users = this.findUsersByCorrelationRule((ResourceObjectShadowType)resourceShadow.asObjectable(), synchronization.getCorrelation(), resource, result);
        if (users == null) {
            users = new ArrayList<PrismObject<UserType>>();
        }
        if (users.size() > 1) {
            if (synchronization.getConfirmation() == null) {
                LOGGER.trace("SYNCHRONIZATION: CONFIRMATION: no confirmation defined.");
            } else {
                LOGGER.debug("SYNCHRONIZATION: CONFIRMATION: Checking users from correlation with confirmation rule.");
                users = this.findUserByConfirmationRule(users, (ResourceObjectShadowType)resourceShadow.asObjectable(), synchronization.getConfirmation(), result);
            }
        }
        UserType user = null;
        switch (users.size()) {
            case 0: {
                state = SynchronizationSituationType.UNMATCHED;
                break;
            }
            case 1: {
                switch (this.getModificationType(change)) {
                    case ADD: 
                    case MODIFY: {
                        state = SynchronizationSituationType.UNLINKED;
                        break;
                    }
                    case DELETE: {
                        state = SynchronizationSituationType.DELETED;
                    }
                }
                user = (UserType)users.get(0).asObjectable();
                break;
            }
            default: {
                state = SynchronizationSituationType.DISPUTED;
            }
        }
        return new SynchronizationSituation(user, state);
    }

    private void validateResourceInShadow(ResourceObjectShadowType shadow, ResourceType resource) {
        if (shadow.getResource() != null || shadow.getResourceRef() != null) {
            return;
        }
        ObjectReferenceType reference = new ObjectReferenceType();
        reference.setOid(resource.getOid());
        reference.setType(ObjectTypes.RESOURCE.getTypeQName());
        shadow.setResourceRef(reference);
    }

    private ChangeType getModificationType(ResourceObjectShadowChangeDescription change) {
        if (change.getObjectDelta() != null) {
            return change.getObjectDelta().getChangeType();
        }
        return ChangeType.ADD;
    }

    private void notifyChange(ResourceObjectShadowChangeDescription change, SynchronizationSituation situation, ResourceType resource, Task task, OperationResult parentResult) {
        AuditEventRecord auditRecord = new AuditEventRecord(AuditEventType.SYNCHRONIZATION, AuditEventStage.REQUEST);
        if (change.getObjectDelta() != null) {
            auditRecord.addDelta(change.getObjectDelta());
        }
        if (change.getCurrentShadow() != null) {
            auditRecord.setTarget(change.getCurrentShadow());
        } else if (change.getOldShadow() != null) {
            auditRecord.setTarget(change.getOldShadow());
        }
        auditRecord.setChannel(change.getSourceChannel());
        this.auditService.audit(auditRecord, task);
        ObjectSynchronizationType synchronization = ResourceTypeUtil.determineSynchronization((ResourceType)resource, UserType.class);
        List<Action> actions = this.findActionsForReaction(synchronization.getReaction(), situation.getSituation());
        if (actions.isEmpty()) {
            LOGGER.warn("Skipping synchronization on resource: {}. Actions was not found.", new Object[]{resource.getName()});
            return;
        }
        try {
            LOGGER.trace("Updating user started.");
            String userOid = situation.getUser() == null ? null : situation.getUser().getOid();
            for (Action action : actions) {
                LOGGER.debug("SYNCHRONIZATION: ACTION: Executing: {}.", new Object[]{action.getClass()});
                userOid = action.executeChanges(userOid, change, situation.getSituation(), auditRecord, task, parentResult);
            }
            parentResult.recordSuccess();
            LOGGER.trace("Updating user finished.");
        }
        catch (SynchronizationException ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"### SYNCHRONIZATION # notifyChange(..): Synchronization action failed", (Throwable)ex, (Object[])new Object[0]);
            parentResult.recordFatalError("Synchronization action failed.", (Throwable)ex);
            throw new SystemException("Synchronization action failed, reason: " + ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"### SYNCHRONIZATION # notifyChange(..): Unexpected error occurred, synchronization action failed", (Throwable)ex, (Object[])new Object[0]);
            parentResult.recordFatalError("Unexpected error occurred, synchronization action failed.", (Throwable)ex);
            throw new SystemException("Unexpected error occurred, synchronization action failed, reason: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private List<Action> findActionsForReaction(List<ObjectSynchronizationType.Reaction> reactions, SynchronizationSituationType situation) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (reactions == null) {
            return actions;
        }
        ObjectSynchronizationType.Reaction reaction = null;
        for (ObjectSynchronizationType.Reaction react : reactions) {
            if (react.getSituation() == null) {
                LOGGER.warn("Reaction ({}) doesn't contain situation element, skipping.", (Object)reactions.indexOf(react));
                continue;
            }
            if (!situation.equals((Object)react.getSituation())) continue;
            reaction = react;
            break;
        }
        if (reaction == null) {
            LOGGER.warn("Reaction on situation {} was not found.", (Object)situation);
            return actions;
        }
        List actionList = reaction.getAction();
        for (ObjectSynchronizationType.Reaction.Action actionXml : actionList) {
            if (actionXml == null) {
                LOGGER.warn("Reaction ({}) doesn't contain action element, skipping.", (Object)reactions.indexOf(reaction));
                return actions;
            }
            if (actionXml.getRef() == null) {
                LOGGER.warn("Reaction ({}): Action element doesn't contain ref attribute, skipping.", (Object)reactions.indexOf(reaction));
                return actions;
            }
            Action action = this.actionManager.getActionInstance(actionXml.getRef());
            if (action == null) {
                LOGGER.warn("Couldn't create action with uri '{}' for reaction {}, skipping action.", new Object[]{actionXml.getRef(), reactions.indexOf(reaction)});
                continue;
            }
            action.setParameters(actionXml.getAny());
            actions.add(action);
        }
        return actions;
    }

    private List<PrismObject<UserType>> findUsersByCorrelationRule(ResourceObjectShadowType currentShadow, QueryType query, ResourceType resourceType, OperationResult result) throws SynchronizationException {
        if (query == null) {
            LOGGER.warn("Correlation rule for resource '{}' doesn't contain query, returning empty list of users.", (Object)resourceType);
            return null;
        }
        Element element = query.getFilter();
        if (element == null) {
            LOGGER.warn("Correlation rule for resource '{}' doesn't contain query filter, returning empty list of users.", (Object)resourceType);
            return null;
        }
        Element filter = this.updateFilterWithAccountValues(currentShadow, element, "Correlation expression", result);
        if (filter == null) {
            return null;
        }
        ArrayList<PrismObject<UserType>> users = null;
        try {
            PagingType paging;
            query = new QueryType();
            query.setFilter(filter);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("SYNCHRONIZATION: CORRELATION: expression for OID {} results in filter\n{}", new Object[]{currentShadow.getOid(), SchemaDebugUtil.prettyPrint((QueryType)query)});
            }
            if ((users = this.repositoryService.searchObjects(UserType.class, query, paging = new PagingType(), result)) == null) {
                users = new ArrayList<PrismObject<UserType>>();
            }
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't search users in repository, based on filter (simplified)\n{}.", (Throwable)ex, (Object[])new Object[]{SchemaDebugUtil.prettyPrint((Element)filter)});
            throw new SynchronizationException("Couldn't search users in repository, based on filter (See logs).", ex);
        }
        LOGGER.debug("SYNCHRONIZATION: CORRELATION: expression for OID {} returned {} users: {}", new Object[]{currentShadow.getOid(), users.size(), DebugUtil.prettyPrint(users, (int)3)});
        return users;
    }

    private List<PrismObject<UserType>> findUserByConfirmationRule(List<PrismObject<UserType>> users, ResourceObjectShadowType currentShadow, ExpressionType expression, OperationResult result) throws SynchronizationException {
        ArrayList<PrismObject<UserType>> list = new ArrayList<PrismObject<UserType>>();
        for (PrismObject<UserType> user : users) {
            try {
                UserType userType = (UserType)user.asObjectable();
                boolean confirmedUser = this.expressionHandler.evaluateConfirmationExpression(userType, currentShadow, expression, result);
                if (user == null || !confirmedUser) continue;
                list.add(user);
            }
            catch (Exception ex) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't confirm user {}", (Throwable)ex, (Object[])new Object[]{user.getName()});
                throw new SynchronizationException("Couldn't confirm user " + user.getName(), ex);
            }
        }
        LOGGER.debug("SYNCHRONIZATION: CONFIRMATION: expression for OID {} matched {} users.", new Object[]{currentShadow.getOid(), list.size()});
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Element updateFilterWithAccountValues(ResourceObjectShadowType currentShadow, Element filter, String shortDesc, OperationResult result) throws SynchronizationException {
        LOGGER.trace("updateFilterWithAccountValues::begin");
        if (filter == null) {
            return null;
        }
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transforming search filter from:\n{}", (Object)DOMUtil.printDom((Node)filter.getOwnerDocument()));
            }
            Document document = DOMUtil.getDocument();
            Element and = document.createElementNS("http://prism.evolveum.com/xml/ns/public/query-2", "and");
            document.appendChild(and);
            and.appendChild(QueryUtil.createTypeFilter((Document)document, (String)ObjectTypes.USER.getObjectTypeUri()));
            Element equal = null;
            if ("http://prism.evolveum.com/xml/ns/public/query-2".equals(filter.getNamespaceURI()) && "equal".equals(filter.getLocalName())) {
                Element valueExpressionElement;
                equal = (Element)document.adoptNode(filter.cloneNode(true));
                Element path = this.findChildElement(equal, "http://prism.evolveum.com/xml/ns/public/query-2", "path");
                if (path != null) {
                    equal.removeChild(path);
                }
                if ((valueExpressionElement = this.findChildElement(equal, "http://midpoint.evolveum.com/xml/ns/public/common/common-2", "valueExpression")) != null) {
                    String expressionResult;
                    equal.removeChild(valueExpressionElement);
                    this.copyNamespaceDefinitions(equal, valueExpressionElement);
                    Element refElement = this.findChildElement(valueExpressionElement, "http://midpoint.evolveum.com/xml/ns/public/common/common-2", "ref");
                    if (refElement == null) {
                        throw new SchemaException("No <ref> element in valueExpression in correlation rule for " + currentShadow.getResource());
                    }
                    QName ref = DOMUtil.resolveQName((Element)refElement);
                    Element value = document.createElementNS("http://prism.evolveum.com/xml/ns/public/query-2", "value");
                    equal.appendChild(value);
                    Element attribute = document.createElementNS(ref.getNamespaceURI(), ref.getLocalPart());
                    ExpressionType valueExpression = (ExpressionType)this.prismContext.getPrismJaxbProcessor().toJavaValue(valueExpressionElement, ExpressionType.class);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("Filter transformed to expression\n{}", (Object)valueExpression);
                    }
                    if (StringUtils.isEmpty((String)(expressionResult = this.expressionHandler.evaluateExpression(currentShadow, valueExpression, shortDesc, result)))) {
                        LOGGER.debug("Result of search filter expression was null or empty. Expression: {}", (Object)valueExpression);
                        return null;
                    }
                    LOGGER.trace("Search filter expression in the rule for OID {} evaluated to {}.", new Object[]{currentShadow.getOid(), expressionResult});
                    attribute.setTextContent(expressionResult);
                    value.appendChild(attribute);
                    and.appendChild(equal);
                } else {
                    LOGGER.warn("No valueExpression in rule for OID {}", (Object)currentShadow.getOid());
                }
            }
            filter = and;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Transforming filter to:\n{}", (Object)DOMUtil.printDom((Node)filter.getOwnerDocument()));
            }
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't transform filter.", (Throwable)ex, (Object[])new Object[0]);
            throw new SynchronizationException("Couldn't transform filter, reason: " + ex.getMessage(), ex);
        }
        LOGGER.trace("updateFilterWithAccountValues::end");
        return filter;
    }

    private void copyNamespaceDefinitions(Element from, Element to) {
        NamedNodeMap attributes = from.getAttributes();
        ArrayList<Attr> xmlns = new ArrayList<Attr>();
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            if (node instanceof Attr) {
                xmlns.add((Attr)attributes.item(i));
            }
            ++i;
        }
        for (Attr attr : xmlns) {
            from.removeAttributeNode(attr);
            to.setAttributeNode(attr);
        }
    }

    private Element findChildElement(Element element, String namespace, String name) {
        NodeList list = element.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            if (node.getNodeType() == 1 && namespace.equals(node.getNamespaceURI()) && name.equals(node.getLocalName())) {
                return (Element)node;
            }
            ++i;
        }
        return null;
    }

    public String getName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)MidpointAspect.aspectOf().processResourceObjectChangeListenerNdc(new SynchronizationService$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void notifyChange_aroundBody0(SynchronizationService ajc$this, ResourceObjectShadowChangeDescription change, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)change, (String)"Resource object shadow change description must not be null.");
        Validate.isTrue((change.getCurrentShadow() != null || change.getObjectDelta() != null ? 1 : 0) != 0, (String)"Object delta and current shadow are null. At least one must be provided.");
        Validate.notNull((Object)change.getResource(), (String)"Resource in change must not be null.");
        Validate.notNull((Object)parentResult, (String)"Parent operation result must not be null.");
        LOGGER.debug("SYNCHRONIZATION: received change notifiation {}", (Object)change);
        OperationResult subResult = parentResult.createSubresult(ResourceObjectChangeListener.NOTIFY_CHANGE);
        try {
            ResourceType resource = (ResourceType)change.getResource().asObjectable();
            if (!ajc$this.isSynchronizationEnabled(ResourceTypeUtil.determineSynchronization((ResourceType)resource, UserType.class))) {
                String message = "SYNCHRONIZATION is not enabled for " + ObjectTypeUtil.toShortString((ObjectType)resource) + " ignoring change from channel " + change.getSourceChannel();
                LOGGER.debug(message);
                subResult.recordStatus(OperationResultStatus.SUCCESS, message);
                return;
            }
            try {
                LOGGER.trace("Synchronization is enabled.");
                SynchronizationSituation situation = ajc$this.checkSituation(change, subResult);
                LOGGER.debug("SYNCHRONIZATION: SITUATION: '{}', {}", (Object)situation.getSituation().value(), (Object)situation.getUser());
                ajc$this.notifyChange(change, situation, resource, task, subResult);
                subResult.computeStatus();
            }
            catch (Exception ex) {
                subResult.recordFatalError((Throwable)ex);
                throw new SystemException((Throwable)ex);
            }
        }
        finally {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(subResult.dump());
            }
        }
    }

    static final /* synthetic */ String getName_aroundBody2(SynchronizationService ajc$this, JoinPoint joinPoint) {
        return "model synchronization service";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SynchronizationService.java", SynchronizationService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "notifyChange", "com.evolveum.midpoint.model.sync.SynchronizationService", "com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "change:task:parentResult", "", "void"), 103);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "com.evolveum.midpoint.model.sync.SynchronizationService", "", "", "", "java.lang.String"), 599);
    }
}

