/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.sync;

import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LiveSyncTaskHandler
implements TaskHandler {
    public static final String HANDLER_URI = "http://midpoint.evolveum.com/model/sync/handler-1";
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private ProvisioningService provisioningService;
    private static final transient Trace LOGGER = TraceManager.getTrace(LiveSyncTaskHandler.class);

    @PostConstruct
    private void initialize() {
        this.taskManager.registerHandler(HANDLER_URI, (TaskHandler)this);
    }

    public TaskRunResult run(Task task) {
        LOGGER.trace("SynchronizationCycle.run starting");
        long progress = task.getProgress();
        OperationResult opResult = new OperationResult("com.evolveum.midpoint.common.operation.liveSync");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        String resourceOid = task.getObjectOid();
        opResult.addContext("resourceOid", (Object)resourceOid);
        if (resourceOid == null) {
            opResult.recordFatalError("Resource OID is null");
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        try {
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error("Live Sync: Resource does not exist, OID: {}", (Object)resourceOid);
            LOGGER.error("Exception stack trace", (Throwable)ex);
            opResult.recordFatalError("Resource does not exist, OID: " + resourceOid, (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (CommunicationException ex) {
            LOGGER.error("Live Sync: Communication error:", (Throwable)ex);
            opResult.recordPartialError("Communication error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SchemaException ex) {
            LOGGER.error("Live Sync: Error dealing with schema:", (Throwable)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (RuntimeException ex) {
            LOGGER.error("Live Sync: Internal Error:", (Throwable)ex);
            opResult.recordFatalError("Internal Error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Live Sync: Configuration error:", (Throwable)ex);
            opResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        catch (SecurityViolationException ex) {
            LOGGER.error("Recompute: Security violation: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Security violation: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(progress);
            return runResult;
        }
        opResult.computeStatus("Live sync run has failed");
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        runResult.setProgress(progress += (long)this.provisioningService.synchronize(resourceOid, task, opResult));
        LOGGER.trace("SynchronizationCycle.run stopping");
        return runResult;
    }

    public Long heartbeat(Task task) {
        return null;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "LiveSynchronization";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

