/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.importer;

import com.evolveum.midpoint.model.importer.ImportConstants;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.NotImplementedException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportObjectsFromFileTaskHandler
implements TaskHandler {
    public static final String HANDLER_URI = "http://midpoint.evolveum.com/model/import/handler-objects-file-1";
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    @Autowired(required=true)
    private PrismContext prismContext;
    private PrismPropertyDefinition filenamePropertyDefinition;
    private static final Trace LOGGER = TraceManager.getTrace(ImportObjectsFromFileTaskHandler.class);

    public ImportObjectsFromFileTaskHandler() {
        this.filenamePropertyDefinition = new PrismPropertyDefinition(ImportConstants.FILENAME_PROPERTY_NAME, ImportConstants.FILENAME_PROPERTY_NAME, DOMUtil.XSD_STRING, this.prismContext);
    }

    @PostConstruct
    private void initialize() {
        this.taskManager.registerHandler(HANDLER_URI, (TaskHandler)this);
    }

    public void launch(File input, Task task, OperationResult parentResult) {
        LOGGER.debug("Launching import accounts from file {}", (Object)input);
        OperationResult result = parentResult.createSubresult(String.valueOf(ImportObjectsFromFileTaskHandler.class.getName()) + ".launch");
        result.addParam("input", (Object)input);
        task.setHandlerUri(HANDLER_URI);
        task.setName("Import from file " + input);
        try {
            PrismProperty filenameProp = this.filenamePropertyDefinition.instantiate();
            filenameProp.setRealValue((Object)input.getAbsolutePath());
            task.setExtensionProperty(filenameProp);
            task.savePendingModifications(result);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Task object not found, expecting it to exist (task {})", (Object)task, (Object)e);
            result.recordFatalError("Task object not found", (Throwable)e);
            throw new IllegalStateException("Task object not found, expecting it to exist", e);
        }
        catch (ObjectAlreadyExistsException e) {
            LOGGER.error("Task object was not updated (task {})", (Object)task, (Object)e);
            result.recordFatalError("Task object was not updated", (Throwable)e);
            throw new IllegalStateException("Task object was not updated", e);
        }
        catch (SchemaException e) {
            LOGGER.error("Error dealing with schema (task {})", (Object)task, (Object)e);
            result.recordFatalError("Error dealing with schema", (Throwable)e);
            throw new IllegalStateException("Error dealing with schema", e);
        }
        this.taskManager.switchToBackground(task, result);
        LOGGER.trace("Import objects from file {} switched to background, control thread returning with task {}", (Object)input, (Object)task);
    }

    public TaskRunResult run(Task task) {
        LOGGER.debug("Import objects from file run (task {})", (Object)task);
        OperationResult opResult = task.getResult().createSubresult("com.evolveum.midpoint.common.operation.import.objectsFromFile");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        runResult.setProgress(0L);
        PrismProperty filenameProperty = task.getExtension(ImportConstants.FILENAME_PROPERTY_NAME);
        if (filenameProperty == null) {
            LOGGER.error("Import: No file specified");
            opResult.recordFatalError("No file specified");
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        String filename = (String)filenameProperty.getValue().getValue();
        if (filename == null) {
            LOGGER.error("Import: No file specified");
            opResult.recordFatalError("No file specified");
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        new File(filename);
        opResult.computeStatus("Errors during import");
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        LOGGER.debug("Import objects from file run finished (task {}, run result {})", (Object)task, (Object)runResult);
        return runResult;
    }

    public Long heartbeat(Task task) {
        throw new NotImplementedException();
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "ImportFromFile";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

