/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.importer;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.model.importer.ImportConstants;
import com.evolveum.midpoint.model.sync.SynchronizeAccountResultHandler;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener;
import com.evolveum.midpoint.provisioning.api.ResultHandler;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportAccountsFromResourceTaskHandler
implements TaskHandler {
    public static final String HANDLER_URI = "http://midpoint.evolveum.com/model/import/handler-accounts-resource-1";
    @Autowired(required=true)
    private ProvisioningService provisioning;
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    @Autowired(required=true)
    private PrismContext prismContext;
    private Map<Task, SynchronizeAccountResultHandler> handlers = new HashMap<Task, SynchronizeAccountResultHandler>();
    private PrismPropertyDefinition objectclassPropertyDefinition = new PrismPropertyDefinition(ImportConstants.OBJECTCLASS_PROPERTY_NAME, ImportConstants.OBJECTCLASS_PROPERTY_NAME, DOMUtil.XSD_QNAME, this.prismContext);
    private static final Trace LOGGER = TraceManager.getTrace(ImportAccountsFromResourceTaskHandler.class);

    @PostConstruct
    private void initialize() {
        this.taskManager.registerHandler(HANDLER_URI, (TaskHandler)this);
    }

    public void launch(ResourceType resource, QName objectclass, Task task, OperationResult parentResult) {
        LOGGER.info("Launching import from resource {} as asynchronous task", (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
        OperationResult result = parentResult.createSubresult(String.valueOf(ImportAccountsFromResourceTaskHandler.class.getName()) + ".launch");
        result.addParam("resource", (Object)resource);
        result.addParam("objectclass", (Object)objectclass);
        task.setHandlerUri(HANDLER_URI);
        task.setName("Import from resource " + resource.getName());
        task.setObjectRef(ObjectTypeUtil.createObjectRef((ObjectType)resource));
        try {
            PrismProperty objectclassProp = this.objectclassPropertyDefinition.instantiate();
            objectclassProp.setRealValue((Object)objectclass);
            task.setExtensionProperty(objectclassProp);
            task.savePendingModifications(result);
        }
        catch (ObjectNotFoundException e) {
            LOGGER.error("Task object not found, expecting it to exist (task {})", (Object)task, (Object)e);
            result.recordFatalError("Task object not found", (Throwable)e);
            throw new IllegalStateException("Task object not found, expecting it to exist", e);
        }
        catch (ObjectAlreadyExistsException e) {
            LOGGER.error("Task object wasn't updated (task {})", (Object)task, (Object)e);
            result.recordFatalError("Task object wasn't updated", (Throwable)e);
            throw new IllegalStateException("Task object wasn't updated", e);
        }
        catch (SchemaException e) {
            LOGGER.error("Error dealing with schema (task {})", (Object)task, (Object)e);
            result.recordFatalError("Error dealing with schema", (Throwable)e);
            throw new IllegalStateException("Error dealing with schema", e);
        }
        this.taskManager.switchToBackground(task, result);
        result.computeStatus("Import launch failed");
        LOGGER.trace("Import from resource {} switched to background, control thread returning with task {}", (Object)ObjectTypeUtil.toShortString((ObjectType)resource), (Object)task);
    }

    public TaskRunResult run(Task task) {
        RefinedResourceSchema refinedSchema;
        LOGGER.trace("Import from resource run (task {})", (Object)task);
        OperationResult opResult = task.getResult().createSubresult("com.evolveum.midpoint.common.operation.import.accountsFromResource");
        TaskRunResult runResult = new TaskRunResult();
        runResult.setOperationResult(opResult);
        runResult.setProgress(0L);
        ResourceType resource = null;
        try {
            resource = (ResourceType)task.getObject(ResourceType.class, opResult).asObjectable();
        }
        catch (ObjectNotFoundException ex) {
            String resourceOid = null;
            if (task.getObjectRef() != null) {
                resourceOid = task.getObjectRef().getOid();
            }
            LOGGER.error("Import: Resource not found: {}", (Object)resourceOid, (Object)ex);
            opResult.recordFatalError("Resource not found " + resourceOid, (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        catch (SchemaException ex) {
            LOGGER.error("Import: Error dealing with schema: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            return runResult;
        }
        catch (RuntimeException ex) {
            LOGGER.error("Import: Internal Error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Internal Error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        if (resource == null) {
            LOGGER.error("Import: No resource specified");
            opResult.recordFatalError("No resource specified");
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        try {
            refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)resource, (PrismContext)this.prismContext);
        }
        catch (SchemaException e) {
            LOGGER.error("Import: Schema error during processing account definition: {}", (Object)e.getMessage());
            opResult.recordFatalError("Schema error during processing account definition: " + e.getMessage(), (Throwable)e);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        RefinedAccountDefinition refinedAccountDefinition = refinedSchema.getDefaultAccountDefinition();
        QName objectclass = null;
        PrismProperty objectclassProperty = task.getExtension(ImportConstants.OBJECTCLASS_PROPERTY_NAME);
        if (objectclassProperty != null) {
            objectclass = (QName)objectclassProperty.getValue().getValue();
        }
        if (objectclass == null && refinedSchema.getDefaultAccountDefinition() != null) {
            objectclass = refinedSchema.getDefaultAccountDefinition().getObjectClassDefinition().getTypeName();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Import: No objectclass specified, using default value of " + objectclass + ".");
            }
        }
        if (objectclass == null) {
            LOGGER.error("Import: No objectclass specified and no default can be determined.");
            opResult.recordFatalError("No objectclass specified and no default can be determined");
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            return runResult;
        }
        LOGGER.info("Start executing import from resource {}, importing object class {}", (Object)ObjectTypeUtil.toShortString((ObjectType)resource), (Object)objectclass);
        SynchronizeAccountResultHandler handler = new SynchronizeAccountResultHandler(resource, refinedAccountDefinition, task, (ResourceObjectChangeListener)this.changeNotificationDispatcher);
        handler.setSourceChannel(SchemaConstants.CHANGE_CHANNEL_IMPORT);
        handler.setForceAdd(true);
        handler.setStopOnError(false);
        handler.setProcessShortName("import");
        this.handlers.put(task, handler);
        try {
            this.provisioning.searchObjectsIterative(AccountShadowType.class, QueryUtil.createResourceAndAccountQuery((ResourceType)resource, (QName)objectclass, null), null, (ResultHandler)handler, opResult);
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error("Import: Object not found: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Object not found " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        catch (CommunicationException ex) {
            LOGGER.error("Import: Communication error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordPartialError("Communication error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        catch (SchemaException ex) {
            LOGGER.error("Import: Error dealing with schema: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Error dealing with schema: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        catch (RuntimeException ex) {
            LOGGER.error("Import: Internal Error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Internal Error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        catch (ConfigurationException ex) {
            LOGGER.error("Import: Configuration error: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.TEMPORARY_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        catch (SecurityViolationException ex) {
            LOGGER.error("Import: Security violation: {}", (Object)ex.getMessage(), (Object)ex);
            opResult.recordFatalError("Security violation: " + ex.getMessage(), (Throwable)ex);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
            runResult.setProgress(handler.getProgress());
            return runResult;
        }
        this.handlers.remove(task);
        opResult.computeStatus("Errors during import");
        runResult.setProgress(handler.getProgress());
        runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        LOGGER.info("Finished import from resource {}, importing object class {}. Processed {} objects, {} errors", new Object[]{ObjectTypeUtil.toShortString((ObjectType)resource), objectclass, handler.getProgress(), handler.getErrors()});
        LOGGER.trace("Import from resource run finished (task {}, run result {})", (Object)task, (Object)runResult);
        return runResult;
    }

    private SynchronizeAccountResultHandler getHandler(Task task) {
        return this.handlers.get(task);
    }

    public Long heartbeat(Task task) {
        if (this.getHandler(task) != null) {
            return this.getHandler(task).heartbeat();
        }
        return null;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "ImportingAccounts";
    }

    public List<String> getCategoryNames() {
        return null;
    }
}

