/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.controller;

import com.evolveum.midpoint.common.LoggingConfigurationManager;
import com.evolveum.midpoint.model.api.hooks.ChangeHook;
import com.evolveum.midpoint.model.api.hooks.HookOperationMode;
import com.evolveum.midpoint.model.api.hooks.HookRegistry;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.LoggingConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemConfigurationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.SystemObjectsType;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SystemConfigurationHandler
implements ChangeHook {
    private static final Trace LOGGER = TraceManager.getTrace(SystemConfigurationHandler.class);
    private static final String DOT_CLASS = SystemConfigurationHandler.class + ".";
    public static final String HOOK_URI = "http://midpoint.evolveum.com/model/sysconfig-hook-1";
    @Autowired(required=true)
    private HookRegistry hookRegistry;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private transient RepositoryService cacheRepositoryService;

    @PostConstruct
    public void init() {
        this.hookRegistry.registerChangeHook(HOOK_URI, (ChangeHook)this);
    }

    public void postInit(PrismObject<SystemConfigurationType> systemConfiguration, OperationResult parentResult) {
        SystemConfigurationType systemConfigurationType = (SystemConfigurationType)systemConfiguration.asObjectable();
        LoggingConfigurationType loggingConfigType = systemConfigurationType.getLogging();
        if (loggingConfigType != null) {
            LoggingConfigurationManager.configure((LoggingConfigurationType)loggingConfigType, (String)systemConfiguration.getVersion(), (OperationResult)parentResult);
        }
    }

    public HookOperationMode preChangePrimary(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        return HookOperationMode.FOREGROUND;
    }

    public HookOperationMode preChangeSecondary(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        return HookOperationMode.FOREGROUND;
    }

    public HookOperationMode postChange(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult parentResult) {
        boolean relatesToSystemConfiguration = false;
        boolean isDeletion = false;
        for (ObjectDelta<? extends ObjectType> change : changes) {
            if (!change.getObjectTypeClass().isAssignableFrom(SystemConfigurationType.class)) continue;
            relatesToSystemConfiguration = true;
            isDeletion = change.isDelete();
        }
        if (!relatesToSystemConfiguration) {
            return HookOperationMode.FOREGROUND;
        }
        OperationResult result = parentResult.createSubresult(String.valueOf(DOT_CLASS) + "postChange");
        try {
            if (isDeletion) {
                LoggingConfigurationManager.resetCurrentlyUsedVersion();
                return HookOperationMode.FOREGROUND;
            }
            PrismObject config = this.cacheRepositoryService.getObject(SystemConfigurationType.class, SystemObjectsType.SYSTEM_CONFIGURATION.value(), result);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("System configuration version read from repo: " + config.getVersion());
            }
            this.postInit((PrismObject<SystemConfigurationType>)config, result);
            result.recordSuccessIfUnknown();
            return HookOperationMode.FOREGROUND;
        }
        catch (ObjectNotFoundException e) {
            String message = "Cannot read system configuration because it does not exist in repository: " + e.getMessage();
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError(message, (Throwable)e);
            return HookOperationMode.ERROR;
        }
        catch (SchemaException e) {
            String message = "Cannot read system configuration because of schema exception: " + e.getMessage();
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError(message, (Throwable)e);
            return HookOperationMode.ERROR;
        }
    }
}

