/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.controller;

import com.evolveum.midpoint.model.api.hooks.HookRegistry;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.result.OperationResultStatus;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStateType;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelOperationTaskHandler
implements TaskHandler {
    public static final String MODEL_OPERATION_TASK_URI = "http://evolveum.com/model-operation-task-uri";
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private ModelController model;
    @Autowired(required=false)
    private HookRegistry hookRegistry;
    private static final Trace LOGGER = TraceManager.getTrace(ModelOperationTaskHandler.class);

    public TaskRunResult run(Task task) {
        OperationResult result = new OperationResult("ModelOperationTaskHandler.run");
        TaskRunResult runResult = new TaskRunResult();
        ModelOperationStateType state = task.getModelOperationState();
        if (state == null) {
            String message = "The task " + task + " cannot be processed by ModelOperationTaskHandler, as it does not contain modelOperationState element.";
            LOGGER.error(message);
            result.recordFatalError(message);
            runResult.setRunResultStatus(TaskRunResult.TaskRunResultStatus.PERMANENT_ERROR);
        }
        runResult.setOperationResult(result);
        return runResult;
    }

    public Long heartbeat(Task task) {
        return null;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "Workflow";
    }

    public List<String> getCategoryNames() {
        return null;
    }

    @PostConstruct
    private void initialize() throws Exception {
        LOGGER.info("Registering with taskManager as a handler for http://evolveum.com/model-operation-task-uri");
        this.taskManager.registerHandler(MODEL_OPERATION_TASK_URI, (TaskHandler)this);
    }

    static Object getContext(Task task, OperationResult parentResult, String methodName) {
        Object data;
        ModelOperationStateType state = task.getModelOperationState();
        if (state == null) {
            String message = "Model operation for task " + task + " does not carry ModelOperationState, exiting the " + methodName + " method.";
            LOGGER.info(message);
            parentResult.recordStatus(OperationResultStatus.FATAL_ERROR, message);
            return null;
        }
        try {
            String dataAsString = state.getOperationData();
            LOGGER.info("DataAsString (from task new) = " + dataAsString);
            if (dataAsString == null) {
                throw new Exception("Operation data is not present.");
            }
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(Base64.decodeBase64((String)dataAsString)));
            data = ois.readObject();
            if (data == null) {
                throw new Exception("Operation data is not present.");
            }
        }
        catch (Exception exception) {
            return null;
        }
        LOGGER.info("Operation data class = " + data.getClass().getName());
        return data;
    }
}

