/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.controller;

import com.evolveum.midpoint.model.controller.Filter;
import com.evolveum.midpoint.model.controller.FilterManager;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class FilterManagerImpl<T extends Filter>
implements FilterManager<T> {
    private static final Trace LOGGER = TraceManager.getTrace(FilterManagerImpl.class);
    private Map<String, Class<T>> filterMap;

    @Override
    public void setFilterMapping(Map<String, Class<T>> filterMap) {
        Validate.notNull(filterMap, (String)"Filter mapping must not be null.");
        this.filterMap = filterMap;
    }

    @Override
    public Filter getFilterInstance(String uri) {
        return this.getFilterInstance(uri, null);
    }

    @Override
    public Filter getFilterInstance(String uri, List<Object> parameters) {
        Validate.notEmpty((String)uri, (String)"Filter uri must not be null or empty.");
        Class<T> clazz = this.filterMap.get(uri);
        if (clazz == null) {
            return null;
        }
        Filter filter = null;
        try {
            filter = (Filter)clazz.newInstance();
            filter.setParameters(parameters);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couln't create filter instance", (Throwable)ex, (Object[])new Object[0]);
        }
        return filter;
    }
}

