/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountSynchronizationSettingsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentPolicyEnforcementType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserTemplateType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class SyncContext
implements Dumpable,
DebugDumpable,
Serializable {
    private PrismObject<UserType> userOld;
    private PrismObject<UserType> userNew;
    private ObjectDelta<UserType> userPrimaryDelta;
    private ObjectDelta<UserType> userSecondaryDelta;
    private UserTemplateType userTemplate;
    private String channel;
    private AccountSynchronizationSettingsType accountSynchronizationSettings;
    private Map<ResourceAccountType, AccountSyncContext> accountContextMap = new HashMap<ResourceAccountType, AccountSyncContext>();
    private Map<String, ResourceType> resourceCache = new HashMap<String, ResourceType>();
    private boolean doReconciliationForAllAccounts = false;
    private PrismObjectDefinition<UserType> userDefinition = null;
    private PrismContext prismContext;

    public SyncContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public PrismObject<UserType> getUserOld() {
        return this.userOld;
    }

    public void setUserOld(PrismObject<UserType> userOld) {
        this.userOld = userOld;
    }

    public PrismObject<UserType> getUserNew() {
        return this.userNew;
    }

    public void setUserNew(PrismObject<UserType> userNew) {
        this.userNew = userNew;
    }

    public ObjectDelta<UserType> getUserPrimaryDelta() {
        return this.userPrimaryDelta;
    }

    public void setUserPrimaryDelta(ObjectDelta<UserType> userPrimaryDelta) {
        this.userPrimaryDelta = userPrimaryDelta;
    }

    public ObjectDelta<UserType> getUserSecondaryDelta() {
        return this.userSecondaryDelta;
    }

    public void setUserSecondaryDelta(ObjectDelta<UserType> userSecondaryDelta) {
        this.userSecondaryDelta = userSecondaryDelta;
    }

    public ObjectDeltaObject<UserType> getUserOdo() throws SchemaException {
        return new ObjectDeltaObject(this.userOld, this.getUserDelta(), this.userNew);
    }

    public UserTemplateType getUserTemplate() {
        return this.userTemplate;
    }

    public void setUserTemplate(UserTemplateType userTemplate) {
        this.userTemplate = userTemplate;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public AccountSynchronizationSettingsType getAccountSynchronizationSettings() {
        return this.accountSynchronizationSettings;
    }

    public void setAccountSynchronizationSettings(AccountSynchronizationSettingsType accountSynchronizationSettings) {
        this.accountSynchronizationSettings = accountSynchronizationSettings;
    }

    public boolean isDoReconciliationForAllAccounts() {
        return this.doReconciliationForAllAccounts;
    }

    public void setDoReconciliationForAllAccounts(boolean doReconciliationForAllAccounts) {
        this.doReconciliationForAllAccounts = doReconciliationForAllAccounts;
    }

    public AssignmentPolicyEnforcementType getAssignmentPolicyEnforcementType() {
        if (this.accountSynchronizationSettings.getAssignmentPolicyEnforcement() == null) {
            return AssignmentPolicyEnforcementType.FULL;
        }
        return this.accountSynchronizationSettings.getAssignmentPolicyEnforcement();
    }

    public Collection<AccountSyncContext> getAccountContexts() {
        return this.accountContextMap.values();
    }

    public void addAccountSyncContext(ResourceAccountType rat, AccountSyncContext accountSyncContext) {
        if (this.accountContextMap.containsKey(rat)) {
            throw new IllegalArgumentException("Addition of duplicate account context for " + rat);
        }
        if (accountSyncContext.getResource() == null) {
            accountSyncContext.setResource(this.getResource(rat));
        }
        this.accountContextMap.put(rat, accountSyncContext);
    }

    public AccountSyncContext findAccountSyncContextByOid(String oid) {
        for (AccountSyncContext accCtx : this.getAccountContexts()) {
            if (!oid.equals(accCtx.getOid())) continue;
            return accCtx;
        }
        return null;
    }

    public void setAccountPrimaryDelta(ResourceAccountType rat, ObjectDelta<AccountShadowType> accountDelta) {
        if (!this.accountContextMap.containsKey(rat)) {
            this.accountContextMap.put(rat, new AccountSyncContext(rat, this.prismContext));
        }
        this.accountContextMap.get(rat).setAccountPrimaryDelta(accountDelta);
    }

    public void setAccountSecondaryDelta(ResourceAccountType rat, ObjectDelta<AccountShadowType> accountDelta) {
        if (!this.accountContextMap.containsKey(rat)) {
            this.accountContextMap.put(rat, new AccountSyncContext(rat, this.prismContext));
        }
        this.accountContextMap.get(rat).setAccountSecondaryDelta(accountDelta);
    }

    public ObjectDelta<UserType> getUserDelta() throws SchemaException {
        return ObjectDelta.union((ObjectDelta[])new ObjectDelta[]{this.userPrimaryDelta, this.userSecondaryDelta});
    }

    public ObjectDeltaObject<UserType> getUserObjectDeltaObject() {
        ObjectDeltaObject userOdo;
        try {
            userOdo = new ObjectDeltaObject(this.userOld, this.getUserDelta(), this.userNew);
        }
        catch (SchemaException e) {
            throw new SystemException("Unexpected schema error: " + e.getMessage(), (Throwable)e);
        }
        return userOdo;
    }

    public void setUserOid(String oid) {
        if (this.getUserPrimaryDelta() != null) {
            this.getUserPrimaryDelta().setOid(oid);
        }
        if (this.getUserSecondaryDelta() != null) {
            this.getUserSecondaryDelta().setOid(oid);
        }
        if (this.userNew != null) {
            this.userNew.setOid(oid);
        }
    }

    public void recomputeNew() throws SchemaException {
        this.recomputeUserNew();
        this.recomputeAccountsNew();
    }

    public void recomputeUserNew() throws SchemaException {
        ObjectDelta<UserType> userDelta = this.getUserDelta();
        if (userDelta == null) {
            this.userNew = this.userOld;
            return;
        }
        this.userNew = userDelta.computeChangedObject(this.userOld);
    }

    public void recomputeAccountsNew() throws SchemaException {
        for (AccountSyncContext accCtx : this.getAccountContexts()) {
            accCtx.recomputeAccountNew();
        }
    }

    public ContainerDelta<AssignmentType> getAssignmentDelta() throws SchemaException {
        ObjectDelta<UserType> userDelta = this.getUserDelta();
        if (userDelta == null) {
            return this.createEmptyAssignmentDelta();
        }
        ContainerDelta assignmentDelta = userDelta.findContainerDelta(new PropertyPath(new QName[]{SchemaConstants.C_ASSIGNMENT}));
        if (assignmentDelta == null) {
            return this.createEmptyAssignmentDelta();
        }
        return assignmentDelta;
    }

    private ContainerDelta<AssignmentType> createEmptyAssignmentDelta() {
        return new ContainerDelta(this.getAssignmentContainerDefinition());
    }

    private PrismContainerDefinition<AssignmentType> getAssignmentContainerDefinition() {
        return this.getUserDefinition().findContainerDefinition(UserType.F_ASSIGNMENT);
    }

    private PrismObjectDefinition<UserType> getUserDefinition() {
        if (this.userDefinition == null) {
            this.userDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(UserType.class);
        }
        return this.userDefinition;
    }

    public void addPrimaryUserDelta(ObjectDelta<UserType> userDelta) throws SchemaException {
        if (this.userPrimaryDelta == null) {
            this.userPrimaryDelta = userDelta;
        } else {
            this.userPrimaryDelta.merge(userDelta);
        }
    }

    public RefinedResourceSchema getRefinedResourceSchema(ResourceAccountType rat) throws SchemaException {
        ResourceType resourceType = this.getResource(rat);
        if (resourceType == null) {
            throw new IllegalStateException("No resource for " + rat);
        }
        return RefinedResourceSchema.getRefinedSchema((ResourceType)resourceType, (PrismContext)this.prismContext);
    }

    public RefinedAccountDefinition getRefinedAccountDefinition(ResourceAccountType rat) throws SchemaException {
        return this.getRefinedResourceSchema(rat).getAccountDefinition(rat.getAccountType());
    }

    public ResourceType getResource(ResourceAccountType rat) {
        return this.resourceCache.get(rat.getResourceOid());
    }

    public AccountSyncContext getAccountSyncContext(ResourceAccountType rat) {
        return this.accountContextMap.get(rat);
    }

    public void rememberResources(Collection<ResourceType> resources) {
        for (ResourceType resourceType : resources) {
            this.rememberResource(resourceType);
        }
    }

    public void rememberResource(ResourceType resourceType) {
        this.resourceCache.put(resourceType.getOid(), resourceType);
    }

    public Collection<ObjectDelta<? extends ObjectType>> getAllChanges() {
        ArrayList<ObjectDelta<? extends ObjectType>> allChanges = new ArrayList<ObjectDelta<? extends ObjectType>>();
        this.addChangeIfNotNull(allChanges, this.userPrimaryDelta);
        this.addChangeIfNotNull(allChanges, this.userSecondaryDelta);
        for (AccountSyncContext accSyncCtx : this.accountContextMap.values()) {
            this.addChangeIfNotNull(allChanges, accSyncCtx.getAccountPrimaryDelta());
            this.addChangeIfNotNull(allChanges, accSyncCtx.getAccountSecondaryDelta());
        }
        return allChanges;
    }

    private <T extends ObjectType> void addChangeIfNotNull(Collection<ObjectDelta<? extends ObjectType>> changes, ObjectDelta<T> change) {
        if (change != null) {
            changes.add(change);
        }
    }

    public AccountSyncContext createAccountSyncContext(ResourceAccountType rat) {
        AccountSyncContext accountSyncContext = new AccountSyncContext(rat, this.prismContext);
        this.addAccountSyncContext(rat, accountSyncContext);
        return accountSyncContext;
    }

    public void checkConsistence() {
        if (this.userOld != null) {
            try {
                this.userOld.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in old user in SyncContext", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in old user in SyncContext", e);
            }
            if (this.userOld.getDefinition() == null) {
                throw new IllegalStateException("No old user definition in " + this);
            }
        }
        if (this.userPrimaryDelta != null) {
            try {
                this.userPrimaryDelta.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in user primary delta in SyncContext", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in user primary delta in SyncContext", e);
            }
        }
        if (this.userSecondaryDelta != null) {
            try {
                boolean requireOid = this.userPrimaryDelta == null;
                this.userSecondaryDelta.checkConsistence(requireOid);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in user secondary delta in SyncContext", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in user secondary delta in SyncContext", e);
            }
        }
        if (this.userNew != null) {
            try {
                this.userNew.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in new user in SyncContext", e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in new user in SyncContext", e);
            }
            if (this.userNew.getDefinition() == null) {
                throw new IllegalStateException("No new user definition in " + this);
            }
        }
        for (AccountSyncContext accCtx : this.getAccountContexts()) {
            accCtx.checkConsistence();
        }
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String dump() {
        return this.debugDump(0);
    }

    public String dump(boolean showTriples) {
        return this.debugDump(0, showTriples);
    }

    public String debugDump(int indent) {
        return this.debugDump(indent, true);
    }

    public String debugDump(int indent, boolean showTriples) {
        StringBuilder sb = new StringBuilder();
        this.indent(sb, indent);
        sb.append("SyncContext\n");
        this.indent(sb, indent + 1);
        sb.append("Settings: ");
        if (this.accountSynchronizationSettings != null) {
            sb.append("assignments:");
            sb.append(this.accountSynchronizationSettings.getAssignmentPolicyEnforcement());
        } else {
            sb.append("null");
        }
        sb.append("\n");
        this.indent(sb, indent + 1);
        sb.append("USER old:");
        if (this.userOld == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(this.userOld.debugDump(indent + 2));
        }
        sb.append("\n");
        this.indent(sb, indent + 1);
        sb.append("USER new:");
        if (this.userNew == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(this.userNew.debugDump(indent + 2));
        }
        sb.append("\n");
        this.indent(sb, indent + 1);
        sb.append("USER primary delta:");
        if (this.userPrimaryDelta == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(this.userPrimaryDelta.debugDump(indent + 2));
        }
        sb.append("\n");
        this.indent(sb, indent + 1);
        sb.append("USER secondary delta:");
        if (this.userSecondaryDelta == null) {
            sb.append(" null");
        } else {
            sb.append("\n");
            sb.append(this.userSecondaryDelta.debugDump(indent + 2));
        }
        sb.append("\n");
        this.indent(sb, indent + 1);
        sb.append("ACCOUNTS:");
        if (this.accountContextMap.isEmpty()) {
            sb.append(" none");
        } else {
            sb.append(" (").append(this.accountContextMap.size()).append(")");
            for (Map.Entry<ResourceAccountType, AccountSyncContext> entry : this.accountContextMap.entrySet()) {
                sb.append("\n");
                this.indent(sb, indent + 2);
                sb.append("ACCOUNT ");
                sb.append(entry.getKey()).append(":\n");
                sb.append(entry.getValue().debugDump(indent + 3, showTriples));
            }
        }
        return sb.toString();
    }

    private void indent(StringBuilder sb, int indent) {
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
    }
}

