/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.model.api.ModelPort;
import com.evolveum.midpoint.model.controller.ModelController;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.MiscSchemaUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectListType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectModificationType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PropertyReferenceListType;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ResourceObjectShadowListType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.TaskType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.fault_1.FaultType;
import com.evolveum.midpoint.xml.ns._public.common.fault_1.IllegalArgumentFaultType;
import com.evolveum.midpoint.xml.ns._public.common.fault_1.ObjectNotFoundFaultType;
import com.evolveum.midpoint.xml.ns._public.common.fault_1.SystemFaultType;
import com.evolveum.midpoint.xml.ns._public.common.fault_1_wsdl.FaultMessage;
import com.evolveum.midpoint.xml.ns._public.model.model_1_wsdl.ModelPortType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ModelWebService
implements ModelPortType,
ModelPort {
    private static final Trace LOGGER = TraceManager.getTrace(ModelWebService.class);
    @Autowired(required=true)
    private ModelController model;
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private PrismContext prismContext;

    public void addObject(ObjectType objectType, Holder<String> oidHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notNullArgument(objectType, "Object must not be null.");
        Task task = this.createTaskInstance(ModelPort.ADD_OBJECT);
        this.setTaskOwner(task);
        OperationResult operationResult = task.getResult();
        try {
            PrismObject object = objectType.asPrismObject();
            this.prismContext.adopt((Objectable)objectType);
            String oid = this.model.addObject(object, task, operationResult);
            this.handleOperationResult(operationResult, result);
            oidHolder.value = oid;
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL addObject() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void getObject(String objectTypeUri, String oid, PropertyReferenceListType resolve, Holder<ObjectType> objectHolder, Holder<OperationResultType> resultHolder) throws FaultMessage {
        this.notEmptyArgument(oid, "Oid must not be null or empty.");
        this.notNullArgument(resolve, "Property reference list  must not be null.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.GET_OBJECT);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            PrismObject object = this.model.getObject(ObjectTypes.getObjectTypeFromUri((String)objectTypeUri).getClassDefinition(), oid, MiscSchemaUtil.itemReferenceListTypeToItemPathList((PropertyReferenceListType)resolve), task, operationResult);
            this.handleOperationResult(operationResult, resultHolder);
            objectHolder.value = (ObjectType)object.asObjectable();
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL getObject() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void listObjects(String objectType, PagingType paging, Holder<ObjectListType> objectListHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notEmptyArgument(objectType, "Object type must not be null or empty.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.LIST_OBJECTS);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            List list = this.model.listObjects(ObjectTypes.getObjectTypeFromUri((String)objectType).getClassDefinition(), paging, task, operationResult);
            this.handleOperationResult(operationResult, result);
            ObjectListType listType = new ObjectListType();
            for (PrismObject o : list) {
                listType.getObject().add((ObjectType)o.asObjectable());
            }
            objectListHolder.value = listType;
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL listObjects() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void searchObjects(String objectTypeUri, QueryType query, PagingType paging, Holder<ObjectListType> objectListHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notNullArgument(query, "Query must not be null.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.SEARCH_OBJECTS);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            List list = this.model.searchObjects(ObjectTypes.getObjectTypeFromUri((String)objectTypeUri).getClassDefinition(), query, paging, task, operationResult);
            this.handleOperationResult(operationResult, result);
            ObjectListType listType = new ObjectListType();
            for (PrismObject o : list) {
                listType.getObject().add((ObjectType)o.asObjectable());
            }
            objectListHolder.value = listType;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL searchObjects() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public OperationResultType modifyObject(String objectTypeUri, ObjectModificationType change) throws FaultMessage {
        this.notNullArgument(change, "Object modification must not be null.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.MODIFY_OBJECT);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            Class type = ObjectTypes.getObjectTypeFromUri((String)objectTypeUri).getClassDefinition();
            Collection modifications = DeltaConvertor.toModifications((ObjectModificationType)change, (Class)type, (PrismContext)this.prismContext);
            this.model.modifyObject(type, change.getOid(), modifications, task, operationResult);
            return this.handleOperationResult(operationResult);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL modifyObject() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public OperationResultType deleteObject(String objectTypeUri, String oid) throws FaultMessage {
        this.notEmptyArgument(oid, "Oid must not be null or empty.");
        this.notEmptyArgument(objectTypeUri, "objectType must not be null or empty.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.DELETE_OBJECT);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            this.model.deleteObject(ObjectTypes.getObjectTypeFromUri((String)objectTypeUri).getClassDefinition(), oid, task, operationResult);
            return this.handleOperationResult(operationResult);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL deleteObject() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void listAccountShadowOwner(String accountOid, Holder<UserType> userHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notEmptyArgument(accountOid, "Account oid must not be null or empty.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.LIST_ACCOUNT_SHADOW_OWNER);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            PrismObject<UserType> user = this.model.listAccountShadowOwner(accountOid, task, operationResult);
            this.handleOperationResult(operationResult, result);
            if (user != null) {
                userHolder.value = (UserType)user.asObjectable();
            }
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL listAccountShadowOwner() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void listResourceObjectShadows(String resourceOid, String resourceObjectShadowType, Holder<ResourceObjectShadowListType> resourceObjectShadowListHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notEmptyArgument(resourceOid, "Resource oid must not be null or empty.");
        this.notEmptyArgument(resourceObjectShadowType, "Resource object shadow type must not be null or empty.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.LIST_RESOURCE_OBJECT_SHADOWS);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            List list = this.model.listResourceObjectShadows(resourceOid, ObjectTypes.getObjectTypeFromUri((String)resourceObjectShadowType).getClassDefinition(), task, operationResult);
            this.handleOperationResult(operationResult, result);
            ResourceObjectShadowListType resultList = new ResourceObjectShadowListType();
            for (PrismObject shadow : list) {
                resultList.getObject().add((ResourceObjectShadowType)shadow.asObjectable());
            }
            resourceObjectShadowListHolder.value = resultList;
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL listResourceObjectShadows() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public void listResourceObjects(String resourceOid, QName objectType, PagingType paging, Holder<ObjectListType> objectListTypeHolder, Holder<OperationResultType> result) throws FaultMessage {
        this.notEmptyArgument(resourceOid, "Resource oid must not be null or empty.");
        this.notNullArgument(objectType, "Object type must not be null.");
        this.notNullArgument(paging, "Paging  must not be null.");
        OperationResult operationResult = null;
        try {
            Task task = this.createTaskInstance(ModelPort.LIST_RESOURCE_OBJECTS);
            this.setTaskOwner(task);
            operationResult = task.getResult();
            List<PrismObject<? extends ResourceObjectShadowType>> list = this.model.listResourceObjects(resourceOid, objectType, paging, task, operationResult);
            this.handleOperationResult(operationResult, result);
            ObjectListType listType = new ObjectListType();
            for (PrismObject<? extends ResourceObjectShadowType> o : list) {
                listType.getObject().add((ObjectType)o.asObjectable());
            }
            objectListTypeHolder.value = listType;
            return;
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL listResourceObjects() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    public OperationResultType testResource(String resourceOid) throws FaultMessage {
        this.notEmptyArgument(resourceOid, "Resource oid must not be null or empty.");
        try {
            Task task = this.createTaskInstance(ModelPort.TEST_RESOURCE);
            this.setTaskOwner(task);
            OperationResult testResult = this.model.testResource(resourceOid, task);
            return this.handleOperationResult(testResult);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL testResource() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, null);
        }
    }

    private void handleOperationResult(OperationResult result, Holder<OperationResultType> holder) {
        result.recordSuccess();
        OperationResultType resultType = result.createOperationResultType();
        if (holder.value == null) {
            holder.value = resultType;
        } else {
            ((OperationResultType)holder.value).getPartialResults().add(resultType);
        }
    }

    private OperationResultType handleOperationResult(OperationResult result) {
        result.recordSuccess();
        return result.createOperationResultType();
    }

    private void notNullResultHolder(Holder<OperationResultType> holder) throws FaultMessage {
        this.notNullArgument(holder, "Holder must not be null.");
        this.notNullArgument(holder.value, "Result type must not be null.");
    }

    private <T> void notNullHolder(Holder<T> holder) throws FaultMessage {
        this.notNullArgument(holder, "Holder must not be null.");
        this.notNullArgument(holder.value, String.valueOf(holder.getClass().getSimpleName()) + " must not be null (in Holder).");
    }

    private void notEmptyArgument(String object, String message) throws FaultMessage {
        if (StringUtils.isEmpty((String)object)) {
            throw this.createIllegalArgumentFault(message);
        }
    }

    private void notNullArgument(Object object, String message) throws FaultMessage {
        if (object == null) {
            throw this.createIllegalArgumentFault(message);
        }
    }

    private FaultMessage createIllegalArgumentFault(String message) {
        IllegalArgumentFaultType faultType = new IllegalArgumentFaultType();
        return new FaultMessage(message, (FaultType)faultType);
    }

    private FaultMessage createSystemFault(Exception ex, OperationResult result) {
        if (result != null) {
            result.recordFatalError(ex.getMessage(), (Throwable)ex);
        }
        Object faultType = ex instanceof ObjectNotFoundException ? new ObjectNotFoundFaultType() : (ex instanceof IllegalArgumentException ? new IllegalArgumentFaultType() : new SystemFaultType());
        faultType.setMessage(ex.getMessage());
        if (result != null) {
            faultType.setOperationResult(result.createOperationResultType());
        }
        return new FaultMessage(ex.getMessage(), (FaultType)faultType, (Throwable)ex);
    }

    public TaskType importFromResource(String resourceOid, QName objectClass) throws FaultMessage {
        this.notEmptyArgument(resourceOid, "Resource oid must not be null or empty.");
        this.notNullArgument(objectClass, "Object class must not be null.");
        Task task = this.taskManager.createTaskInstance(ModelPort.IMPORT_FROM_RESOURCE);
        this.setTaskOwner(task);
        OperationResult operationResult = task.getResult();
        try {
            this.model.importAccountsFromResource(resourceOid, objectClass, task, operationResult);
            operationResult.computeStatus();
            return this.handleTaskResult(task);
        }
        catch (Exception ex) {
            LoggingUtils.logException((Trace)LOGGER, (String)"# MODEL importFromResource() failed", (Throwable)ex, (Object[])new Object[0]);
            throw this.createSystemFault(ex, operationResult);
        }
    }

    private void setTaskOwner(Task task) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new SystemException("Failed to get authentication object");
        }
        UserType userType = (UserType)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (userType == null) {
            throw new SystemException("Failed to get user from authentication object");
        }
        task.setOwner(userType.asPrismObject());
    }

    private Task createTaskInstance(String operationName) {
        return this.taskManager.createTaskInstance(operationName);
    }

    private TaskType handleTaskResult(Task task) {
        return (TaskType)task.getTaskPrismObject().asObjectable();
    }
}

