/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model;

import com.evolveum.midpoint.common.refinery.RefinedAccountDefinition;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.synchronizer.AccountConstruction;
import com.evolveum.midpoint.model.synchronizer.PropertyValueWithOrigin;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.DeltaSetTriple;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;

public class AccountSyncContext
implements Dumpable,
DebugDumpable {
    private ResourceAccountType resourceAccountType;
    private String oid;
    private PrismObject<AccountShadowType> accountOld;
    private PrismObject<AccountShadowType> accountNew;
    private ObjectDelta<AccountShadowType> accountSyncDelta;
    private ObjectDelta<AccountShadowType> accountPrimaryDelta;
    private ObjectDelta<AccountShadowType> accountSecondaryDelta;
    private boolean fullAccount = false;
    private PrismValueDeltaSetTriple<PrismPropertyValue<AccountConstruction>> accountConstructionDeltaSetTriple;
    private AccountConstruction outboundAccountConstruction;
    private Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedAttributes;
    private ResourceType resource;
    private boolean isAssigned;
    private PolicyDecision policyDecision;
    private boolean doReconciliation;
    private int iteration;
    private String iterationToken;
    private PrismContext prismContext;

    AccountSyncContext(ResourceAccountType resourceAccountType, PrismContext prismContext) {
        if (resourceAccountType == null) {
            throw new IllegalArgumentException("No resourceAccountType");
        }
        if (prismContext == null) {
            throw new IllegalArgumentException("No prismContext");
        }
        this.resourceAccountType = resourceAccountType;
        this.isAssigned = false;
        this.prismContext = prismContext;
    }

    public ObjectDelta<AccountShadowType> getAccountSyncDelta() {
        return this.accountSyncDelta;
    }

    public void setAccountSyncDelta(ObjectDelta<AccountShadowType> accountSyncDelta) {
        this.accountSyncDelta = accountSyncDelta;
    }

    public boolean isDoReconciliation() {
        return this.doReconciliation;
    }

    public void setDoReconciliation(boolean doReconciliation) {
        this.doReconciliation = doReconciliation;
    }

    public ResourceAccountType getResourceAccountType() {
        return this.resourceAccountType;
    }

    public PrismObject<AccountShadowType> getAccountOld() {
        return this.accountOld;
    }

    public void setAccountOld(PrismObject<AccountShadowType> accountOld) {
        this.accountOld = accountOld;
    }

    public PrismObject<AccountShadowType> getAccountNew() {
        return this.accountNew;
    }

    public void setAccountNew(PrismObject<AccountShadowType> accountNew) {
        this.accountNew = accountNew;
    }

    public ObjectDelta<AccountShadowType> getAccountPrimaryDelta() {
        return this.accountPrimaryDelta;
    }

    public void setAccountPrimaryDelta(ObjectDelta<AccountShadowType> accountPrimaryDelta) {
        this.accountPrimaryDelta = accountPrimaryDelta;
    }

    public void addAccountPrimaryDelta(ObjectDelta<AccountShadowType> accountDelta) throws SchemaException {
        if (this.accountPrimaryDelta == null) {
            this.accountPrimaryDelta = accountDelta;
        } else {
            this.accountPrimaryDelta.merge(accountDelta);
        }
    }

    public void addAccountSecondaryDelta(ObjectDelta<AccountShadowType> accountDelta) throws SchemaException {
        if (this.accountSecondaryDelta == null) {
            this.accountSecondaryDelta = accountDelta;
        } else {
            this.accountSecondaryDelta.merge(accountDelta);
        }
    }

    public void addAccountSyncDelta(ObjectDelta<AccountShadowType> accountDelta) throws SchemaException {
        if (this.accountSyncDelta == null) {
            this.accountSyncDelta = accountDelta;
        } else {
            this.accountSyncDelta.merge(accountDelta);
        }
    }

    public ObjectDelta<AccountShadowType> getAccountSecondaryDelta() {
        return this.accountSecondaryDelta;
    }

    public void setAccountSecondaryDelta(ObjectDelta<AccountShadowType> accountSecondaryDelta) {
        this.accountSecondaryDelta = accountSecondaryDelta;
    }

    public void addToSecondaryDelta(PropertyDelta accountPasswordDelta) throws SchemaException {
        if (this.accountSecondaryDelta == null) {
            this.accountSecondaryDelta = new ObjectDelta(AccountShadowType.class, ChangeType.MODIFY);
            this.accountSecondaryDelta.setOid(this.oid);
        }
        this.accountSecondaryDelta.swallow((ItemDelta)accountPasswordDelta);
    }

    public ObjectDelta<AccountShadowType> getAccountDelta() throws SchemaException {
        return ObjectDelta.union((ObjectDelta[])new ObjectDelta[]{this.accountPrimaryDelta, this.accountSecondaryDelta});
    }

    public boolean isAdd() {
        if (this.policyDecision == PolicyDecision.ADD) {
            return true;
        }
        if (ObjectDelta.isAdd(this.accountPrimaryDelta)) {
            return true;
        }
        return ObjectDelta.isAdd(this.accountSecondaryDelta);
    }

    public boolean isDelete() {
        if (this.policyDecision == PolicyDecision.DELETE) {
            return true;
        }
        if (ObjectDelta.isDelete(this.accountPrimaryDelta)) {
            return true;
        }
        return ObjectDelta.isDelete(this.accountSecondaryDelta);
    }

    public ResourceType getResource() {
        return this.resource;
    }

    public void setResource(ResourceType resource) {
        this.resource = resource;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
        if (this.accountPrimaryDelta != null) {
            this.accountPrimaryDelta.setOid(oid);
        }
        if (this.accountSecondaryDelta != null) {
            this.accountSecondaryDelta.setOid(oid);
        }
        if (this.accountNew != null) {
            this.accountNew.setOid(oid);
        }
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public void setAssigned(boolean isAssigned) {
        this.isAssigned = isAssigned;
    }

    public PolicyDecision getPolicyDecision() {
        return this.policyDecision;
    }

    public void setPolicyDecision(PolicyDecision policyDecision) {
        this.policyDecision = policyDecision;
    }

    public int getIteration() {
        return this.iteration;
    }

    public void setIteration(int iteration) {
        this.iteration = iteration;
    }

    public String getIterationToken() {
        return this.iterationToken;
    }

    public void setIterationToken(String iterationToken) {
        this.iterationToken = iterationToken;
    }

    public boolean isFullAccount() {
        return this.fullAccount;
    }

    public void setFullAccount(boolean fullAccount) {
        this.fullAccount = fullAccount;
    }

    public PrismValueDeltaSetTriple<PrismPropertyValue<AccountConstruction>> getAccountConstructionDeltaSetTriple() {
        return this.accountConstructionDeltaSetTriple;
    }

    public void setAccountConstructionDeltaSetTriple(PrismValueDeltaSetTriple<PrismPropertyValue<AccountConstruction>> accountConstructionDeltaSetTriple) {
        this.accountConstructionDeltaSetTriple = accountConstructionDeltaSetTriple;
    }

    public AccountConstruction getOutboundAccountConstruction() {
        return this.outboundAccountConstruction;
    }

    public void setOutboundAccountConstruction(AccountConstruction outboundAccountConstruction) {
        this.outboundAccountConstruction = outboundAccountConstruction;
    }

    public Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> getSqueezedAttributes() {
        return this.squeezedAttributes;
    }

    public void setSqueezedAttributes(Map<QName, DeltaSetTriple<PropertyValueWithOrigin>> squeezedAttributes) {
        this.squeezedAttributes = squeezedAttributes;
    }

    public ResourceAccountTypeDefinitionType getResourceAccountTypeDefinitionType() {
        ResourceAccountTypeDefinitionType def = ResourceTypeUtil.getResourceAccountTypeDefinitionType((ResourceType)this.resource, (String)this.resourceAccountType.getAccountType());
        return def;
    }

    private ResourceSchema getResourceSchema() throws SchemaException {
        return RefinedResourceSchema.getResourceSchema((ResourceType)this.resource, (PrismContext)this.prismContext);
    }

    public void recomputeAccountNew() throws SchemaException {
        PrismObject accountToAdd;
        ObjectDelta<AccountShadowType> accDelta = this.getAccountDelta();
        PrismObject oldAccount = this.accountOld;
        if (oldAccount == null && this.accountSyncDelta != null && ChangeType.ADD.equals((Object)this.accountSyncDelta.getChangeType()) && (accountToAdd = this.accountSyncDelta.getObjectToAdd()) != null) {
            PrismObjectDefinition objectDefinition = accountToAdd.getDefinition();
            oldAccount = new PrismObject(accountToAdd.getName(), objectDefinition, this.prismContext);
            oldAccount = this.accountSyncDelta.computeChangedObject(oldAccount);
        }
        if (accDelta == null) {
            this.accountNew = oldAccount;
            return;
        }
        this.accountNew = accDelta.computeChangedObject(oldAccount);
        this.fixAccount(this.accountNew);
    }

    public void fixAccounts() throws SchemaException {
        this.fixAccount(this.accountOld);
        this.fixAccount(this.accountNew);
    }

    private void fixAccount(PrismObject<AccountShadowType> account) throws SchemaException {
        if (account == null) {
            return;
        }
        ResourceObjectShadowUtil.fixShadow(account, (ResourceSchema)this.getResourceSchema());
    }

    public RefinedAccountDefinition getRefinedAccountDefinition() throws SchemaException {
        RefinedResourceSchema refinedSchema = RefinedResourceSchema.getRefinedSchema((ResourceType)this.resource, (PrismContext)this.prismContext);
        return refinedSchema.getAccountDefinition(this.getResourceAccountType().getAccountType());
    }

    public void clearIntermediateResults() {
        this.accountConstructionDeltaSetTriple = null;
        this.outboundAccountConstruction = null;
        this.squeezedAttributes = null;
    }

    public void checkConsistence() {
        if (this.resource == null) {
            throw new IllegalStateException("Null resource in " + this);
        }
        if (this.resourceAccountType == null) {
            throw new IllegalStateException("Null resource account type in " + this);
        }
        if (this.prismContext == null) {
            throw new IllegalStateException("Null prism context in " + this);
        }
        if (this.accountOld != null) {
            this.checkConsistence(this.accountOld, "old account");
        }
        if (this.accountPrimaryDelta != null) {
            try {
                this.accountPrimaryDelta.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in account primary delta in " + this, e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in account primary delta in " + this, e);
            }
        }
        if (this.accountSecondaryDelta != null) {
            try {
                boolean requireOid = this.accountPrimaryDelta == null;
                this.accountSecondaryDelta.checkConsistence(requireOid);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in account secondary delta in " + this, e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in account secondary delta in " + this, e);
            }
        }
        if (this.accountSyncDelta != null) {
            try {
                this.accountSyncDelta.checkConsistence();
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in account sync delta in " + this, e);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in account sync delta in " + this, e);
            }
        }
        if (this.accountNew != null) {
            this.checkConsistence(this.accountNew, "new account");
        }
    }

    private void checkConsistence(PrismObject<AccountShadowType> account, String desc) {
        try {
            account.checkConsistence();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.valueOf(e.getMessage()) + "; in " + desc + " in " + this, e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(String.valueOf(e.getMessage()) + "; in " + desc + " in " + this, e);
        }
        if (account.getDefinition() == null) {
            throw new IllegalStateException("No new account definition " + desc + " in " + this);
        }
        PrismReference resourceRef = account.findReference(AccountShadowType.F_RESOURCE_REF);
        if (resourceRef == null) {
            throw new IllegalStateException("No resourceRef in " + desc + " in " + this);
        }
        if (StringUtils.isBlank((String)resourceRef.getOid())) {
            throw new IllegalStateException("Null or empty OID in resourceRef in " + desc + " in " + this);
        }
        AccountShadowType accountType = (AccountShadowType)account.asObjectable();
        if (accountType.getObjectClass() == null) {
            throw new IllegalStateException("Null objectClass in " + desc + " in " + this);
        }
    }

    public String getHumanReadableAccountName() {
        StringBuilder sb = new StringBuilder();
        sb.append("account(");
        String humanReadableAccountIdentifier = this.getHumanReadableAccountIdentifier();
        if (StringUtils.isEmpty((String)humanReadableAccountIdentifier)) {
            sb.append("no ID");
        } else {
            sb.append("ID ");
            sb.append(humanReadableAccountIdentifier);
        }
        sb.append(", type '");
        sb.append(this.getResourceAccountType().getAccountType());
        sb.append("', ");
        sb.append(this.getResource());
        sb.append(")");
        return sb.toString();
    }

    private String getHumanReadableAccountIdentifier() {
        PrismObject<AccountShadowType> account = this.getAccountNew();
        if (account == null) {
            account = this.getAccountOld();
        }
        if (account == null) {
            return null;
        }
        Collection identifiers = ResourceObjectShadowUtil.getIdentifiers(account);
        if (identifiers == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = identifiers.iterator();
        while (iterator.hasNext()) {
            ResourceAttribute id = (ResourceAttribute)iterator.next();
            sb.append(id.getHumanReadableDump());
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AccountSyncContext(");
        sb.append("OID: ").append(this.oid);
        sb.append(", RAT: ").append(this.resourceAccountType);
        sb.append(")");
        return sb.toString();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        return this.debugDump(indent, true);
    }

    public String debugDump(int indent, boolean showTriples) {
        StringBuilder sb = new StringBuilder();
        SchemaDebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("OID: ").append(this.oid);
        if (this.fullAccount) {
            sb.append(", full");
        } else {
            sb.append(", shadow");
        }
        sb.append(", assigned=").append(this.isAssigned);
        sb.append(", recon=").append(this.doReconciliation);
        sb.append(", decision=").append((Object)this.policyDecision);
        if (this.iteration != 0) {
            sb.append(", iteration=").append(this.iteration);
        }
        sb.append("\n");
        DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT old", this.accountOld, (int)indent);
        sb.append("\n");
        DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT new", this.accountNew, (int)indent);
        sb.append("\n");
        DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT primary delta", this.accountPrimaryDelta, (int)indent);
        sb.append("\n");
        DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT secondary delta", this.accountSecondaryDelta, (int)indent);
        sb.append("\n");
        DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT sync delta", this.accountSyncDelta, (int)indent);
        if (showTriples) {
            sb.append("\n");
            DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT accountConstructionDeltaSetTriple", this.accountConstructionDeltaSetTriple, (int)indent);
            sb.append("\n");
            DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT outbound account construction", (DebugDumpable)this.outboundAccountConstruction, (int)indent);
            sb.append("\n");
            DebugUtil.debugDumpWithLabel((StringBuilder)sb, (String)"ACCOUNT squeezed attributes", this.squeezedAttributes, (int)indent);
        }
        return sb.toString();
    }

    public String dump() {
        return this.debugDump();
    }
}

