/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SchemaDescription
implements Dumpable {
    private String path;
    private String usualPrefix;
    private String namespace;
    private String sourceDescription;
    private InputStreamable streamable;
    private Node node;
    private boolean isPrismSchema = false;
    private boolean isDefault = false;
    private PrismSchema schema;
    private Package compileTimeClassesPackage;
    private Map<QName, Class<?>> xsdTypeTocompileTimeClassMap;

    private SchemaDescription(String sourceDescription) {
        this.sourceDescription = sourceDescription;
    }

    public String getPath() {
        return this.path;
    }

    public void setResourcePath(String path) {
        this.path = path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUsualPrefix() {
        return this.usualPrefix;
    }

    public void setUsualPrefix(String usualPrefix) {
        this.usualPrefix = usualPrefix;
    }

    public String getSourceDescription() {
        return this.sourceDescription;
    }

    public void setSourceDescription(String sourceDescription) {
        this.sourceDescription = sourceDescription;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isPrismSchema() {
        return this.isPrismSchema;
    }

    public void setPrismSchema(boolean isMidPointSchema) {
        this.isPrismSchema = isMidPointSchema;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public PrismSchema getSchema() {
        return this.schema;
    }

    public void setSchema(PrismSchema schema) {
        this.schema = schema;
    }

    public Package getCompileTimeClassesPackage() {
        return this.compileTimeClassesPackage;
    }

    public void setCompileTimeClassesPackage(Package compileTimeClassesPackage) {
        this.compileTimeClassesPackage = compileTimeClassesPackage;
    }

    public Map<QName, Class<?>> getXsdTypeTocompileTimeClassMap() {
        return this.xsdTypeTocompileTimeClassMap;
    }

    public void setXsdTypeTocompileTimeClassMap(Map<QName, Class<?>> xsdTypeTocompileTimeClassMap) {
        this.xsdTypeTocompileTimeClassMap = xsdTypeTocompileTimeClassMap;
    }

    public static SchemaDescription parseResource(final String resourcePath) throws SchemaException {
        SchemaDescription desc = new SchemaDescription("system resource " + resourcePath);
        desc.path = resourcePath;
        desc.streamable = new InputStreamable(){

            @Override
            public InputStream openInputStream() {
                InputStream inputStream = SchemaRegistry.class.getClassLoader().getResourceAsStream(resourcePath);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot fetch system resource for schema " + resourcePath);
                }
                return inputStream;
            }
        };
        desc.parseFromInputStream();
        return desc;
    }

    public static SchemaDescription parseFile(final File file) throws FileNotFoundException, SchemaException {
        SchemaDescription desc = new SchemaDescription("file " + file.getPath());
        desc.path = file.getPath();
        desc.streamable = new InputStreamable(){

            @Override
            public InputStream openInputStream() {
                FileInputStream inputStream;
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {
                    throw new IllegalStateException("Cannot fetch file for schema " + file, e);
                }
                return inputStream;
            }
        };
        desc.parseFromInputStream();
        return desc;
    }

    private void parseFromInputStream() throws SchemaException {
        InputStream inputStream = this.streamable.openInputStream();
        try {
            this.node = DOMUtil.parse((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new SchemaException("Cannot parse schema from " + this.sourceDescription, (Throwable)e);
        }
        this.fetchBasicInfoFromSchema();
    }

    public static SchemaDescription parseNode(Node node, String sourceDescription) throws SchemaException {
        SchemaDescription desc = new SchemaDescription(sourceDescription);
        desc.node = node;
        desc.fetchBasicInfoFromSchema();
        return desc;
    }

    private void fetchBasicInfoFromSchema() throws SchemaException {
        String targetNamespace;
        Element rootElement = this.getDomElement();
        if (DOMUtil.XSD_SCHEMA_ELEMENT.equals(DOMUtil.getQName((Node)rootElement))) {
            targetNamespace = rootElement.getAttributeNS(DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getNamespaceURI(), DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getLocalPart());
            if (StringUtils.isEmpty((String)targetNamespace)) {
                targetNamespace = rootElement.getAttribute(DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getLocalPart());
            }
            if (targetNamespace == null) {
                throw new SchemaException("Schema " + this.sourceDescription + " does not have targetNamespace attribute");
            }
        } else {
            throw new SchemaException("Schema " + this.sourceDescription + " does not start with xsd:schema element");
        }
        this.namespace = targetNamespace;
    }

    public boolean canInputStream() {
        return this.streamable != null;
    }

    public InputStream openInputStream() {
        if (!this.canInputStream()) {
            throw new IllegalStateException("Schema " + this.sourceDescription + " cannot provide input stream");
        }
        return this.streamable.openInputStream();
    }

    public Source getSource() {
        Source source = null;
        if (this.canInputStream()) {
            InputStream inputStream = this.openInputStream();
            source = new StreamSource(inputStream);
        } else {
            source = new DOMSource(this.node);
        }
        source.setSystemId(this.path);
        return source;
    }

    public Element getDomElement() {
        if (this.node instanceof Element) {
            return (Element)this.node;
        }
        return DOMUtil.getFirstChildElement((Node)this.node);
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.path);
        if (this.schema != null) {
            sb.append(" ");
            sb.append(this.schema.toString());
        }
        return sb.toString();
    }

    private static interface InputStreamable {
        public InputStream openInputStream();
    }
}

