/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.polystring;

import com.evolveum.midpoint.prism.polystring.PolyStringNormalizer;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import java.io.Serializable;

public class PolyString
implements Dumpable,
DebugDumpable,
Serializable {
    private String orig;
    private String norm = null;

    public PolyString(String orig) {
        this.orig = orig;
    }

    public PolyString(String orig, String norm) {
        this.orig = orig;
        this.norm = norm;
    }

    public String getOrig() {
        return this.orig;
    }

    public String getNorm() {
        return this.norm;
    }

    public void recompute(PolyStringNormalizer normalizer) {
        this.norm = normalizer.normalize(this.orig);
    }

    public boolean isComputed() {
        return this.norm != null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.norm == null ? 0 : this.norm.hashCode());
        result = 31 * result + (this.orig == null ? 0 : this.orig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolyString other = (PolyString)obj;
        if (this.norm == null ? other.norm != null : !this.norm.equals(other.norm)) {
            return false;
        }
        return !(this.orig == null ? other.orig != null : !this.orig.equals(other.orig));
    }

    public String toString() {
        return this.orig;
    }

    public String dump() {
        return this.debugDump();
    }

    public String debugDump() {
        return this.debugDump(0);
    }

    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        DebugUtil.indentDebugDump((StringBuilder)sb, (int)indent);
        sb.append("PolyString(");
        sb.append(this.orig);
        if (this.norm != null) {
            sb.append(",");
            sb.append(this.norm);
        }
        sb.append(")");
        return sb.toString();
    }
}

